/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.role;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.SystemEntity;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.RepositoryFactory;

public class OperationRequiredRoleCreator
extends SystemEntity {
    private OperationInterface requiredInterface;

    public OperationRequiredRoleCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public OperationRequiredRoleCreator withRequiredInterface(OperationInterface operationInterface) {
        IllegalArgumentException.throwIfNull(operationInterface, "The given Interface must not be null.");
        this.requiredInterface = operationInterface;
        return this;
    }

    public OperationRequiredRoleCreator withRequiredInterface(String name) throws NoSuchElementException {
        OperationInterface operationInterface;
        try {
            operationInterface = (OperationInterface)this.system.getInterfaceByName(name);
        }
        catch (ClassCastException e) {
            throw new NoSuchElementException(String.format("An Interface with name '%s' was found, but it was not an OperationInterface. Please make sure all names are unique.", name), e);
        }
        return this.withRequiredInterface(operationInterface);
    }

    public OperationRequiredRole build() {
        OperationRequiredRole role = RepositoryFactory.eINSTANCE.createOperationRequiredRole();
        if (this.name != null) {
            role.setEntityName(this.name);
        }
        role.setRequiredInterface__OperationRequiredRole(this.requiredInterface);
        return role;
    }

    @Override
    public OperationRequiredRoleCreator withName(String name) {
        return (OperationRequiredRoleCreator)super.withName(name);
    }
}

