/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.usagemodel.structure.UsageModelEntity;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.ScenarioBehaviourCreator;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;

public class BranchTransitionCreator
extends UsageModelEntity {
    private double probability = 0.0;
    private ScenarioBehaviour branchedBeh;

    public BranchTransitionCreator(ScenarioBehaviourCreator branchedBehaviour) {
        this.addToBranchTransition(branchedBehaviour);
    }

    protected BranchTransition build() {
        BranchTransition branchT = UsagemodelFactory.eINSTANCE.createBranchTransition();
        branchT.setBranchProbability(this.probability);
        if (this.branchedBeh != null) {
            branchT.setBranchedBehaviour_BranchTransition(this.branchedBeh);
        }
        return branchT;
    }

    private BranchTransitionCreator addToBranchTransition(ScenarioBehaviourCreator branchedBehaviour) {
        IllegalArgumentException.throwIfNull(branchedBehaviour, "The branched Behavoiur must not be null");
        this.branchedBeh = branchedBehaviour.build();
        return this;
    }

    public BranchTransitionCreator withProbability(double probability) {
        this.probability = probability;
        return this;
    }
}

