/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.components.seff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.GeneralAction;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffCreator;
import org.palladiosimulator.generator.fluent.repository.structure.internals.ResourceSignature;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.shared.structure.ProcessingResource;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.reliability.InternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.reliability.ReliabilityFactory;
import org.palladiosimulator.pcm.reliability.SoftwareInducedFailureType;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.SeffFactory;

public class InternalActionCreator
extends GeneralAction {
    private final List<InternalFailureOccurrenceDescription> failures;

    protected InternalActionCreator(SeffCreator seff) {
        this.seff = seff;
        this.demands = new ArrayList();
        this.failures = new ArrayList<InternalFailureOccurrenceDescription>();
        this.infrastructureCalls = new ArrayList();
        this.resourceCalls = new ArrayList();
    }

    @Override
    public InternalActionCreator withName(String name) {
        return (InternalActionCreator)super.withName(name);
    }

    public InternalActionCreator withInternalFailureOccurrenceDescription(double failureProbability, SoftwareInducedFailureType failureType) {
        IllegalArgumentException.throwIfNull(failureType, "failureType must not be null");
        InternalFailureOccurrenceDescription failure = ReliabilityFactory.eINSTANCE.createInternalFailureOccurrenceDescription();
        failure.setFailureProbability(failureProbability);
        failure.setSoftwareInducedFailureType__InternalFailureOccurrenceDescription(failureType);
        this.failures.add(failure);
        return this;
    }

    @Override
    public InternalActionCreator withResourceDemand(String specificationStochasticExpression, ProcessingResource processingResource) {
        return (InternalActionCreator)super.withResourceDemand(specificationStochasticExpression, processingResource);
    }

    @Override
    public InternalActionCreator withInfrastructureCall(String numberOfCallsStochasticExpression, InfrastructureSignature signature, InfrastructureRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (InternalActionCreator)super.withInfrastructureCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    @Override
    public InternalActionCreator withResourceCall(String numberOfCallsStochasticExpression, ResourceSignature signature, ResourceRequiredRole requiredRole, VariableUsageCreator ... variableUsages) {
        return (InternalActionCreator)super.withResourceCall(numberOfCallsStochasticExpression, signature, requiredRole, variableUsages);
    }

    protected InternalAction build() {
        InternalAction action = SeffFactory.eINSTANCE.createInternalAction();
        if (this.name != null) {
            action.setEntityName(this.name);
        }
        action.getInternalFailureOccurrenceDescriptions__InternalAction().addAll(this.failures);
        action.getResourceDemand_Action().addAll((Collection)this.demands);
        action.getInfrastructureCall__Action().addAll((Collection)this.infrastructureCalls);
        action.getResourceCall__Action().addAll((Collection)this.resourceCalls);
        return action;
    }
}

