/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.repository.structure.interfaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.palladiosimulator.generator.fluent.repository.structure.RepositoryCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.InfrastructureSignatureCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.Interface;
import org.palladiosimulator.pcm.parameter.VariableCharacterisationType;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.Signature;

public class InfrastructureInterfaceCreator
extends Interface {
    private final List<InfrastructureSignature> signatures;

    public InfrastructureInterfaceCreator(RepositoryCreator repo) {
        this.repository = repo;
        this.signatures = new ArrayList<InfrastructureSignature>();
    }

    @Override
    public InfrastructureInterfaceCreator withName(String name) {
        return (InfrastructureInterfaceCreator)super.withName(name);
    }

    @Override
    public InfrastructureInterfaceCreator conforms(org.palladiosimulator.pcm.repository.Interface interfce) {
        return (InfrastructureInterfaceCreator)super.conforms(interfce);
    }

    @Override
    public InfrastructureInterfaceCreator withRequiredCharacterisation(Parameter parameter, VariableCharacterisationType type) {
        return (InfrastructureInterfaceCreator)super.withRequiredCharacterisation(parameter, type);
    }

    public InfrastructureInterfaceCreator withInfrastructureSignature(InfrastructureSignatureCreator signature) {
        InfrastructureSignature build = signature.build();
        this.repository.addSignature((Signature)build);
        this.signatures.add(build);
        return this;
    }

    public InfrastructureInterface build() {
        InfrastructureInterface interfce = RepositoryFactory.eINSTANCE.createInfrastructureInterface();
        if (this.name != null) {
            interfce.setEntityName(this.name);
        }
        interfce.getInfrastructureSignatures__InfrastructureInterface().addAll(this.signatures);
        interfce.getParentInterfaces__Interface().addAll((Collection)this.parentInterfaces);
        interfce.getRequiredCharacterisations().addAll((Collection)this.requiredCharacterisations);
        return interfce;
    }

    protected void addInfrastructureSignatures(InfrastructureSignature signature) {
        this.signatures.add(signature);
    }
}

