/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.shared.components;

import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.StoexFactory;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.shared.structure.Entity;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.parameter.ParameterFactory;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableCharacterisationType;
import org.palladiosimulator.pcm.parameter.VariableUsage;

public class VariableUsageCreator
extends Entity {
    private AbstractNamedReference reference;
    private final List<VariableCharacterisation> variableCharacterisations = new ArrayList<VariableCharacterisation>();

    public VariableUsageCreator() {
    }

    public VariableUsageCreator(String reference, String ... innerReferences) {
        this.withNamespaceReference(reference, innerReferences);
    }

    public VariableUsageCreator(String reference) {
        this.withVariableReference(reference);
    }

    @Override
    public VariableUsageCreator withName(String name) {
        return (VariableUsageCreator)super.withName(name);
    }

    public VariableUsageCreator withVariableCharacterisation(String specificationStochasticExpression, VariableCharacterisationType type) {
        IllegalArgumentException.throwIfNull(specificationStochasticExpression, "specification_stochasticExpression must not be null");
        IllegalArgumentException.throwIfNull(type, "type must not be null");
        VariableCharacterisation varchar = ParameterFactory.eINSTANCE.createVariableCharacterisation();
        PCMRandomVariable rand = CoreFactory.eINSTANCE.createPCMRandomVariable();
        rand.setSpecification(specificationStochasticExpression);
        varchar.setSpecification_VariableCharacterisation(rand);
        varchar.setType(type);
        this.variableCharacterisations.add(varchar);
        return this;
    }

    public VariableUsageCreator withVariableReference(String reference) {
        IllegalArgumentException.throwIfNull(reference, "reference must not be null");
        VariableReference variableReference = StoexFactory.eINSTANCE.createVariableReference();
        variableReference.setReferenceName(reference);
        this.reference = variableReference;
        return this;
    }

    public VariableUsageCreator withNamespaceReference(String reference, String ... innerReferences) {
        IllegalArgumentException.throwIfNull(reference, "reference must not be null");
        if (innerReferences != null && innerReferences.length > 0) {
            String[] stringArray = innerReferences;
            int n = innerReferences.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                IllegalArgumentException.throwIfNull(element, "inner references must not be null");
                ++n2;
            }
        }
        if (innerReferences != null && innerReferences.length > 0) {
            String string = innerReferences[innerReferences.length - 1];
            VariableReference variableReference = StoexFactory.eINSTANCE.createVariableReference();
            variableReference.setReferenceName(string);
            LinkedList<String> asList = new LinkedList<String>(Arrays.asList(innerReferences));
            asList.remove(asList.size() - 1);
            asList.add(0, reference);
            this.reference = this.rec((AbstractNamedReference)variableReference, asList);
        } else {
            NamespaceReference namespaceReference = StoexFactory.eINSTANCE.createNamespaceReference();
            namespaceReference.setReferenceName(reference);
            this.reference = namespaceReference;
        }
        return this;
    }

    private AbstractNamedReference rec(AbstractNamedReference ref, List<String> refs) {
        if (refs.isEmpty()) {
            return ref;
        }
        String string = refs.get(refs.size() - 1);
        NamespaceReference namespaceReference = StoexFactory.eINSTANCE.createNamespaceReference();
        namespaceReference.setReferenceName(string);
        namespaceReference.setInnerReference_NamespaceReference(ref);
        refs.remove(refs.size() - 1);
        return this.rec((AbstractNamedReference)namespaceReference, refs);
    }

    public VariableUsage build() {
        VariableUsage varUsage = ParameterFactory.eINSTANCE.createVariableUsage();
        if (this.reference != null) {
            varUsage.setNamedReference__VariableUsage(this.reference);
        }
        varUsage.getVariableCharacterisation_VariableUsage().addAll(this.variableCharacterisations);
        return varUsage;
    }
}

