/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.event;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.SystemCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.AbstractConnectorCreator;
import org.palladiosimulator.generator.fluent.system.structure.connector.event.SourceRoleSelector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.EventChannel;
import org.palladiosimulator.pcm.core.composition.EventChannelSourceConnector;
import org.palladiosimulator.pcm.repository.SourceRole;

public class EventChannelSourceConnectorCreator
extends AbstractConnectorCreator {
    private EventChannel eventChannel;
    private AssemblyContext assemblyContext;
    private SourceRole role;

    public EventChannelSourceConnectorCreator(SystemCreator systemCreator) {
        this.system = systemCreator;
    }

    public EventChannelSourceConnectorCreator withEventChannel(EventChannel eventChannel) {
        IllegalArgumentException.throwIfNull(eventChannel, "The given EventChannel must not be null.");
        this.eventChannel = eventChannel;
        return this;
    }

    public EventChannelSourceConnectorCreator withEventChannel(String name) throws NoSuchElementException {
        EventChannel channel = this.system.getEventChannelByName(name);
        return this.withEventChannel(channel);
    }

    public SourceRoleSelector<EventChannelSourceConnectorCreator> withAssemblyContext(AssemblyContext assemblyContext) {
        IllegalArgumentException.throwIfNull(assemblyContext, "The given AssemblyContext must not be null.");
        return new SourceRoleSelector<EventChannelSourceConnectorCreator>((context, role) -> {
            this.assemblyContext = context;
            this.role = role;
            return this;
        }, assemblyContext);
    }

    public SourceRoleSelector<EventChannelSourceConnectorCreator> withAssemblyContext(String name) {
        AssemblyContext context = this.system.getAssemblyContextByName(name);
        return this.withAssemblyContext(context);
    }

    public EventChannelSourceConnector build() {
        EventChannelSourceConnector connector = CompositionFactory.eINSTANCE.createEventChannelSourceConnector();
        if (this.name != null) {
            connector.setEntityName(this.name);
        }
        connector.setEventChannel__EventChannelSourceConnector(this.eventChannel);
        connector.setAssemblyContext__EventChannelSourceConnector(this.assemblyContext);
        connector.setSourceRole__EventChannelSourceRole(this.role);
        return connector;
    }

    @Override
    public EventChannelSourceConnectorCreator withName(String name) {
        return (EventChannelSourceConnectorCreator)super.withName(name);
    }
}

