/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.infrastructure;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.connector.IContextRoleCombinator;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.RequiredRole;

public class InfrastructureRequiredRoleSelector<T> {
    private final IContextRoleCombinator<InfrastructureRequiredRole, T> combinator;
    private final AssemblyContext context;

    public InfrastructureRequiredRoleSelector(IContextRoleCombinator<InfrastructureRequiredRole, T> combinator, AssemblyContext context) {
        this.combinator = combinator;
        this.context = context;
    }

    public T withInfrastructureRequiredRole(InfrastructureRequiredRole role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        return this.combinator.combineContextAndRole(this.context, role);
    }

    public T withInfrastructureRequiredRole(String name) throws NoSuchElementException {
        RequiredRole role = this.context.getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity().stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No InfrastructureRequiredRole with name '%s' found.", name)));
        try {
            return this.withInfrastructureRequiredRole((InfrastructureRequiredRole)role);
        }
        catch (ClassCastException e) {
            throw new NoSuchElementException(String.format("A Role with name '%s' was found, but it was not an InfrastructureRequiredRole. Please make sure all names are unique.", name), e);
        }
    }
}

