/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.editor.sirius.javaactions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.palladiosimulator.editors.commons.dialogs.selection.PalladioSelectEObjectDialog;
import org.palladiosimulator.indirections.repository.DataInterface;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingRequiringEntity;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.Role;

public abstract class AddDataRole<T extends Role>
implements IExternalJavaAction {
    private static final String ROLE_PARAMETER_NAME = "instance";
    private static final Shell SHELL = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    private final String namePostExtension;

    public AddDataRole(String namePostExtension) {
        this.namePostExtension = namePostExtension;
    }

    protected abstract void setInterface(T var1, DataInterface var2);

    protected abstract Collection<T> getRelevantRoles(InterfaceProvidingRequiringEntity var1);

    public boolean canExecute(Collection<? extends EObject> arg0) {
        return true;
    }

    public void execute(Collection<? extends EObject> selection, Map<String, Object> parameters) {
        Role role = (Role)parameters.get(ROLE_PARAMETER_NAME);
        InterfaceProvidingRequiringEntity container = (InterfaceProvidingRequiringEntity)role.eContainer();
        DataInterface selectedInterface = this.getDataInterface(role);
        this.setInterface(role, selectedInterface);
        role.setEntityName(this.findRoleName(container, selectedInterface));
    }

    private String findRoleName(InterfaceProvidingRequiringEntity entity, DataInterface dInterface) {
        String interfaceName;
        String roleName = interfaceName = String.valueOf(dInterface.getEntityName()) + this.namePostExtension;
        int i = 1;
        while (this.checkExistingNames(entity, roleName)) {
            roleName = String.valueOf(interfaceName) + i;
            if (i == Integer.MAX_VALUE) {
                throw new IllegalStateException("Role Name Extension too big");
            }
            ++i;
        }
        return roleName;
    }

    private boolean checkExistingNames(InterfaceProvidingRequiringEntity entity, String interfaceName) {
        return this.getRelevantRoles(entity).stream().anyMatch(e -> interfaceName.equals(e.getEntityName()));
    }

    private DataInterface getDataInterface(Role role) {
        List<Object> filter = Arrays.asList(Repository.class, DataInterface.class);
        List additionalChildReferences = Collections.emptyList();
        PalladioSelectEObjectDialog dialog = new PalladioSelectEObjectDialog(SHELL, filter, additionalChildReferences, (Object)role.eResource().getResourceSet());
        dialog.setProvidedService(DataInterface.class);
        dialog.open();
        return (DataInterface)dialog.getResult();
    }
}

