/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.monitoring.simulizar;

import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.probes.TakeCurrentSimulationTimeProbe;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationTimeProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.measure.quantity.Duration;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory;
import org.palladiosimulator.edp2.models.measuringpoint.StringMeasuringPoint;
import org.palladiosimulator.indirections.actions.AnalyseStackAction;
import org.palladiosimulator.indirections.monitoring.IndirectionsMetricDescriptionConstants;
import org.palladiosimulator.indirections.monitoring.simulizar.MeasuringUtil;
import org.palladiosimulator.indirections.monitoring.simulizar.TriggeredCombiningProbe;
import org.palladiosimulator.indirections.monitoring.simulizar.TriggeredProxyProbe;
import org.palladiosimulator.indirectionsmeasuringpoint.IndirectionsmeasuringpointFactory;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.probeframework.calculator.ICalculatorFactory;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;

public class IndirectionMeasuringPointRegistry {
    private static final IndirectionsmeasuringpointFactory INDIRECTIONS_MEASURINGPOINT_FACTORY = IndirectionsmeasuringpointFactory.eINSTANCE;
    private static final MeasuringpointFactory MEASURINGPOINT_FACTORY = MeasuringpointFactory.eINSTANCE;
    public static final MeasuringPointRepository MEASURING_POINT_REPOSITORY = MEASURINGPOINT_FACTORY.createMeasuringPointRepository();
    private static Map<InterpreterDefaultContext, IndirectionMeasuringPointRegistry> registries = new HashMap<InterpreterDefaultContext, IndirectionMeasuringPointRegistry>();
    private final Map<AllocatedAction, TriggeredProxyProbe<Double, Duration>> actionToProbe = new HashMap<AllocatedAction, TriggeredProxyProbe<Double, Duration>>();
    private final ICalculatorFactory factory;
    private final SimuComModel myModel;
    public final TakeCurrentSimulationTimeProbe timeProbe;

    public static IndirectionMeasuringPointRegistry getInstanceFor(InterpreterDefaultContext mainContext) {
        registries.computeIfAbsent(mainContext, ctx -> new IndirectionMeasuringPointRegistry(ctx.getModel()));
        return registries.get(mainContext);
    }

    private IndirectionMeasuringPointRegistry(SimuComModel myModel) {
        this.myModel = myModel;
        this.factory = myModel.getProbeFrameworkContext().getCalculatorFactory();
        this.timeProbe = new TakeCurrentSimulationTimeProbe((ISimulationTimeProvider)myModel.getSimulationControl());
    }

    private TriggeredProxyProbe<Double, Duration> createProbe(AllocatedAction allocatedAction) {
        String measurementIdentficationkeyString = "";
        if (allocatedAction.action instanceof AnalyseStackAction) {
            measurementIdentficationkeyString = " (key = " + ((AnalyseStackAction)allocatedAction.action).getMeasurementIdentificationKey() + ")";
        }
        StringMeasuringPoint measuringPoint = MeasuringUtil.createStringMeasuringPoint(MEASURING_POINT_REPOSITORY, "Data age for " + allocatedAction.action.getEntityName() + " @ " + allocatedAction.assemblyContext.getEntityName() + measurementIdentficationkeyString);
        TriggeredProxyProbe<Double, Duration> dataAgeProxyProbe = new TriggeredProxyProbe<Double, Duration>(IndirectionsMetricDescriptionConstants.DATA_AGE_METRIC);
        TriggeredCombiningProbe dataAgeMetricSetProbeList = new TriggeredCombiningProbe((MetricDescription)IndirectionsMetricDescriptionConstants.DATA_AGE_METRIC_TUPLE, List.of(this.timeProbe, dataAgeProxyProbe), (TriggeredProbe)dataAgeProxyProbe);
        this.factory.buildExecutionResultCalculator((MeasuringPoint)measuringPoint, dataAgeMetricSetProbeList);
        return dataAgeProxyProbe;
    }

    public TriggeredProxyProbe<Double, Duration> getProbe(AnalyseStackAction action, AssemblyContext assemblyContext) {
        return this.actionToProbe.computeIfAbsent(new AllocatedAction((AbstractAction)action, assemblyContext), this::createProbe);
    }

    private static class AllocatedAction {
        public final AbstractAction action;
        public final AssemblyContext assemblyContext;

        public AllocatedAction(AbstractAction action, AssemblyContext assemblyContext) {
            this.action = action;
            this.assemblyContext = assemblyContext;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AllocatedAction other = (AllocatedAction)obj;
            return Objects.equals(this.action, other.action) && Objects.equals(this.assemblyContext, other.assemblyContext);
        }

        public int hashCode() {
            return Objects.hash(this.action, this.assemblyContext);
        }
    }
}

