/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.monitoring.simulizar;

import de.uka.ipd.sdq.simucomframework.core.resources.CalculatorHelper;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.indirections.util.StreamUtil;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.CaptureType;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.metricspec.metricentity.IMetricEntity;
import org.palladiosimulator.metricspec.util.builder.MetricSetDescriptionBuilder;
import org.palladiosimulator.metricspec.util.builder.MetricspecBuilders;
import org.palladiosimulator.probeframework.measurement.ProbeMeasurement;
import org.palladiosimulator.probeframework.probes.BasicEventProbe;
import org.palladiosimulator.probeframework.probes.EventProbe;
import org.palladiosimulator.probeframework.probes.EventProbeList;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.probeframework.probes.listener.IProbeListener;

public final class MetricDescriptionUtil {
    private static Map<NumericalBaseMetricDescription, MetricSetDescription> eventNumericalBaseMetricToMetricSet = new HashMap<NumericalBaseMetricDescription, MetricSetDescription>();
    private static Map<NumericalBaseMetricDescription, NumericalBaseMetricDescription> metricToAveragingMetric = new HashMap<NumericalBaseMetricDescription, NumericalBaseMetricDescription>();
    private static Map<NumericalBaseMetricDescription, NumericalBaseMetricDescription> metricToSummingMetric = new HashMap<NumericalBaseMetricDescription, NumericalBaseMetricDescription>();
    private static Map<NumericalBaseMetricDescription, MetricSetDescription> triggeredNumericalBaseMetricToMetricSet = new HashMap<NumericalBaseMetricDescription, MetricSetDescription>();

    public static Consumer<Consumer<IMeasureProvider>> attachToProbe(Probe probe) {
        Consumer<Consumer<IMeasureProvider>> register = it -> probe.addObserver(new IProbeListener((Consumer)it){
            private final /* synthetic */ Consumer val$it;
            {
                this.val$it = consumer;
            }

            public void newProbeMeasurementAvailable(ProbeMeasurement probeMeasurement) {
                this.val$it.accept(probeMeasurement.getMeasureProvider());
            }
        });
        return register;
    }

    private static NumericalBaseMetricDescription createAveragingMetric(NumericalBaseMetricDescription baseMetric) {
        return MetricspecBuilders.newNumericalBaseMetricDescriptionBuilder((NumericalBaseMetricDescription)baseMetric).id(EcoreUtil.generateUUID()).captureType(CaptureType.REAL_NUMBER).name(String.valueOf(baseMetric.getName()) + " Average").build();
    }

    private static MetricSetDescription createEventBaseMetricDescriptionWithTime(NumericalBaseMetricDescription baseMetricDescription) {
        return MetricSetDescriptionBuilder.newMetricSetDescriptionBuilder().name(String.valueOf(baseMetricDescription.getName()) + " over Time").textualDescription(String.valueOf(baseMetricDescription.getName()) + " over Time").id(EcoreUtil.generateUUID()).subsumedMetrics(Arrays.asList(baseMetricDescription, MetricDescriptionConstants.POINT_IN_TIME_METRIC)).build();
    }

    private static NumericalBaseMetricDescription createSummingMetric(NumericalBaseMetricDescription baseMetric) {
        return MetricspecBuilders.newNumericalBaseMetricDescriptionBuilder((NumericalBaseMetricDescription)baseMetric).id(EcoreUtil.generateUUID()).name(String.valueOf(baseMetric.getName()) + " Sum").build();
    }

    private static MetricSetDescription createTriggeredBaseMetricDescriptionWithTime(NumericalBaseMetricDescription baseMetricDescription) {
        return MetricSetDescriptionBuilder.newMetricSetDescriptionBuilder().name(String.valueOf(baseMetricDescription.getName()) + " over Time").textualDescription(String.valueOf(baseMetricDescription.getName()) + " over Time").id(EcoreUtil.generateUUID()).subsumedMetrics(Arrays.asList(MetricDescriptionConstants.POINT_IN_TIME_METRIC, baseMetricDescription)).build();
    }

    public static <EventSourceType, V, Q extends Quantity> EventProbeList deriveAverageProbe(final NumericalBaseMetricDescription metricDesciption, final ISimulationControl simulationControl, final Consumer<Consumer<IMeasureProvider>> register) {
        final NumericalBaseMetricDescription averagingMetric = MetricDescriptionUtil.getOrCreateAveragingMetric(metricDesciption);
        MetricSetDescription averagingMetricOverTime = MetricDescriptionUtil.getOrCreateEventBaseMetricDescriptionWithTime(averagingMetric);
        EventProbeList result = CalculatorHelper.getEventProbeSetWithCurrentTime((MetricSetDescription)averagingMetricOverTime, (ISimulationControl)simulationControl, (EventProbe)new BasicEventProbe<IMetricEntity, Double, Q>(null, (BaseMetricDescription)averagingMetric){

            public void notify_(double value) {
                this.notify(Measure.valueOf((double)value, (Unit)averagingMetric.getDefaultUnit()));
            }

            protected void registerListener() {
                register.accept(newMeasurement -> {
                    Measure measure = newMeasurement.getMeasureForMetric((MetricDescription)metricDesciption);
                    double currentTime = simulationControl.getCurrentSimulationTime();
                    if (currentTime >= 1.0) {
                        this.notify_(measure.doubleValue(averagingMetric.getDefaultUnit()) / currentTime);
                    }
                });
            }
        });
        return result;
    }

    public static <EventSourceType, V, Q extends Quantity> EventProbeList deriveSummingProbe(final NumericalBaseMetricDescription baseMetricDescription, ISimulationControl simulationControl, final Consumer<Consumer<IMeasureProvider>> register) {
        final NumericalBaseMetricDescription summingMetric = MetricDescriptionUtil.getOrCreateSummingMetric(baseMetricDescription);
        MetricSetDescription summingMetricOverTime = MetricDescriptionUtil.getOrCreateEventBaseMetricDescriptionWithTime(summingMetric);
        EventProbeList result = CalculatorHelper.getEventProbeSetWithCurrentTime((MetricSetDescription)summingMetricOverTime, (ISimulationControl)simulationControl, (EventProbe)new BasicEventProbe<IMetricEntity, Double, Q>(null, (BaseMetricDescription)summingMetric){
            private double sum;
            {
                super((Object)$anonymous0, $anonymous1);
                this.sum = 0.0;
            }

            public void notify_(double value) {
                this.notify(Measure.valueOf((double)value, (Unit)summingMetric.getDefaultUnit()));
            }

            protected void registerListener() {
                register.accept(newMeasurement -> {
                    Measure measure = newMeasurement.getMeasureForMetric((MetricDescription)baseMetricDescription);
                    this.sum += measure.doubleValue(summingMetric.getDefaultUnit());
                    this.notify_(this.sum);
                });
            }
        });
        return result;
    }

    public static NumericalBaseMetricDescription getNonPointInTimeNumericalBaseMetric(MetricDescription metricDesciption) {
        return (NumericalBaseMetricDescription)Arrays.stream(MetricDescriptionUtility.toBaseMetricDescriptions((MetricDescription)metricDesciption)).filter(it -> it != MetricDescriptionConstants.POINT_IN_TIME_METRIC).reduce(StreamUtil.reduceToMaximumOne()).get();
    }

    public static NumericalBaseMetricDescription getOrCreateAveragingMetric(NumericalBaseMetricDescription baseMetric) {
        return metricToAveragingMetric.computeIfAbsent(baseMetric, MetricDescriptionUtil::createAveragingMetric);
    }

    public static MetricSetDescription getOrCreateEventBaseMetricDescriptionWithTime(NumericalBaseMetricDescription baseMetricDescription) {
        return eventNumericalBaseMetricToMetricSet.computeIfAbsent(baseMetricDescription, MetricDescriptionUtil::createEventBaseMetricDescriptionWithTime);
    }

    public static NumericalBaseMetricDescription getOrCreateSummingMetric(NumericalBaseMetricDescription baseMetric) {
        return metricToSummingMetric.computeIfAbsent(baseMetric, MetricDescriptionUtil::createSummingMetric);
    }

    public static MetricSetDescription getOrCreateTriggeredBaseMetricDescriptionWithTime(NumericalBaseMetricDescription baseMetricDescription) {
        return triggeredNumericalBaseMetricToMetricSet.computeIfAbsent(baseMetricDescription, MetricDescriptionUtil::createTriggeredBaseMetricDescriptionWithTime);
    }

    public static <V, Q extends Quantity> void observeProbeRawTo(Probe probe, Consumer<Measure<V, Q>> consumer) {
        NumericalBaseMetricDescription baseMetricDescription = (NumericalBaseMetricDescription)MetricDescriptionUtility.toBaseMetricDescriptions((MetricDescription)probe.getMetricDesciption())[1];
        probe.addObserver(probeMeasurement -> {
            Measure measure = probeMeasurement.getMeasureProvider().getMeasureForMetric((MetricDescription)baseMetricDescription);
            consumer.accept(measure);
        });
    }

    public static void reset() {
        metricToAveragingMetric = new HashMap<NumericalBaseMetricDescription, NumericalBaseMetricDescription>();
        metricToSummingMetric = new HashMap<NumericalBaseMetricDescription, NumericalBaseMetricDescription>();
        triggeredNumericalBaseMetricToMetricSet = new HashMap<NumericalBaseMetricDescription, MetricSetDescription>();
        eventNumericalBaseMetricToMetricSet = new HashMap<NumericalBaseMetricDescription, MetricSetDescription>();
    }
}

