/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.monitoring.simulizar;

import java.util.LinkedList;
import java.util.List;
import javax.measure.quantity.Quantity;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.measurementframework.measureprovider.MeasurementListMeasureProvider;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.probeframework.measurement.ProbeMeasurement;
import org.palladiosimulator.probeframework.measurement.RequestContext;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;
import org.palladiosimulator.probeframework.probes.listener.IProbeListener;

public class TriggeredCombiningProbe<V, Q extends Quantity>
extends Probe
implements IProbeListener {
    private final List<TriggeredProbe> subsumedProbes;
    private final TriggeredProbe triggerProbe;

    public TriggeredCombiningProbe(MetricDescription metricDesciption, List<TriggeredProbe> subsumedProbes, TriggeredProbe triggerProbe) {
        super(metricDesciption);
        this.subsumedProbes = subsumedProbes;
        this.triggerProbe = triggerProbe;
        if (!subsumedProbes.contains(triggerProbe)) {
            throw new IllegalArgumentException("Subsumed probes must contain triggered probe.");
        }
        triggerProbe.addObserver((IProbeListener)this);
    }

    public void newProbeMeasurementAvailable(ProbeMeasurement triggerMeasurement) {
        RequestContext measurementContext = triggerMeasurement.getProbeAndContext().getRequestContext();
        LinkedList<MeasuringValue> childMeasurements = new LinkedList<MeasuringValue>();
        for (TriggeredProbe childProbe : this.subsumedProbes) {
            if (childProbe.equals(this.triggerProbe)) {
                childMeasurements.add((MeasuringValue)triggerMeasurement.getMeasureProvider());
                continue;
            }
            IMeasureProvider subsumedMeasureProvider = childProbe.takeMeasurement(measurementContext).getMeasureProvider();
            if (!(subsumedMeasureProvider instanceof MeasuringValue)) {
                throw new IllegalArgumentException("Subsumed measure providers have to be measurements");
            }
            childMeasurements.add((MeasuringValue)subsumedMeasureProvider);
        }
        MeasurementListMeasureProvider measureProvider = new MeasurementListMeasureProvider(childMeasurements);
        ProbeMeasurement newMeasurement = new ProbeMeasurement((IMeasureProvider)measureProvider, (Probe)this, measurementContext);
        this.notifyMeasurementSourceListener(newMeasurement);
    }
}

