/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.scheduler;

import de.uka.ipd.sdq.scheduler.SchedulerModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.palladiosimulator.indirections.repository.DataChannel;
import org.palladiosimulator.indirections.repository.JavaClassDataChannel;
import org.palladiosimulator.indirections.scheduler.IDataChannelResource;
import org.palladiosimulator.indirections.scheduler.IDataChannelResourceFactory;
import org.palladiosimulator.indirections.scheduler.util.DataChannelResourceRegistry;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.simulizar.di.component.interfaces.SimulatedThreadComponent;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;

public class DataChannelResourceFactory
implements IDataChannelResourceFactory {
    @Override
    public IDataChannelResource createDataChannelResource(DataChannel dataChannel, AssemblyContext assemblyContext, InterpreterDefaultContext context, SchedulerModel model, SimulatedThreadComponent.Factory simulatedThreadComponentFactory, DataChannelResourceRegistry dataChannelResourceRegistry) {
        Class<?> clazz;
        if (!(dataChannel instanceof JavaClassDataChannel)) {
            throw new PCMModelInterpreterException("Currently only " + JavaClassDataChannel.class + " data channels are supported. Got: " + dataChannel);
        }
        JavaClassDataChannel javaClassDataChannel = (JavaClassDataChannel)dataChannel;
        String fqn = javaClassDataChannel.getRealizingClassFqn();
        try {
            clazz = this.getClass().getClassLoader().loadClass(fqn);
        }
        catch (ClassNotFoundException e) {
            throw new PCMModelInterpreterException("Could not find realizing class " + fqn + " for " + javaClassDataChannel, (Throwable)e);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(JavaClassDataChannel.class, AssemblyContext.class, InterpreterDefaultContext.class, SchedulerModel.class, SimulatedThreadComponent.Factory.class, DataChannelResourceRegistry.class);
            IDataChannelResource instance = (IDataChannelResource)constructor.newInstance(javaClassDataChannel, assemblyContext, context, model, simulatedThreadComponentFactory, dataChannelResourceRegistry);
            return instance;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new PCMModelInterpreterException("Could not create instance of class " + fqn + " for " + javaClassDataChannel, (Throwable)e);
        }
    }
}

