/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.scheduler.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.palladiosimulator.indirections.interfaces.IndirectionDate;
import org.palladiosimulator.indirections.scheduler.data.GroupingIndirectionDate;
import org.palladiosimulator.indirections.scheduler.data.TaggedDate;

public class GenericJoinedDate<T extends IndirectionDate, TAG>
implements GroupingIndirectionDate<T> {
    public Map<TAG, TaggedDate<T, TAG>> data;
    protected final Map<String, Object> extraData;

    public GenericJoinedDate(Map<TAG, TaggedDate<T, TAG>> dataMap) {
        this.data = dataMap;
        this.extraData = new HashMap<String, Object>();
    }

    public static <T extends IndirectionDate, TAG> GenericJoinedDate<T, TAG> of(Collection<TaggedDate<T, TAG>> data) {
        Map dataMap = data.stream().collect(Collectors.toMap(it -> it.tag, Function.identity()));
        return new GenericJoinedDate<T, Object>(dataMap);
    }

    public static <T extends IndirectionDate, TAG> GenericJoinedDate<T, TAG> of(Map<TAG, T> data) {
        Map<Object, TaggedDate> dataMap = data.entrySet().stream().collect(Collectors.toMap(it -> it.getKey(), it -> new TaggedDate(it.getKey(), (IndirectionDate)it.getValue())));
        return new GenericJoinedDate<T, Object>(dataMap);
    }

    public void addDate(String key, Object value) {
        this.extraData.put(key, value);
    }

    public Map<String, Object> getData() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<TAG, TaggedDate<T, TAG>> t : this.data.entrySet()) {
            for (String key : t.getValue().date.getData().keySet()) {
                String newKey = String.valueOf(t.getKey().toString()) + "." + key;
                if (result.containsKey(newKey)) {
                    throw new IllegalStateException();
                }
                result.put(newKey, t.getValue().date.getData().get(key));
            }
        }
        return result;
    }

    @Override
    public List<T> getDataInGroup() {
        return this.data.values().stream().map(it -> it.date).collect(Collectors.toUnmodifiableList());
    }

    public Collection<Double> getTime() {
        return this.getDataInGroup().stream().flatMap(it -> it.getTime().stream()).collect(Collectors.toList());
    }
}

