/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.scheduler.implementations;

import de.uka.ipd.sdq.scheduler.SchedulerModel;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import org.palladiosimulator.indirections.interfaces.IndirectionDate;
import org.palladiosimulator.indirections.repository.DataChannel;
import org.palladiosimulator.indirections.repository.DataSinkRole;
import org.palladiosimulator.indirections.repository.DataSourceRole;
import org.palladiosimulator.indirections.repository.JavaClassDataChannel;
import org.palladiosimulator.indirections.scheduler.AbstractSimDataChannelResource;
import org.palladiosimulator.indirections.scheduler.scheduling.ProcessWaitingToGet;
import org.palladiosimulator.indirections.scheduler.scheduling.ProcessWaitingToPut;
import org.palladiosimulator.indirections.scheduler.util.DataChannelResourceRegistry;
import org.palladiosimulator.indirections.scheduler.util.IndirectionSimulationUtil;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.simulizar.di.component.interfaces.SimulatedThreadComponent;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;

public class AnyToAllPushingDataChannelWithRDs
extends AbstractSimDataChannelResource {
    public static final String CPU_ID = "_oro4gG3fEdy4YaaT-RYrLQ";
    protected final Map<DataSourceRole, Queue<IndirectionDate>> data = new HashMap<DataSourceRole, Queue<IndirectionDate>>();
    private static final String ACCEPT_RESOURCE_DEMAND_PARAMETER_NAME = "acceptResourceDemand";
    private static final String EMIT_RESOURCE_DEMAND_PARAMETER_NAME = "emitResourceDemand";
    private final String acceptResourceDemand;
    private final String emitResourceDemand;

    public AnyToAllPushingDataChannelWithRDs(JavaClassDataChannel dataChannel, AssemblyContext assemblyContext, InterpreterDefaultContext mainContext, SchedulerModel model, SimulatedThreadComponent.Factory simulatedThreadComponentFactory, DataChannelResourceRegistry dataChannelResourceRegistry) {
        super((DataChannel)dataChannel, assemblyContext, mainContext, model, simulatedThreadComponentFactory, dataChannelResourceRegistry);
        for (DataSourceRole connector : dataChannel.getDataSourceRoles()) {
            this.data.put(connector, new ArrayDeque());
        }
        this.acceptResourceDemand = IndirectionSimulationUtil.getStringParameter(dataChannel, ACCEPT_RESOURCE_DEMAND_PARAMETER_NAME);
        this.emitResourceDemand = IndirectionSimulationUtil.getStringParameter(dataChannel, EMIT_RESOURCE_DEMAND_PARAMETER_NAME);
    }

    @Override
    protected void acceptData(DataSinkRole role, IndirectionDate date) {
        this.scheduleDemand(CPU_ID, this.acceptResourceDemand, date, indirectionDate -> {
            this.data.values().forEach(it -> {
                boolean bl = it.add(indirectionDate);
            });
            this.notifyProcessesCanGetNewData();
        });
    }

    @Override
    protected void provideDataAndAdvance(DataSourceRole role, Consumer<IndirectionDate> continuation) {
        IndirectionDate date = this.data.get(role).remove();
        this.scheduleDemand(CPU_ID, this.emitResourceDemand, date, continuation);
    }

    @Override
    protected boolean canAcceptData(DataSinkRole role) {
        return true;
    }

    @Override
    protected boolean canProvideData(DataSourceRole role) {
        return this.data.get(role).size() > 0;
    }

    @Override
    protected boolean isPushingRole(DataSourceRole role) {
        return true;
    }

    @Override
    protected void handleCannotProceedToGet(ProcessWaitingToGet process) {
        throw new AssertionError((Object)"This should never happen, since the channel only supports pushing.");
    }

    @Override
    protected void handleCannotProceedToPut(ProcessWaitingToPut process) {
        throw new AssertionError((Object)"This should never happen, since the channel always returns true for canAcceptData");
    }

    @Override
    protected void handleNewWatermarkedTime(double oldWatermarkTime, double watermarkTime) {
    }
}

