/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.scheduler.util;

import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.palladiosimulator.commons.eclipseutils.ExtensionHelper;
import org.palladiosimulator.indirections.repository.DataChannel;
import org.palladiosimulator.indirections.scheduler.IDataChannelResource;
import org.palladiosimulator.indirections.scheduler.IDataChannelResourceFactory;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.simulizar.di.base.scopes.RuntimeExtensionScope;
import org.palladiosimulator.simulizar.di.component.interfaces.SimulatedThreadComponent;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.runtimestate.RuntimeStateEntityManager;

@RuntimeExtensionScope
public class DataChannelResourceRegistry
implements RuntimeStateEntityManager {
    private static final String ATTRIBUTE_NAME = "dataChannelResourceFactory";
    private static final String EXTENSION_POINT_ID = "org.palladiosimulator.indirections.interfaces.datachannelresourcefactory";
    private SimulatedThreadComponent.Factory simulatedThreadComponentFactory;
    private final InterpreterDefaultContext context;
    private IDataChannelResourceFactory dataChannelResourceFactory;
    private final Map<AssemblyContext, Map<DataChannel, IDataChannelResource>> assemblyContextToDataChannelToDataChannelResource = new HashMap<AssemblyContext, Map<DataChannel, IDataChannelResource>>();
    private final SimuComModel model;

    @Inject
    public DataChannelResourceRegistry(@InterpreterDefaultContext.MainContext InterpreterDefaultContext ctx, SimuComModel myModel, SimulatedThreadComponent.Factory simulatedThreadComponentFactory) {
        this.context = ctx;
        this.model = myModel;
        this.simulatedThreadComponentFactory = simulatedThreadComponentFactory;
    }

    public IDataChannelResource getOrCreateDataChannelResource(DataChannel dataChannel, AssemblyContext assemblyContext) {
        Map<DataChannel, IDataChannelResource> dataChannelToDataChannelResource;
        if (this.dataChannelResourceFactory == null) {
            this.initializeDataChannelResourceFactory();
        }
        if (!this.assemblyContextToDataChannelToDataChannelResource.containsKey(assemblyContext)) {
            this.assemblyContextToDataChannelToDataChannelResource.put(assemblyContext, new HashMap());
        }
        if (!(dataChannelToDataChannelResource = this.assemblyContextToDataChannelToDataChannelResource.get(assemblyContext)).containsKey(dataChannel)) {
            dataChannelToDataChannelResource.put(dataChannel, this.dataChannelResourceFactory.createDataChannelResource(dataChannel, assemblyContext, this.context, (SchedulerModel)this.model, this.simulatedThreadComponentFactory, this));
        }
        return dataChannelToDataChannelResource.get(dataChannel);
    }

    private void initializeDataChannelResourceFactory() {
        List executableExtensions = ExtensionHelper.getExecutableExtensions((String)EXTENSION_POINT_ID, (String)ATTRIBUTE_NAME);
        this.dataChannelResourceFactory = executableExtensions.stream().map(it -> (IDataChannelResourceFactory)it).findFirst().orElseThrow(() -> new IllegalStateException("No " + IDataChannelResourceFactory.class.getName() + " found."));
    }
}

