/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.scheduler;

import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.core.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.core.exceptions.FailureException;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.usage.IUser;
import de.uka.ipd.sdq.simucomframework.usage.AbstractWorkloadUserFactory;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.indirections.interfaces.IndirectionDate;
import org.palladiosimulator.indirections.repository.DataChannel;
import org.palladiosimulator.indirections.repository.DataSinkRole;
import org.palladiosimulator.indirections.repository.DataSourceRole;
import org.palladiosimulator.indirections.scheduler.IDataChannelResource;
import org.palladiosimulator.indirections.scheduler.util.DataChannelResourceRegistry;
import org.palladiosimulator.indirections.scheduler.util.IndirectionSimulationUtil;
import org.palladiosimulator.indirections.util.ObjectUtil;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;
import org.palladiosimulator.simulizar.di.component.interfaces.SimulatedThreadComponent;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.RepositoryComponentSwitch;

public class CallbackUserFactory
extends AbstractWorkloadUserFactory {
    private final DataSourceRole sourceRole;
    private final DataSinkRole sinkRole;
    private final IResourceTableManager resourceTableManager;
    private final SimulatedThreadComponent.Factory simulatedThreadComponentFactory;
    private final AssemblyContext sinkAssemblyContext;
    private final DataChannelResourceRegistry dataChannelResourceRegistry;

    public static CallbackUserFactory createPushingUserFactory(SimuComModel model, DataSourceRole sourceRole, DataSinkRole sinkRole, AssemblyContext sinkAssemblyContext, IResourceTableManager resourceTableManager, DataChannelResourceRegistry dataChannelResourceRegistry, SimulatedThreadComponent.Factory simulatedThreadComponentFactory) {
        return new CallbackUserFactory(model, sourceRole, sinkRole, sinkAssemblyContext, resourceTableManager, dataChannelResourceRegistry, simulatedThreadComponentFactory);
    }

    private BiConsumer<InterpreterDefaultContext, String> getCallInvocation(DataSinkRole role, SimuComSimProcess user) {
        InterfaceProvidingEntity providingEntity = role.getProvidingEntity_ProvidedRole();
        if (providingEntity instanceof DataChannel) {
            return (context, parameterName) -> this.simulateDataChannelCall((InterpreterDefaultContext)context, role, (String)parameterName, user);
        }
        if (providingEntity instanceof BasicComponent) {
            return (context, parameterName) -> this.simulateComponentCall((InterpreterDefaultContext)context, role, (String)parameterName, user);
        }
        throw new PCMModelInterpreterException("Unknown target providing entity for pushing: " + providingEntity.getClass() + " (" + providingEntity + ")");
    }

    private static UsageScenario initNewUsageScenario(DataSourceRole role) {
        UsageScenario usageScenario = UsagemodelFactory.eINSTANCE.createUsageScenario();
        usageScenario.setEntityName(String.valueOf(role.getEntityName()) + "_pushing_UsageScenario");
        return usageScenario;
    }

    private AssemblyContext generateSystemAssemblyContext(ProvidedRole providedRole) {
        AssemblyContext result = CompositionFactory.eINSTANCE.createAssemblyContext();
        result.setEntityName(providedRole.getProvidingEntity_ProvidedRole().getEntityName());
        result.setId(RepositoryComponentSwitch.SYSTEM_ASSEMBLY_CONTEXT.getId());
        return result;
    }

    private void simulateComponentCall(InterpreterDefaultContext context, DataSinkRole sinkRole, String parameterName, SimuComSimProcess user) {
        context.getAssemblyContextStack().add(this.generateSystemAssemblyContext((ProvidedRole)sinkRole));
        SimulatedThreadComponent simulatedThreadComponent = this.simulatedThreadComponentFactory.create(context, user);
        RepositoryComponentSwitch repositoryComponentSwitch = simulatedThreadComponent.repositoryComponentSwitchFactory().create(context, this.sinkAssemblyContext, (Signature)sinkRole.getDataInterface().getDataSignature(), (ProvidedRole)sinkRole);
        repositoryComponentSwitch.doSwitch((EObject)sinkRole);
        context.getStack().removeStackFrame();
        context.getAssemblyContextStack().pop();
    }

    private void simulateDataChannelCall(InterpreterDefaultContext context, DataSinkRole sinkRole, String parameterName, SimuComSimProcess user) {
        DataChannel dataChannel = (DataChannel)ObjectUtil.forceCast((Object)sinkRole.getProvidingEntity_ProvidedRole(), DataChannel.class);
        IDataChannelResource dataChannelResource = this.dataChannelResourceRegistry.getOrCreateDataChannelResource(dataChannel, this.sinkAssemblyContext);
        IndirectionDate date = IndirectionSimulationUtil.claimDataFromStack((SimulatedStack<Object>)context.getStack(), parameterName);
        dataChannelResource.put((ISchedulableProcess)context.getThread(), sinkRole, date);
    }

    public CallbackUserFactory(SimuComModel model, DataSourceRole sourceRole, DataSinkRole sinkRole, AssemblyContext sinkAssemblyContext, IResourceTableManager resourceTableManager, DataChannelResourceRegistry dataChannelResourceRegistry, SimulatedThreadComponent.Factory simulatedThreadComponentFactory) {
        super(model, CallbackUserFactory.initNewUsageScenario(sourceRole));
        this.sourceRole = sourceRole;
        this.sinkRole = sinkRole;
        this.sinkAssemblyContext = sinkAssemblyContext;
        this.resourceTableManager = resourceTableManager;
        this.dataChannelResourceRegistry = dataChannelResourceRegistry;
        this.simulatedThreadComponentFactory = simulatedThreadComponentFactory;
    }

    public CallbackIteratingUser createIteratingUser() {
        return new CallbackIteratingUser(this.model, "CallbackIteratingUser");
    }

    public CallbackUser createUser() {
        return new CallbackUser(this.model, "CallbackUser");
    }

    private abstract class AbstractCallbackUser<T>
    extends SimuComSimProcess
    implements IUser {
        protected InterpreterDefaultContext context;
        protected String dataId;
        protected T date;

        protected AbstractCallbackUser(SimuComModel model, String name) {
            super(model, name, CallbackUserFactory.this.resourceTableManager);
            this.dataId = null;
            this.date = null;
        }

        protected void internalLifeCycle() {
            block11: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(String.valueOf(this.getName()) + " started! I'm alive!!!"));
                }
                this.updateNewSessionID();
                try {
                    ((TriggeredProbe)CallbackUserFactory.this.usageStartStopProbes.get(0)).takeMeasurement(this.getRequestContext());
                    this.scenarioRunner(this);
                    ((TriggeredProbe)CallbackUserFactory.this.usageStartStopProbes.get(1)).takeMeasurement(this.getRequestContext());
                    if (this.getModel().getConfiguration().getSimulateFailures()) {
                        this.getModel().getFailureStatistics().recordSuccess();
                    }
                }
                catch (FailureException exception) {
                    if (this.getModel().getConfiguration().getSimulateFailures()) {
                        this.getModel().getFailureStatistics().increaseUnhandledFailureCounter(exception.getFailureType(), Long.valueOf(this.currentSessionId));
                    }
                    this.getModel().increaseMainMeasurementsCount();
                    break block11;
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.getModel().increaseMainMeasurementsCount();
                    }
                }
                this.getModel().increaseMainMeasurementsCount();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(String.valueOf(this.getName()) + " done! I'm dying!!!"));
            }
        }

        public void setDataAndStartUserLife(String dataId, T date, InterpreterDefaultContext context) {
            this.dataId = dataId;
            this.date = date;
            this.context = context;
            this.startUserLife();
        }

        public void startUserLife() {
            this.scheduleAt(0.0);
        }
    }

    public class CallbackIteratingUser
    extends AbstractCallbackUser<List<IndirectionDate>> {
        public CallbackIteratingUser(SimuComModel owner, String name) {
            super(owner, name);
        }

        public void scenarioRunner(SimuComSimProcess thread) {
            BiConsumer<InterpreterDefaultContext, String> simulationCall = CallbackUserFactory.this.getCallInvocation(CallbackUserFactory.this.sinkRole, thread);
            for (IndirectionDate currentDate : (List)this.date) {
                this.context.getStack().createAndPushNewStackFrame();
                String parameterName = CallbackUserFactory.this.sourceRole.getDataInterface().getDataSignature().getParameter().getParameterName();
                IndirectionSimulationUtil.createNewDataOnStack((SimulatedStack<Object>)this.context.getStack(), parameterName, Objects.requireNonNull(currentDate));
                IndirectionSimulationUtil.flattenDataOnStack((SimulatedStack<Object>)this.context.getStack(), parameterName, currentDate);
                simulationCall.accept(this.context, parameterName);
            }
        }
    }

    public class CallbackUser
    extends AbstractCallbackUser<IndirectionDate> {
        private final String parameterName;
        private final BiConsumer<InterpreterDefaultContext, String> simulationCall;

        public CallbackUser(SimuComModel owner, String name) {
            super(owner, name);
            this.parameterName = CallbackUserFactory.this.sourceRole.getDataInterface().getDataSignature().getParameter().getParameterName();
            this.simulationCall = CallbackUserFactory.this.getCallInvocation(CallbackUserFactory.this.sinkRole, this);
        }

        public void scenarioRunner(SimuComSimProcess thread) {
            this.context.getStack().createAndPushNewStackFrame();
            IndirectionSimulationUtil.createNewDataOnStack((SimulatedStack<Object>)this.context.getStack(), this.parameterName, Objects.requireNonNull((IndirectionDate)this.date));
            IndirectionSimulationUtil.flattenDataOnStack((SimulatedStack<Object>)this.context.getStack(), this.parameterName, (IndirectionDate)this.date);
            this.simulationCall.accept(this.context, this.parameterName);
        }
    }
}

