/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.scheduler.data;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.palladiosimulator.indirections.interfaces.IndirectionDate;
import org.palladiosimulator.indirections.scheduler.data.GroupingIndirectionDate;

public class ConcreteGroupingIndirectionDate<T extends IndirectionDate>
implements GroupingIndirectionDate<T> {
    private final List<T> dataInGroup;
    protected final Map<String, Object> extraData;
    public final UUID uuid = UUID.randomUUID();

    public ConcreteGroupingIndirectionDate(List<T> dataInGroup) {
        this(dataInGroup, new HashMap<String, Object>());
    }

    public ConcreteGroupingIndirectionDate(List<T> dataInGroup, Map<String, Object> extraData) {
        this.dataInGroup = dataInGroup;
        this.extraData = new HashMap<String, Object>(extraData);
    }

    public void addDate(String key, Object value) {
        this.extraData.put(key, value);
    }

    public Map<String, Object> getData() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.extraData);
        result.put("INNER_ELEMENTS.NUMBER_OF_ELEMENTS", this.dataInGroup.size());
        result.put("INNER_ELEMENTS.VALUE", this.dataInGroup);
        return result;
    }

    @Override
    public List<T> getDataInGroup() {
        return Collections.unmodifiableList(this.dataInGroup);
    }

    public Collection<Double> getTime() {
        return this.getDataInGroup().stream().flatMap(it -> it.getTime().stream()).collect(Collectors.toList());
    }

    public String toString() {
        String dataToString = this.dataInGroup.stream().map(it -> "(" + it.getData().entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + "->" + e.getValue()).collect(Collectors.joining(";")) + ")").collect(Collectors.joining(","));
        String extraDataString = this.extraData.entrySet().stream().map(it -> "(" + (String)it.getKey() + "->" + it.getValue()).collect(Collectors.joining(";"));
        return "<" + this.getClass().getSimpleName() + " (" + this.uuid + "): " + dataToString + ", extra: " + extraDataString + ">";
    }
}

