/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.scheduler.implementations;

import de.uka.ipd.sdq.scheduler.SchedulerModel;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.palladiosimulator.indirections.interfaces.IndirectionDate;
import org.palladiosimulator.indirections.repository.DataChannel;
import org.palladiosimulator.indirections.repository.DataSinkRole;
import org.palladiosimulator.indirections.repository.DataSourceRole;
import org.palladiosimulator.indirections.repository.JavaClassDataChannel;
import org.palladiosimulator.indirections.scheduler.AbstractSimDataChannelResource;
import org.palladiosimulator.indirections.scheduler.data.PartitionedIndirectionDate;
import org.palladiosimulator.indirections.scheduler.data.WindowingIndirectionDate;
import org.palladiosimulator.indirections.scheduler.scheduling.ProcessWaitingToGet;
import org.palladiosimulator.indirections.scheduler.scheduling.ProcessWaitingToPut;
import org.palladiosimulator.indirections.scheduler.util.DataChannelResourceRegistry;
import org.palladiosimulator.indirections.scheduler.util.IndirectionSimulationUtil;
import org.palladiosimulator.indirections.util.ObjectUtil;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.simulizar.di.component.interfaces.SimulatedThreadComponent;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;

public class D2_WindowedReadingRepartitioning
extends AbstractSimDataChannelResource {
    private final Queue<IndirectionDate> data = new ArrayDeque<IndirectionDate>();

    public D2_WindowedReadingRepartitioning(JavaClassDataChannel dataChannel, AssemblyContext assemblyContext, InterpreterDefaultContext mainContext, SchedulerModel model, SimulatedThreadComponent.Factory simulatedThreadComponentFactory, DataChannelResourceRegistry dataChannelResourceRegistry) {
        super((DataChannel)dataChannel, assemblyContext, mainContext, model, simulatedThreadComponentFactory, dataChannelResourceRegistry);
        IndirectionSimulationUtil.requireNumberOfSinkSourceRoles((DataChannel)dataChannel, it -> it == 1, "== 1", it -> it == 1, "== 1");
    }

    @Override
    protected void acceptData(DataSinkRole role, IndirectionDate date) {
        if (this.discardDateIfTooOld(date)) {
            return;
        }
        System.out.println(String.valueOf(this.dataChannel.getEntityName()) + ": Accepting date " + date + ", now=" + this.model.getSimulationControl().getCurrentSimulationTime());
        WindowingIndirectionDate windowingDate = (WindowingIndirectionDate)ObjectUtil.forceCast((Object)date, WindowingIndirectionDate.class, () -> new PCMModelInterpreterException(String.valueOf(this.getClass().getSimpleName()) + " only accepts " + WindowingIndirectionDate.class.getSimpleName() + ", got: " + date.getClass().getName()));
        windowingDate.getDataInGroup().stream().collect(Collectors.groupingBy(it -> Map.of("houseId.VALUE", (Integer)it.evaluate("houseId.VALUE"), "plugId.VALUE", (Integer)it.evaluate("plugId.VALUE")))).forEach((key, value) -> {
            HashMap<String, Object> extraData = new HashMap<String, Object>((Map<String, Object>)key);
            extraData.put("window.VALUE", windowingIndirectionDate.window);
            PartitionedIndirectionDate d = new PartitionedIndirectionDate((Map)key, value, (Map<String, Object>)extraData);
            this.data.add(d);
        });
        this.notifyProcessesCanGetNewData();
    }

    @Override
    protected boolean canAcceptData(DataSinkRole role) {
        return true;
    }

    @Override
    protected boolean canProvideData(DataSourceRole role) {
        return this.data.size() > 0;
    }

    @Override
    protected boolean isPushingRole(DataSourceRole role) {
        return true;
    }

    @Override
    protected void handleCannotProceedToGet(ProcessWaitingToGet process) {
        throw new AssertionError((Object)"");
    }

    @Override
    protected void handleCannotProceedToPut(ProcessWaitingToPut process) {
        throw new AssertionError((Object)"");
    }

    @Override
    protected void handleNewWatermarkedTime(double oldWatermarkTime, double watermarkTime) {
        System.out.println("Moving " + this + " from " + oldWatermarkTime + " to " + watermarkTime);
    }

    @Override
    protected void provideDataAndAdvance(DataSourceRole role, Consumer<IndirectionDate> continuation) {
        IndirectionDate dataToProvide = this.data.remove();
        System.out.println(String.valueOf(this.dataChannel.getEntityName()) + ": Providing data " + dataToProvide + ", now=" + this.model.getSimulationControl().getCurrentSimulationTime());
        continuation.accept(dataToProvide);
    }
}

