/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.scheduler.implementations;

import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.simucomframework.core.entities.SimuComEntity;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import org.palladiosimulator.indirections.interfaces.IndirectionDate;
import org.palladiosimulator.indirections.repository.DataChannel;
import org.palladiosimulator.indirections.repository.DataSinkRole;
import org.palladiosimulator.indirections.repository.DataSourceRole;
import org.palladiosimulator.indirections.repository.JavaClassDataChannel;
import org.palladiosimulator.indirections.scheduler.AbstractSimDataChannelResource;
import org.palladiosimulator.indirections.scheduler.data.ConcreteGroupingIndirectionDate;
import org.palladiosimulator.indirections.scheduler.data.GenericJoinedDate;
import org.palladiosimulator.indirections.scheduler.operators.Emitters;
import org.palladiosimulator.indirections.scheduler.scheduling.ProcessWaitingToGet;
import org.palladiosimulator.indirections.scheduler.scheduling.ProcessWaitingToPut;
import org.palladiosimulator.indirections.scheduler.util.DataChannelResourceRegistry;
import org.palladiosimulator.indirections.scheduler.util.IndirectionSimulationUtil;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.simulizar.di.component.interfaces.SimulatedThreadComponent;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;

public class D6_JoiningToGroup
extends AbstractSimDataChannelResource {
    public static final String GRACE_PERIOD_PARAMETER_NAME = "gracePeriod";
    private final double gracePeriod;
    public static final String MEDIAN_WINDOW_PER_HOUSE_ROLE_ID_PARAMETER_NAME = "medianWindowPerHouseRoleId";
    private final String medianWindowPerHouseRoleId;
    private final DataSinkRole medianWindowPerHouseRole;
    public static final String MEDIAN_AVERAGE_ROLE_ID_PARAMETER_NAME = "medianAverageRoleId";
    private final String medianAverageRoleId;
    private final DataSinkRole medianAverageRole;
    protected final Map<DataSinkRole, Map<Emitters.Window, List<IndirectionDate>>> roleToWindowToDates;
    private final Map<Emitters.Window, SimuComEntity> scheduledToEmit;
    private Queue<IndirectionDate> data;

    public D6_JoiningToGroup(JavaClassDataChannel dataChannel, AssemblyContext assemblyContext, InterpreterDefaultContext mainContext, SchedulerModel model, SimulatedThreadComponent.Factory simulatedThreadComponentFactory, DataChannelResourceRegistry dataChannelResourceRegistry) {
        super((DataChannel)dataChannel, assemblyContext, mainContext, model, simulatedThreadComponentFactory, dataChannelResourceRegistry);
        this.gracePeriod = IndirectionSimulationUtil.getDoubleParameter(dataChannel, GRACE_PERIOD_PARAMETER_NAME);
        this.medianWindowPerHouseRoleId = IndirectionSimulationUtil.getStringParameter(dataChannel, MEDIAN_WINDOW_PER_HOUSE_ROLE_ID_PARAMETER_NAME);
        this.medianAverageRoleId = IndirectionSimulationUtil.getStringParameter(dataChannel, MEDIAN_AVERAGE_ROLE_ID_PARAMETER_NAME);
        this.medianWindowPerHouseRole = dataChannel.getDataSinkRoles().stream().filter(it -> it.getId().equals(this.medianWindowPerHouseRoleId)).findFirst().get();
        this.medianAverageRole = dataChannel.getDataSinkRoles().stream().filter(it -> it.getId().equals(this.medianAverageRoleId)).findFirst().get();
        this.roleToWindowToDates = new HashMap<DataSinkRole, Map<Emitters.Window, List<IndirectionDate>>>();
        for (DataSinkRole role : dataChannel.getDataSinkRoles()) {
            this.roleToWindowToDates.put(role, new HashMap());
        }
        this.scheduledToEmit = new HashMap<Emitters.Window, SimuComEntity>();
        this.data = new ArrayDeque<IndirectionDate>();
    }

    private double timeToEmit(Emitters.Window window) {
        return window.end + this.gracePeriod;
    }

    @Override
    protected void acceptData(DataSinkRole role, IndirectionDate date) {
        System.out.println(String.valueOf(this.dataChannel.getEntityName()) + ": Accepting data to " + role.getEntityName() + " (" + role.getId() + "): " + date + ", now=" + this.model.getSimulationControl().getCurrentSimulationTime());
        Map<Emitters.Window, List<IndirectionDate>> windowToDates = this.roleToWindowToDates.get(role);
        Emitters.Window window = (Emitters.Window)date.getData().get("window.VALUE");
        double timeToEmit = this.timeToEmit(window);
        double timeNow = this.model.getSimulationControl().getCurrentSimulationTime();
        double delay = timeToEmit - timeNow;
        if (delay <= 0.0) {
            throw new PCMModelInterpreterException("Data is too late, window already emitted: " + window + ", now: " + timeNow + ", emitted at: " + timeToEmit);
        }
        if (!windowToDates.containsKey(window)) {
            windowToDates.put(window, new ArrayList());
        }
        List<IndirectionDate> dates = windowToDates.get(window);
        dates.add(date);
        if (!this.scheduledToEmit.containsKey(window)) {
            this.scheduledToEmit.put(window, IndirectionSimulationUtil.triggerOnce(this.model, delay, () -> {
                System.out.println(String.valueOf(this.dataChannel.getEntityName()) + ": emitting " + window + ", now = " + this.model.getSimulationControl().getCurrentSimulationTime());
                this.emit(window);
                SimuComEntity simuComEntity = this.scheduledToEmit.remove(window);
            }));
        }
    }

    protected void emit(Emitters.Window window) {
        List<IndirectionDate> medianWindowsPerHouse = this.roleToWindowToDates.get(this.medianWindowPerHouseRole).remove(window);
        List<IndirectionDate> medianAverages = this.roleToWindowToDates.get(this.medianAverageRole).remove(window);
        if (medianAverages == null) {
            System.out.println("Error, no average found for " + window);
            return;
        }
        if (medianWindowsPerHouse == null) {
            System.out.println("Error, no house medians found for " + window);
            return;
        }
        if (medianAverages.size() != 1) {
            System.out.println("Expected exactly one average for " + window + ", got: " + medianAverages.size());
            return;
        }
        if (medianWindowsPerHouse.isEmpty()) {
            System.out.println("Didn't find any house medians for " + window);
            return;
        }
        for (IndirectionDate medianAverage : medianAverages) {
            GenericJoinedDate<ConcreteGroupingIndirectionDate<IndirectionDate>, String> joinedDate = GenericJoinedDate.of(Map.of("medianAverage", medianAverage, "medianWindowPerHouseGroup", new ConcreteGroupingIndirectionDate<IndirectionDate>(medianWindowsPerHouse)));
            this.data.add(joinedDate);
        }
        this.notifyProcessesCanGetNewData();
    }

    @Override
    protected boolean canAcceptData(DataSinkRole role) {
        return true;
    }

    @Override
    protected boolean canProvideData(DataSourceRole role) {
        return this.data.size() > 0;
    }

    @Override
    protected boolean isPushingRole(DataSourceRole role) {
        return true;
    }

    @Override
    protected void handleCannotProceedToGet(ProcessWaitingToGet process) {
        throw new AssertionError((Object)"");
    }

    @Override
    protected void handleCannotProceedToPut(ProcessWaitingToPut process) {
        throw new AssertionError((Object)"");
    }

    @Override
    protected void handleNewWatermarkedTime(double oldWatermarkTime, double watermarkTime) {
    }

    @Override
    protected void provideDataAndAdvance(DataSourceRole role, Consumer<IndirectionDate> continuation) {
        IndirectionDate dataToProvide = this.data.remove();
        System.out.println(String.valueOf(this.dataChannel.getEntityName()) + ": Providing data " + dataToProvide + ", now=" + this.model.getSimulationControl().getCurrentSimulationTime());
        continuation.accept(dataToProvide);
    }
}

