/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.calculators.scheduler;

import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import java.util.List;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.edp2.models.measuringpoint.StringMeasuringPoint;
import org.palladiosimulator.indirections.monitoring.simulizar.IndirectionMeasuringPointRegistry;
import org.palladiosimulator.indirections.monitoring.simulizar.MeasuringUtil;
import org.palladiosimulator.indirections.monitoring.simulizar.TriggeredCombiningProbe;
import org.palladiosimulator.indirections.monitoring.simulizar.TriggeredProxyProbe;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.probeframework.calculator.ICalculatorFactory;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;

public class TriggerableCalculator<V, Q extends Quantity> {
    protected final SimuComModel model;
    protected final TriggeredCombiningProbe<V, Q> probeList;
    protected final TriggeredProxyProbe<V, Q> proxyProbe;
    protected final IndirectionMeasuringPointRegistry registry;

    public TriggerableCalculator(String name, BaseMetricDescription baseMetric, MetricSetDescription metricSet, InterpreterDefaultContext mainContext) {
        this.model = mainContext.getModel();
        this.registry = IndirectionMeasuringPointRegistry.getInstanceFor((InterpreterDefaultContext)mainContext);
        StringMeasuringPoint measuringPoint = MeasuringUtil.createStringMeasuringPoint((MeasuringPointRepository)IndirectionMeasuringPointRegistry.MEASURING_POINT_REPOSITORY, (String)name);
        this.proxyProbe = new TriggeredProxyProbe(baseMetric);
        this.probeList = new TriggeredCombiningProbe((MetricDescription)metricSet, List.of(this.registry.timeProbe, this.proxyProbe), this.proxyProbe);
        ICalculatorFactory calculatorFactory = this.model.getProbeFrameworkContext().getCalculatorFactory();
        calculatorFactory.buildExecutionResultCalculator((MeasuringPoint)measuringPoint, this.probeList);
    }

    public void doMeasure(Measure<V, Q> measure) {
        this.proxyProbe.doMeasure(measure);
    }
}

