/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.scheduler;

import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import de.uka.ipd.sdq.simucomframework.core.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Consumer;
import org.palladiosimulator.indirections.calculators.scheduler.ContextAwareTimeSpanCalculator;
import org.palladiosimulator.indirections.calculators.scheduler.TriggerableCountingCalculator;
import org.palladiosimulator.indirections.calculators.scheduler.TriggerableTimeSpanCalculator;
import org.palladiosimulator.indirections.composition.AssemblyDataConnector;
import org.palladiosimulator.indirections.interfaces.IndirectionDate;
import org.palladiosimulator.indirections.monitoring.IndirectionsMetricDescriptionConstants;
import org.palladiosimulator.indirections.repository.DataChannel;
import org.palladiosimulator.indirections.repository.DataSinkRole;
import org.palladiosimulator.indirections.repository.DataSourceRole;
import org.palladiosimulator.indirections.scheduler.CallbackUserFactory;
import org.palladiosimulator.indirections.scheduler.IDataChannelResource;
import org.palladiosimulator.indirections.scheduler.scheduling.ProcessWaitingToGet;
import org.palladiosimulator.indirections.scheduler.scheduling.ProcessWaitingToPut;
import org.palladiosimulator.indirections.scheduler.scheduling.SuspendableSchedulerEntity;
import org.palladiosimulator.indirections.scheduler.util.DataChannelResourceRegistry;
import org.palladiosimulator.indirections.scheduler.util.IndirectionSimulationUtil;
import org.palladiosimulator.indirections.util.IndirectionModelUtil;
import org.palladiosimulator.indirections.util.StreamUtil;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.simulizar.di.component.interfaces.SimulatedThreadComponent;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.simulationevents.PeriodicallyTriggeredSimulationEntity;

public abstract class AbstractSimDataChannelResource
implements IDataChannelResource {
    protected TriggerableTimeSpanCalculator afterAcceptingAgeCalculator;
    protected TriggerableTimeSpanCalculator beforeProvidingAgeCalculator;
    private boolean canGetNewData = false;
    private boolean canPutNewData = false;
    private double currentWatermarkedTime = Double.NEGATIVE_INFINITY;
    protected DataChannel dataChannel;
    protected TriggerableTimeSpanCalculator discardedAgeCalculator;
    protected String id;
    protected SimuComModel model;
    protected String name;
    protected TriggerableCountingCalculator numberOfDiscardedIncomingElementsCalculator;
    protected TriggerableCountingCalculator numberOfDiscardedOutgoingElementsCalculator;
    protected TriggerableCountingCalculator numberOfStoredIncomingElementsCalculator;
    protected TriggerableCountingCalculator numberOfStoredOutgoingElementsCalculator;
    private boolean postponeNotification = false;
    protected Map<DataSourceRole, Queue<ProcessWaitingToGet>> processesWaitingToGet;
    protected Map<DataSinkRole, Queue<ProcessWaitingToPut>> processesWaitingToPut;
    private PeriodicallyTriggeredSimulationEntity scheduledFlush;
    private Map<DataSourceRole, CallbackUserFactory> sourceRoleUserFactories = new HashMap<DataSourceRole, CallbackUserFactory>();
    protected ContextAwareTimeSpanCalculator<ProcessWaitingToGet> waitingToGetTimeCalculator;
    protected ContextAwareTimeSpanCalculator<ProcessWaitingToPut> waitingToPutTimeCalculator;
    private Allocation allocation;
    protected final IResourceTableManager resourceTableManager;
    protected final AssemblyContext assemblyContext;
    protected final SimulatedThreadComponent.Factory simulatedThreadComponentFactory;
    protected final InterpreterDefaultContext mainContext;
    protected final DataChannelResourceRegistry dataChannelResourceRegistry;

    public AbstractSimDataChannelResource(DataChannel dataChannel, AssemblyContext assemblyContext, InterpreterDefaultContext mainContext, SchedulerModel model, SimulatedThreadComponent.Factory simulatedThreadComponentFactory, DataChannelResourceRegistry dataChannelResourceRegistry) {
        if (!(model instanceof SimuComModel)) {
            throw new IllegalArgumentException("Currently only works with " + SimuComModel.class.getName() + ", got " + model.getClass().getName());
        }
        this.dataChannel = dataChannel;
        this.assemblyContext = assemblyContext;
        this.id = String.valueOf(dataChannel.getId()) + "_" + UUID.randomUUID().toString();
        this.name = String.valueOf(dataChannel.getEntityName()) + "_" + this.getClass().getSimpleName();
        this.model = (SimuComModel)model;
        this.mainContext = mainContext;
        this.allocation = mainContext.getLocalPCMModelAtContextCreation().getAllocation();
        this.resourceTableManager = mainContext.getResourceTableManager();
        this.simulatedThreadComponentFactory = simulatedThreadComponentFactory;
        this.dataChannelResourceRegistry = dataChannelResourceRegistry;
        this.initializeQueues();
        this.createPushingUserFactories();
        this.setupCalculators();
    }

    protected abstract void acceptData(DataSinkRole var1, IndirectionDate var2);

    private void activateIfWaiting(SuspendableSchedulerEntity process) {
        if (process.isWaiting()) {
            process.activate();
        }
    }

    @Override
    public void advance(double watermarkTime) {
        double oldWatermarkTime = watermarkTime;
        if (watermarkTime < this.currentWatermarkedTime) {
            System.out.println("Not advancing backward. Requested: " + this.currentWatermarkedTime + " to " + watermarkTime);
            return;
        }
        this.currentWatermarkedTime = watermarkTime;
        this.handleNewWatermarkedTime(oldWatermarkTime, watermarkTime);
    }

    private void allowToGetAndActivate(ProcessWaitingToGet process) {
        this.collectAndPostponeNotification(() -> {
            this.waitingToGetTimeCalculator.endMeasurement(process);
            this.numberOfStoredOutgoingElementsCalculator.change(1L);
            this.provideDataAndAdvance(processWaitingToGet.role, providedData -> {
                providedData.getTime().forEach(this.beforeProvidingAgeCalculator::doMeasureUntilNow);
                processWaitingToGet.callback.accept((IndirectionDate)providedData);
                this.activateIfWaiting(process);
            });
        });
    }

    private void allowToPutAndActivate(ProcessWaitingToPut process) {
        this.collectAndPostponeNotification(() -> {
            this.waitingToPutTimeCalculator.endMeasurement(process);
            this.numberOfStoredIncomingElementsCalculator.change(1L);
            this.acceptData(processWaitingToPut.role, processWaitingToPut.date);
            processWaitingToPut.date.getTime().forEach(this.afterAcceptingAgeCalculator::doMeasureUntilNow);
            this.activateIfWaiting(process);
        });
    }

    protected void blockUntilCanGet(ProcessWaitingToGet process) {
        this.processesWaitingToGet.get(process.role).add(process);
        process.passivate();
    }

    protected void blockUntilCanPut(ProcessWaitingToPut process) {
        this.processesWaitingToPut.get(process.role).add(process);
        process.passivate();
    }

    protected abstract boolean canAcceptData(DataSinkRole var1);

    private boolean canProceedToGet(ProcessWaitingToGet process) {
        boolean isNextProcess;
        DataSourceRole role = process.role;
        Queue<ProcessWaitingToGet> processQueue = this.processesWaitingToGet.get(role);
        boolean bl = isNextProcess = processQueue.isEmpty() || processQueue.peek().schedulableProcess.equals(process.schedulableProcess);
        return isNextProcess && this.canProvideData(role);
    }

    private boolean canProceedToPut(ProcessWaitingToPut process) {
        boolean isNextProcess;
        DataSinkRole role = process.role;
        Queue<ProcessWaitingToPut> processQueue = this.processesWaitingToPut.get(role);
        boolean bl = isNextProcess = processQueue.isEmpty() || processQueue.peek().schedulableProcess.equals(process.schedulableProcess);
        return isNextProcess && this.canAcceptData(role);
    }

    protected abstract boolean canProvideData(DataSourceRole var1);

    private void collectAndPostponeNotification(Runnable block) {
        boolean initialPostponeState = this.postponeNotification;
        this.postponeNotification = true;
        block.run();
        this.postponeNotification = initialPostponeState;
        this.handleNotifications();
    }

    protected void continueWithoutData(ProcessWaitingToGet process) {
        this.waitingToGetTimeCalculator.endMeasurement(process);
        this.activateIfWaiting(process);
    }

    private void createPushingUserFactories() {
        if (!this.sourceRoleUserFactories.isEmpty()) {
            throw new IllegalStateException("User factories already created.");
        }
        for (DataSourceRole sourceRole : this.dataChannel.getDataSourceRoles()) {
            AssemblyDataConnector assemblyDataConnector = IndirectionModelUtil.getExactlyOneAssemblyDataConnector((AssemblyContext)this.assemblyContext, (DataSourceRole)sourceRole);
            DataSinkRole sinkRole = assemblyDataConnector.getDataSinkRole();
            this.sourceRoleUserFactories.put(sourceRole, CallbackUserFactory.createPushingUserFactory(this.model, sourceRole, sinkRole, assemblyDataConnector.getSinkAssemblyContext(), this.resourceTableManager, this.dataChannelResourceRegistry, this.simulatedThreadComponentFactory));
        }
    }

    protected void discardDataAndContinue(ProcessWaitingToPut process) {
        this.waitingToPutTimeCalculator.endMeasurement(process);
        IndirectionDate dateToDiscard = process.date;
        this.discardIncomingDate(dateToDiscard);
        this.activateIfWaiting(process);
    }

    protected void discardIncomingDate(IndirectionDate dateToDiscard) {
        dateToDiscard.getTime().forEach(this.discardedAgeCalculator::doMeasureUntilNow);
        this.numberOfDiscardedIncomingElementsCalculator.change(1L);
    }

    protected boolean discardDateIfTooOld(IndirectionDate dateToDiscard) {
        if (this.isDateTooOld(dateToDiscard)) {
            this.numberOfDiscardedOutgoingElementsCalculator.change(1L);
            this.discardIncomingDate(dateToDiscard);
            return true;
        }
        return false;
    }

    protected boolean isDateTooOld(IndirectionDate date) {
        return date.getTime().stream().allMatch(it -> it < this.currentWatermarkedTime);
    }

    protected void scheduleDemand(String resourceTypeId, String demandSpecification, IndirectionDate date, Consumer<IndirectionDate> andThen) {
        AllocationContext allocationContext = this.allocation.getAllocationContexts_Allocation().stream().filter(it -> it.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext().equals(this.dataChannel)).reduce(StreamUtil.reduceToMaximumOne()).orElseThrow(() -> new PCMModelInterpreterException("No data channel allocation found."));
        ResourceContainer resourceContainer = allocationContext.getResourceContainer_AllocationContext();
        throw new PCMModelInterpreterException("Resource demands are currently not supported.");
    }

    @Override
    public boolean get(ISchedulableProcess schedulableProcess, DataSourceRole role, Consumer<IndirectionDate> callback) {
        if (!this.isSimulationRunning()) {
            return true;
        }
        if (this.isPushingRole(role)) {
            throw new IllegalStateException("Cannot pull data over pushing role.");
        }
        ProcessWaitingToGet process = new ProcessWaitingToGet((SchedulerModel)this.model, schedulableProcess, role, callback);
        this.waitingToGetTimeCalculator.startMeasurement(process);
        if (this.canProceedToGet(process)) {
            this.allowToGetAndActivate(process);
            return true;
        }
        this.handleCannotProceedToGet(process);
        return false;
    }

    protected abstract boolean isPushingRole(DataSourceRole var1);

    private boolean isSimulationRunning() {
        ISimulationControl simulationControl = this.model.getSimulationControl();
        return simulationControl.isRunning();
    }

    public double getCurrentWatermarkedTime() {
        return this.currentWatermarkedTime;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected abstract void handleCannotProceedToGet(ProcessWaitingToGet var1);

    protected abstract void handleCannotProceedToPut(ProcessWaitingToPut var1);

    protected abstract void handleNewWatermarkedTime(double var1, double var3);

    private void handleNotifications() {
        if (!this.postponeNotification) {
            if (this.canGetNewData) {
                this.canGetNewData = false;
                this.processDataAvailableToGet();
            }
            if (this.canPutNewData) {
                this.canPutNewData = false;
                this.notifyProcessesWaitingToPut();
            }
        }
    }

    private void initializeQueues() {
        this.processesWaitingToGet = new HashMap<DataSourceRole, Queue<ProcessWaitingToGet>>();
        for (DataSourceRole role : this.dataChannel.getDataSourceRoles()) {
            this.processesWaitingToGet.put(role, new ArrayDeque());
        }
        this.processesWaitingToPut = new HashMap<DataSinkRole, Queue<ProcessWaitingToPut>>();
        for (DataSourceRole role : this.dataChannel.getDataSinkRoles()) {
            this.processesWaitingToPut.put((DataSinkRole)role, new ArrayDeque());
        }
    }

    protected void notifyProcessesCanGetNewData() {
        this.canGetNewData = true;
        this.handleNotifications();
    }

    protected void notifyProcessesCanPutNewData() {
        this.canPutNewData = true;
        this.handleNotifications();
    }

    private void notifyProcessesWaitingToGet() {
        for (Map.Entry<DataSourceRole, Queue<ProcessWaitingToGet>> entry : this.processesWaitingToGet.entrySet()) {
            Queue<ProcessWaitingToGet> processes = entry.getValue();
            ProcessWaitingToGet waitingProcess = processes.peek();
            while (waitingProcess != null && this.canProceedToGet(waitingProcess)) {
                this.allowToGetAndActivate(waitingProcess);
                processes.remove();
                waitingProcess = processes.peek();
            }
        }
    }

    private void notifyProcessesWaitingToPut() {
        for (Map.Entry<DataSinkRole, Queue<ProcessWaitingToPut>> entry : this.processesWaitingToPut.entrySet()) {
            Queue<ProcessWaitingToPut> processes = entry.getValue();
            ProcessWaitingToPut waitingProcess = processes.peek();
            while (waitingProcess != null && this.canProceedToPut(waitingProcess)) {
                this.allowToPutAndActivate(waitingProcess);
                processes.remove();
                waitingProcess = processes.peek();
            }
        }
    }

    protected void processDataAvailableToGet() {
        boolean shouldNotifyProcessesWaitingToGet = false;
        for (DataSourceRole role : this.dataChannel.getDataSourceRoles()) {
            if (this.isPushingRole(role)) {
                while (this.canProvideData(role)) {
                    this.spawnNewConsumerUser(role);
                }
                continue;
            }
            shouldNotifyProcessesWaitingToGet = true;
        }
        if (shouldNotifyProcessesWaitingToGet) {
            this.notifyProcessesWaitingToGet();
        }
    }

    protected abstract void provideDataAndAdvance(DataSourceRole var1, Consumer<IndirectionDate> var2);

    @Override
    public boolean put(ISchedulableProcess schedulableProcess, DataSinkRole role, IndirectionDate date) {
        IndirectionSimulationUtil.validateIndirectionDateStructure(date, role.getDataInterface());
        if (!this.isSimulationRunning()) {
            return true;
        }
        ProcessWaitingToPut process = new ProcessWaitingToPut((SchedulerModel)this.model, schedulableProcess, role, date);
        this.waitingToPutTimeCalculator.startMeasurement(process);
        if (this.canProceedToPut(process)) {
            this.allowToPutAndActivate(process);
            return true;
        }
        this.handleCannotProceedToPut(process);
        return false;
    }

    protected void scheduleAdvance(double firstOccurence, double delay, double lagBehindRealTime) {
        if (this.scheduledFlush != null) {
            throw new PCMModelInterpreterException("Cannot schedule advance for " + this + ", already scheduled.");
        }
        this.scheduledFlush = IndirectionSimulationUtil.triggerPeriodically(this.model, firstOccurence + lagBehindRealTime, delay, () -> this.advance(this.model.getSimulationControl().getCurrentSimulationTime() - lagBehindRealTime));
    }

    private void setupCalculators() {
        this.setupSourceCalculators();
        this.setupSinkCalculators();
    }

    private void setupSinkCalculators() {
        this.afterAcceptingAgeCalculator = new TriggerableTimeSpanCalculator("Data age after accepting date (" + this.name + ")", IndirectionsMetricDescriptionConstants.DATA_AGE_METRIC, IndirectionsMetricDescriptionConstants.DATA_AGE_METRIC_TUPLE, this.mainContext);
        this.waitingToPutTimeCalculator = new ContextAwareTimeSpanCalculator("Waiting time to put (" + this.name + ")", MetricDescriptionConstants.WAITING_TIME_METRIC, MetricDescriptionConstants.WAITING_TIME_METRIC_TUPLE, this.mainContext);
        this.numberOfDiscardedOutgoingElementsCalculator = new TriggerableCountingCalculator("Discarded outgoing elements (" + this.name + ")", "Total discarded outgoing elements (" + this.name + ")", IndirectionsMetricDescriptionConstants.NUMBER_OF_ELEMENTS_METRIC, IndirectionsMetricDescriptionConstants.NUMBER_OF_ELEMENTS_METRIC_TUPLE, IndirectionsMetricDescriptionConstants.TOTAL_NUMBER_OF_ELEMENTS_METRIC_TUPLE, this.mainContext);
        this.numberOfStoredOutgoingElementsCalculator = new TriggerableCountingCalculator("Stored outgoing elements (" + this.name + ")", "Total stored outgoing elements (" + this.name + ")", IndirectionsMetricDescriptionConstants.NUMBER_OF_ELEMENTS_METRIC, IndirectionsMetricDescriptionConstants.NUMBER_OF_ELEMENTS_METRIC_TUPLE, IndirectionsMetricDescriptionConstants.TOTAL_NUMBER_OF_ELEMENTS_METRIC_TUPLE, this.mainContext);
    }

    private void setupSourceCalculators() {
        this.beforeProvidingAgeCalculator = new TriggerableTimeSpanCalculator("Data age before providing (" + this.name + ")", IndirectionsMetricDescriptionConstants.DATA_AGE_METRIC, IndirectionsMetricDescriptionConstants.DATA_AGE_METRIC_TUPLE, this.mainContext);
        this.waitingToGetTimeCalculator = new ContextAwareTimeSpanCalculator("Waiting time to get (" + this.name + ")", MetricDescriptionConstants.WAITING_TIME_METRIC, MetricDescriptionConstants.WAITING_TIME_METRIC_TUPLE, this.mainContext);
        this.numberOfDiscardedIncomingElementsCalculator = new TriggerableCountingCalculator("Discarded incoming elements (" + this.name + ")", "Total discarded incoming elements (" + this.name + ")", IndirectionsMetricDescriptionConstants.NUMBER_OF_ELEMENTS_METRIC, IndirectionsMetricDescriptionConstants.NUMBER_OF_ELEMENTS_METRIC_TUPLE, IndirectionsMetricDescriptionConstants.TOTAL_NUMBER_OF_ELEMENTS_METRIC_TUPLE, this.mainContext);
        this.discardedAgeCalculator = new TriggerableTimeSpanCalculator("Data age before discarding (" + this.name + ")", IndirectionsMetricDescriptionConstants.DATA_AGE_METRIC, IndirectionsMetricDescriptionConstants.DATA_AGE_METRIC_TUPLE, this.mainContext);
        this.numberOfStoredIncomingElementsCalculator = new TriggerableCountingCalculator("Stored incoming elements (" + this.name + ")", "Total stored incoming elements (" + this.name + ")", IndirectionsMetricDescriptionConstants.NUMBER_OF_ELEMENTS_METRIC, IndirectionsMetricDescriptionConstants.NUMBER_OF_ELEMENTS_METRIC_TUPLE, IndirectionsMetricDescriptionConstants.TOTAL_NUMBER_OF_ELEMENTS_METRIC_TUPLE, this.mainContext);
    }

    private void spawnNewConsumerUser(DataSourceRole role) {
        this.provideDataAndAdvance(role, date -> {
            date.getTime().forEach(this.beforeProvidingAgeCalculator::doMeasureUntilNow);
            String parameterName = role.getDataInterface().getDataSignature().getParameter().getParameterName();
            CallbackUserFactory.CallbackUser user = this.sourceRoleUserFactories.get(role).createUser();
            InterpreterDefaultContext newContext = InterpreterDefaultContext.createChildContext((InterpreterDefaultContext)this.mainContext, (SimuComSimProcess)user);
            this.numberOfStoredOutgoingElementsCalculator.change(1L);
            user.setDataAndStartUserLife(parameterName, date, newContext);
        });
    }

    protected void unscheduleAdvance() {
        if (this.scheduledFlush != null) {
            throw new PCMModelInterpreterException("Cannot unschedule advance for " + this + ", not scheduled.");
        }
        this.scheduledFlush.stopScheduling();
        this.scheduledFlush = null;
    }
}

