/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.scheduler.implementations;

import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.simucomframework.core.entities.SimuComEntity;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import org.palladiosimulator.indirections.interfaces.IndirectionDate;
import org.palladiosimulator.indirections.repository.DataChannel;
import org.palladiosimulator.indirections.repository.DataSinkRole;
import org.palladiosimulator.indirections.repository.DataSourceRole;
import org.palladiosimulator.indirections.repository.JavaClassDataChannel;
import org.palladiosimulator.indirections.scheduler.AbstractSimDataChannelResource;
import org.palladiosimulator.indirections.scheduler.data.WindowingIndirectionDate;
import org.palladiosimulator.indirections.scheduler.operators.Emitters;
import org.palladiosimulator.indirections.scheduler.scheduling.ProcessWaitingToGet;
import org.palladiosimulator.indirections.scheduler.scheduling.ProcessWaitingToPut;
import org.palladiosimulator.indirections.scheduler.util.DataChannelResourceRegistry;
import org.palladiosimulator.indirections.scheduler.util.IndirectionSimulationUtil;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.simulizar.di.component.interfaces.SimulatedThreadComponent;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;

public class D4_MedianWindowing
extends AbstractSimDataChannelResource {
    public static final String GRACE_PERIOD_PARAMETER_NAME = "gracePeriod";
    private final double gracePeriod;
    protected final Map<Emitters.Window, List<IndirectionDate>> windowToDates;
    private final Map<Emitters.Window, SimuComEntity> scheduledToEmit;
    protected final Queue<IndirectionDate> data;

    public D4_MedianWindowing(JavaClassDataChannel dataChannel, AssemblyContext assemblyContext, InterpreterDefaultContext mainContext, SchedulerModel model, SimulatedThreadComponent.Factory simulatedThreadComponentFactory, DataChannelResourceRegistry dataChannelResourceRegistry) {
        super((DataChannel)dataChannel, assemblyContext, mainContext, model, simulatedThreadComponentFactory, dataChannelResourceRegistry);
        this.gracePeriod = IndirectionSimulationUtil.getDoubleParameter(dataChannel, GRACE_PERIOD_PARAMETER_NAME);
        this.windowToDates = new HashMap<Emitters.Window, List<IndirectionDate>>();
        this.scheduledToEmit = new HashMap<Emitters.Window, SimuComEntity>();
        this.data = new ArrayDeque<IndirectionDate>();
    }

    private double timeToEmit(Emitters.Window window) {
        return window.end + this.gracePeriod;
    }

    @Override
    protected void acceptData(DataSinkRole role, IndirectionDate date) {
        System.out.println(String.valueOf(this.dataChannel.getEntityName()) + ": Accepting data to " + role.getEntityName() + " (" + role.getId() + "): " + date + ", now = " + this.model.getSimulationControl().getCurrentSimulationTime());
        Emitters.Window window = (Emitters.Window)date.getData().get("window.VALUE");
        double timeToEmit = this.timeToEmit(window);
        double timeNow = this.model.getSimulationControl().getCurrentSimulationTime();
        double delay = timeToEmit - timeNow;
        if (delay <= 0.0) {
            throw new PCMModelInterpreterException("Data is too late, window already emitted: " + window + ", now: " + timeNow + ", emitted at: " + timeToEmit);
        }
        if (!this.windowToDates.containsKey(window)) {
            this.windowToDates.put(window, new ArrayList());
        }
        List<IndirectionDate> dates = this.windowToDates.get(window);
        dates.add(date);
        if (!this.scheduledToEmit.containsKey(window)) {
            this.scheduledToEmit.put(window, IndirectionSimulationUtil.triggerOnce(this.model, delay, () -> {
                System.out.println(String.valueOf(this.dataChannel.getEntityName()) + ": emitting " + window + ", now = " + this.model.getSimulationControl().getCurrentSimulationTime());
                System.out.println("Delay: " + delay + ", timeNow = " + timeNow + ", timeToEmit = " + timeToEmit);
                this.emit(window);
                this.scheduledToEmit.remove(window);
            }));
        }
    }

    protected void emit(Emitters.Window window) {
        List<IndirectionDate> dataInGroup = this.windowToDates.get(window);
        if (dataInGroup.isEmpty()) {
            System.out.println("Emitting empty window");
        }
        WindowingIndirectionDate<IndirectionDate> dateToEmit = new WindowingIndirectionDate<IndirectionDate>(dataInGroup, window, Map.of());
        this.data.add(dateToEmit);
        this.notifyProcessesCanGetNewData();
    }

    @Override
    protected boolean canAcceptData(DataSinkRole role) {
        return true;
    }

    @Override
    protected boolean canProvideData(DataSourceRole role) {
        return this.data.size() > 0;
    }

    @Override
    protected boolean isPushingRole(DataSourceRole role) {
        return true;
    }

    @Override
    protected void handleCannotProceedToGet(ProcessWaitingToGet process) {
        throw new AssertionError((Object)"");
    }

    @Override
    protected void handleCannotProceedToPut(ProcessWaitingToPut process) {
        throw new AssertionError((Object)"");
    }

    @Override
    protected void handleNewWatermarkedTime(double oldWatermarkTime, double watermarkTime) {
        System.out.println("Moving " + this + " from " + oldWatermarkTime + " to " + watermarkTime);
    }

    @Override
    protected void provideDataAndAdvance(DataSourceRole role, Consumer<IndirectionDate> continuation) {
        IndirectionDate dataToProvide = this.data.remove();
        System.out.println(String.valueOf(this.dataChannel.getEntityName()) + ": Providing data " + dataToProvide + ", now=" + this.model.getSimulationControl().getCurrentSimulationTime());
        continuation.accept(dataToProvide);
    }
}

