/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.scheduler.implementations;

import org.palladiosimulator.indirections.scheduler.util.IndirectionSimulationUtil;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.runtimestate.IRuntimeStateAccessor;
import org.palladiosimulator.simulizar.runtimestate.SimuLizarRuntimeState;

public class RuntimeReconfigurator
implements IRuntimeStateAccessor {
    private int getPid(String id) {
        if (!id.startsWith("Plug_") || !id.endsWith(".ID")) {
            throw new PCMModelInterpreterException("???");
        }
        return Integer.valueOf(id.substring("Plug_".length(), id.length() - 3));
    }

    private int getHouseId(String id) {
        return this.getPid(id) / 10000;
    }

    private int getPlugId(String id) {
        return this.getPid(id) % 100;
    }

    private void applyFilter(UsageModel usageModel, int maxHouseId, int maxHouseholdId, int maxPlugId) {
        for (UsageScenario usageScenario : usageModel.getUsageScenario_UsageModel()) {
            int houseId = this.getHouseId(usageScenario.getId());
            int plugId = this.getPlugId(usageScenario.getId());
            if (houseId <= maxHouseId && plugId <= maxPlugId) {
                this.enableUsageScenario(usageScenario);
                continue;
            }
            this.disableUsageScenario(usageScenario);
        }
    }

    private Start findStart(UsageScenario usageScenario) {
        return (Start)usageScenario.getScenarioBehaviour_UsageScenario().getActions_ScenarioBehaviour().stream().filter(it -> it instanceof Start).findAny().get();
    }

    private Stop findStop(UsageScenario usageScenario) {
        return (Stop)usageScenario.getScenarioBehaviour_UsageScenario().getActions_ScenarioBehaviour().stream().filter(it -> it instanceof Stop).findAny().get();
    }

    private EntryLevelSystemCall findELSC(UsageScenario usageScenario) {
        return (EntryLevelSystemCall)usageScenario.getScenarioBehaviour_UsageScenario().getActions_ScenarioBehaviour().stream().filter(it -> it instanceof EntryLevelSystemCall).findAny().get();
    }

    private void enableUsageScenario(UsageScenario usageScenario) {
        Start start = this.findStart(usageScenario);
        Stop stop = this.findStop(usageScenario);
        EntryLevelSystemCall elsc = this.findELSC(usageScenario);
        start.setSuccessor((AbstractUserAction)elsc);
        elsc.setSuccessor((AbstractUserAction)stop);
    }

    private void disableUsageScenario(UsageScenario usageScenario) {
        Start start = this.findStart(usageScenario);
        Stop stop = this.findStop(usageScenario);
        EntryLevelSystemCall elsc = this.findELSC(usageScenario);
        start.setSuccessor((AbstractUserAction)stop);
    }

    public void setRuntimeStateModel(SimuLizarRuntimeState state) {
        boolean shouldUseReconfiguraiton = ((Repository)state.getPCMPartitionManager().getLocalPCMModel().getRepositories().get(0)).getEntityName().endsWith("-with-reconfiguration");
        if (shouldUseReconfiguraiton) {
            this.at(state, 0.0, 2, 2, 2);
            this.at(state, 20.0, 4, 4, 4);
            this.at(state, 40.0, 2, 2, 2);
            this.at(state, 60.0, 4, 4, 4);
            this.at(state, 80.0, 1, 1, 1);
            this.at(state, 100.0, 1, 1, 1);
            this.at(state, 120.0, 4, 4, 4);
            this.at(state, 200.0, 1, 1, 1);
            this.at(state, 300.0, -1, -1, -1);
        }
    }

    private void at(SimuLizarRuntimeState state, double time, int maxHouseId, int maxHouseholdId, int maxPlugId) {
        UsageModel model = state.getPCMPartitionManager().getLocalPCMModel().getUsageModel();
        IndirectionSimulationUtil.triggerOnce(state.getModel(), time, () -> this.applyFilter(model, maxHouseId, maxHouseholdId, maxPlugId));
    }
}

