/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.scheduler.operators;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Function;
import org.palladiosimulator.indirections.util.IterableUtil;

public final class Emitters {

    public static class EqualityCollectorWithHoldback<T, R>
    implements StatefulEmitter<T, HeldBackList<R, T>> {
        public Queue<HeldBackList<R, T>> currentCollections = new ArrayDeque<HeldBackList<R, T>>();
        private final int holdback;
        private final Function<T, R> keyFunction;

        public EqualityCollectorWithHoldback(Function<T, R> keyFunction, int holdback) {
            this.keyFunction = keyFunction;
            this.holdback = holdback;
        }

        @Override
        public Optional<HeldBackList<R, T>> accept(T t) {
            R key = this.keyFunction.apply(t);
            for (HeldBackList heldBackList : this.currentCollections) {
                Object collectionKey = IterableUtil.claimEqualKey(heldBackList.list, this.keyFunction);
                if (!collectionKey.equals(key)) continue;
                heldBackList.list.add(t);
                return Optional.empty();
            }
            HeldBackList heldBackList = new HeldBackList(key, new ArrayList());
            heldBackList.list.add(t);
            this.currentCollections.add(heldBackList);
            if (this.currentCollections.size() > this.holdback) {
                return Optional.of(this.currentCollections.remove());
            }
            return Optional.empty();
        }

        public static class HeldBackList<R, T> {
            public R key;
            public List<T> list;

            public HeldBackList(R key, List<T> list) {
                this.key = key;
                this.list = list;
            }
        }
    }

    public static interface StatefulEmitter<T, U> {
        public Optional<U> accept(T var1);
    }

    public static class Window {
        public final double end;
        public final double start;

        public Window(double start, double end) {
            this.start = start;
            this.end = end;
        }

        public boolean contains(double timestamp) {
            return this.start <= timestamp && this.end > timestamp;
        }

        public String toString() {
            return "W[" + this.start + "->" + this.end + "]";
        }
    }

    public static class WindowCalculator {
        public Window currentWindow;
        public Window emittedWindow;
        public final double gracePeriod;
        public final double shift;
        public final double size;

        public WindowCalculator(double size, double shift, double gracePeriod) {
            this.size = size;
            this.shift = shift;
            this.gracePeriod = gracePeriod;
        }

        public List<Window> advanceUntil(double currentSimulationTime) {
            ArrayList<Window> result = new ArrayList<Window>();
            while (currentSimulationTime - this.gracePeriod >= this.createNextWindow().end) {
                result.add(this.next());
            }
            return result;
        }

        public void skipUntil(double currentSimulationTime) {
            while (currentSimulationTime - this.gracePeriod >= this.createNextWindow().end) {
                this.next();
            }
        }

        public Window createNextWindow() {
            if (this.currentWindow == null) {
                return new Window(this.shift - this.size, this.shift);
            }
            return new Window(this.currentWindow.start + this.shift, this.currentWindow.start + this.shift + this.size);
        }

        public boolean isInCurrentWindow(double time) {
            return this.currentWindow.contains(time);
        }

        public Window next() {
            this.currentWindow = this.createNextWindow();
            return this.currentWindow;
        }
    }

    public static class WindowEmitter
    implements StatefulEmitter<Double, List<Window>> {
        private final WindowCalculator windowCalculator;

        public WindowEmitter(double size, double shift, double gracePeriod) {
            this.windowCalculator = new WindowCalculator(size, shift, gracePeriod);
        }

        @Override
        public Optional<List<Window>> accept(Double t) {
            List<Window> windows = this.windowCalculator.advanceUntil(t);
            return windows.isEmpty() ? Optional.empty() : Optional.of(windows);
        }
    }
}

