/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.scheduler.util;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.simucomframework.core.entities.SimuComEntity;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.variables.EvaluationProxy;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.ValueNotInFrameException;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEventFactory;
import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.indirections.interfaces.IndirectionDate;
import org.palladiosimulator.indirections.repository.DataChannel;
import org.palladiosimulator.indirections.repository.DataInterface;
import org.palladiosimulator.indirections.repository.JavaClassDataChannel;
import org.palladiosimulator.indirections.scheduler.data.ConcreteGroupingIndirectionDate;
import org.palladiosimulator.indirections.scheduler.data.ConcreteIndirectionDate;
import org.palladiosimulator.indirections.scheduler.data.GenericJoinedDate;
import org.palladiosimulator.indirections.scheduler.util.OneShotSimulationEntity;
import org.palladiosimulator.indirections.util.IterableUtil;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.stoex.api.StoExSerialiser;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.simulationevents.PeriodicallyTriggeredSimulationEntity;
import org.palladiosimulator.simulizar.utils.SimulatedStackHelper;

public final class IndirectionSimulationUtil {
    private static final Logger LOGGER = Logger.getLogger(IndirectionSimulationUtil.class);
    private static final StoExSerialiser STOEX_SERIALISER = StoExSerialiser.createInstance();

    public static final void addParameterToStackFrameWithCopying(SimulatedStackframe<Object> contextStackFrame, EList<VariableUsage> parameter, String parameterName, SimulatedStackframe<Object> targetStackFrame) {
        for (VariableUsage variableUsage : parameter) {
            if (variableUsage.getVariableCharacterisation_VariableUsage().isEmpty()) {
                AbstractNamedReference namedReference = variableUsage.getNamedReference__VariableUsage();
                String[] split = namedReference.getReferenceName().split("->");
                if (split.length != 2) {
                    throw new PCMModelInterpreterException("If no variable chacterisations are present, name must be of form 'input->output'. Name is: " + namedReference.getReferenceName());
                }
                String inputPrefix = String.valueOf(split[0]) + ".";
                String outputPrefix = String.valueOf(split[1]) + ".";
                List<Map.Entry> inputs = contextStackFrame.getContents().stream().filter(it -> ((String)it.getKey()).startsWith(inputPrefix)).collect(Collectors.toList());
                if (inputs.size() == 0) {
                    throw new PCMModelInterpreterException("Nothing found on stack frame for prefix '" + inputPrefix + "'. Available: " + contextStackFrame.getContents().stream().map(it -> (String)it.getKey()).collect(Collectors.joining(", ")));
                }
                inputs.forEach(it -> targetStackFrame.addValue(String.valueOf(outputPrefix) + ((String)it.getKey()).substring(inputPrefix.length()), it.getValue()));
                continue;
            }
            for (VariableCharacterisation variableCharacterisation : variableUsage.getVariableCharacterisation_VariableUsage()) {
                String id;
                PCMRandomVariable randomVariable = variableCharacterisation.getSpecification_VariableCharacterisation();
                AbstractNamedReference namedReference = variableCharacterisation.getVariableUsage_VariableCharacterisation().getNamedReference__VariableUsage();
                try {
                    id = String.valueOf(STOEX_SERIALISER.serialise(namedReference).toString()) + "." + variableCharacterisation.getType().getLiteral();
                }
                catch (NotSerializableException e1) {
                    throw new PCMModelInterpreterException("Could not serialise a named reference.", (Throwable)e1);
                }
                if (SimulatedStackHelper.isInnerReference((AbstractNamedReference)namedReference)) {
                    targetStackFrame.addValue(id, (Object)new EvaluationProxy(randomVariable.getSpecification(), contextStackFrame.copyFrame()));
                } else {
                    targetStackFrame.addValue(id, StackContext.evaluateStatic((String)randomVariable.getSpecification(), contextStackFrame));
                }
                if (!LOGGER.isDebugEnabled()) continue;
                try {
                    LOGGER.debug((Object)("Added value " + targetStackFrame.getValue(id) + " for id " + id + " to stackframe " + targetStackFrame));
                }
                catch (ValueNotInFrameException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static IndirectionDate claimDataFromStack(SimulatedStack<Object> stack, String id) {
        Object value;
        SimulatedStackframe currentStackFrame = stack.currentStackFrame();
        try {
            value = currentStackFrame.getValue(id);
        }
        catch (ValueNotInFrameException e) {
            throw new PCMModelInterpreterException("Expected id " + id + " on stack, but not found.", (Throwable)e);
        }
        if (!(value instanceof IndirectionDate)) {
            throw new PCMModelInterpreterException("Expected " + IndirectionDate.class.getName() + " for id " + id + ", but got " + value.toString() + "(" + value.getClass().getName() + ")");
        }
        return (IndirectionDate)value;
    }

    public static IndirectionDate createData(SimulatedStack<Object> contextStack, Iterable<VariableUsage> variableUsages, Collection<Double> time) {
        Map<String, Object> entries = IndirectionSimulationUtil.createDataEntries(contextStack, variableUsages);
        ConcreteIndirectionDate result = new ConcreteIndirectionDate(entries, time);
        return result;
    }

    public static Map<String, Object> createDataEntries(SimulatedStack<Object> contextStack, Iterable<VariableUsage> variableUsages) {
        SimulatedStackframe newStackFrame = new SimulatedStackframe();
        SimulatedStackHelper.addParameterToStackFrame((SimulatedStackframe)contextStack.currentStackFrame(), (EList)IterableUtil.toEList(variableUsages), (SimulatedStackframe)newStackFrame);
        Map entries = IterableUtil.toMap((Iterable)newStackFrame.getContents());
        return entries;
    }

    public static void createNewDataOnStack(SimulatedStack<Object> stack, String id, IndirectionDate date) {
        Object value = null;
        try {
            value = stack.currentStackFrame().getValue(id);
        }
        catch (ValueNotInFrameException valueNotInFrameException) {
            // empty catch block
        }
        if (value != null) {
            throw new PCMModelInterpreterException("Did expect " + id + " to not be present on stack, but found: " + value);
        }
        stack.currentStackFrame().addValue(id, (Object)date);
    }

    public static SimulatedStackframe<Object> indirectionDateToStackframe(String baseName, IndirectionDate date) {
        SimulatedStackframe stackframe = new SimulatedStackframe();
        IndirectionSimulationUtil.flattenDataOnStackframe((SimulatedStackframe<Object>)stackframe, baseName, date);
        return stackframe;
    }

    public static void flattenDataOnStack(SimulatedStack<Object> stack, String baseName, IndirectionDate date) {
        SimulatedStackframe currentStackframe = stack.currentStackFrame();
        IndirectionSimulationUtil.flattenDataOnStackframe((SimulatedStackframe<Object>)currentStackframe, baseName, date);
    }

    private static void flattenDataOnStackframe(SimulatedStackframe<Object> stackframe, String baseName, IndirectionDate date) {
        if (date instanceof ConcreteIndirectionDate) {
            ConcreteIndirectionDate indirectionDate = (ConcreteIndirectionDate)date;
            for (Map.Entry<String, Object> dataEntry : indirectionDate.getData().entrySet()) {
                stackframe.addValue(String.valueOf(baseName) + "." + dataEntry.getKey(), dataEntry.getValue());
            }
        } else if (date instanceof ConcreteGroupingIndirectionDate) {
            ConcreteGroupingIndirectionDate groupingIndirectionDate = (ConcreteGroupingIndirectionDate)date;
            for (Map.Entry<String, Object> dataEntry : groupingIndirectionDate.getData().entrySet()) {
                stackframe.addValue(String.valueOf(baseName) + "." + dataEntry.getKey(), dataEntry.getValue());
            }
        } else if (date instanceof GenericJoinedDate) {
            GenericJoinedDate genericJoinedDate = (GenericJoinedDate)date;
            for (Map.Entry entry : genericJoinedDate.data.entrySet()) {
                IndirectionSimulationUtil.flattenDataOnStackframe(stackframe, String.valueOf(baseName) + "." + entry.getKey(), entry.getValue().date);
            }
        } else {
            throw new PCMModelInterpreterException(String.valueOf(baseName) + " is not a ConcreteIndirectionDate, but a " + date.getClass().getName());
        }
    }

    public static Parameter getOneParameter(EventGroup eventGroup) {
        return ((EventType)IterableUtil.claimOne((Iterable)eventGroup.getEventTypes__EventGroup())).getParameter__EventType();
    }

    public static <T extends Entity> T initName(T entity, String name) {
        entity.setEntityName(name);
        entity.setId(String.valueOf(name) + ".ID");
        return entity;
    }

    public static <T extends Identifier> T initName(T identifier, String name) {
        identifier.setId(String.valueOf(name) + ".ID");
        return identifier;
    }

    public static void makeDateInformationAvailableOnStack(SimulatedStack<Object> stack, String referenceName) {
        Object o;
        SimulatedStackframe currentStackframe = stack.currentStackFrame();
        try {
            o = currentStackframe.getValue(referenceName);
        }
        catch (ValueNotInFrameException e) {
            e.printStackTrace();
            throw new PCMModelInterpreterException(String.valueOf(referenceName) + " not found on stack.", (Throwable)e);
        }
        IndirectionSimulationUtil.flattenDataOnStack(stack, referenceName, (IndirectionDate)o);
    }

    public static String rewriteVariableNamePrefix(String variableName, String incomingParameterName, String outgoingParameterName) {
        if (variableName.startsWith(incomingParameterName)) {
            return String.valueOf(outgoingParameterName) + variableName.substring(incomingParameterName.length());
        }
        throw new AssertionError((Object)("Variable '" + variableName + "' does not start with incoming paramete name: " + incomingParameterName));
    }

    public static PeriodicallyTriggeredSimulationEntity triggerPeriodically(final SimuComModel model, double firstOccurrence, double delay, final Runnable taskToRun) {
        return new PeriodicallyTriggeredSimulationEntity((ISimEventFactory)model.getSimEngineFactory(), firstOccurrence, delay){

            protected void triggerInternal() {
                System.out.println("Triggering periodic process at " + model.getSimulationControl().getCurrentSimulationTime());
                taskToRun.run();
            }
        };
    }

    public static SimuComEntity triggerOnce(final SimuComModel model, double delay, final Runnable taskToRun) {
        return new OneShotSimulationEntity(model, delay){

            @Override
            protected void triggerInternal() {
                System.out.println("Triggering single process at " + model.getSimulationControl().getCurrentSimulationTime());
                taskToRun.run();
            }
        };
    }

    public static void validateIndirectionDateStructure(IndirectionDate date, DataInterface dataInterface) {
        LOGGER.debug((Object)"Not validating indirection date structure");
    }

    public static void validateStackframeStructure(Map<String, Object> dataMap, String parameterName) {
        String parameterCharacterisationPrefix = String.valueOf(parameterName) + ".";
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            if (entry.getKey().startsWith(parameterCharacterisationPrefix)) continue;
            throw new IllegalArgumentException("Invalid characteristation for data frame: " + entry.getKey() + ", expected characteristations for " + parameterName);
        }
    }

    private IndirectionSimulationUtil() {
    }

    public static void requireNumberOfSinkSourceRoles(DataChannel dataChannel, Predicate<Integer> sinkRoleCheck, String sinkRoleCheckDescription, Predicate<Integer> sourceRoleCheck, String sourceRoleCheckDescription) {
        int numberOfSinkRoles = dataChannel.getDataSinkRoles().size();
        int numberOfSourceRoles = dataChannel.getDataSourceRoles().size();
        if (!sinkRoleCheck.test(numberOfSinkRoles)) {
            throw new PCMModelInterpreterException("Number of sink roles not suitable for " + dataChannel + ": expected " + sinkRoleCheckDescription + ", got " + numberOfSinkRoles);
        }
        if (!sourceRoleCheck.test(numberOfSourceRoles)) {
            throw new PCMModelInterpreterException("Number of source roles not suitable for " + dataChannel + ": expected " + sourceRoleCheckDescription + ", got " + numberOfSourceRoles);
        }
    }

    public static void requireExactNumberOfSinkSourceRoles(DataChannel dataChannel, int sinkRoleNumber, int sourceRoleNumber) {
        IndirectionSimulationUtil.requireNumberOfSinkSourceRoles(dataChannel, it -> it == sinkRoleNumber, "== " + sinkRoleNumber, it -> it == sourceRoleNumber, "== " + sourceRoleNumber);
    }

    public static double getDoubleParameter(JavaClassDataChannel dataChannel, String parameterName) {
        return Double.valueOf(IndirectionSimulationUtil.forceGetParameter(parameterName, dataChannel));
    }

    public static int getIntegerParameter(JavaClassDataChannel dataChannel, String parameterName) {
        return Integer.valueOf(IndirectionSimulationUtil.forceGetParameter(parameterName, dataChannel));
    }

    public static boolean getBooleanParameter(JavaClassDataChannel dataChannel, String parameterName) {
        return Boolean.valueOf(IndirectionSimulationUtil.forceGetParameter(parameterName, dataChannel));
    }

    public static String getStringParameter(JavaClassDataChannel dataChannel, String parameterName) {
        return IndirectionSimulationUtil.forceGetParameter(parameterName, dataChannel);
    }

    public static String forceGetParameter(String parameterName, JavaClassDataChannel dataChannel) {
        EList configEntries = dataChannel.getConfigEntries();
        return Objects.requireNonNull(IndirectionSimulationUtil.toConfigMap((Collection<String>)configEntries).get(parameterName), "Could not find parameter " + parameterName + " in configuration (" + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)configEntries) + ")");
    }

    public static Map<String, String> toConfigMap(Collection<String> entries) {
        return entries.stream().map(it -> IndirectionSimulationUtil.forceSplitAtFirstOccurence(it, "->")).collect(Collectors.toMap(it -> it[0], it -> it[1]));
    }

    private static String[] forceSplitAtFirstOccurence(String it, String splitter) {
        int split = it.indexOf(splitter);
        if (split == -1) {
            throw new PCMModelInterpreterException("Cannot split string " + it + " at " + splitter);
        }
        return new String[]{it.substring(0, split), it.substring(split + splitter.length())};
    }

    public static void flatResolveTimes(Object timeDependency, List<Double> times) {
        if (timeDependency instanceof Collection) {
            ((Collection)timeDependency).forEach(it -> IndirectionSimulationUtil.flatResolveTimes(it, times));
        } else if (timeDependency instanceof ConcreteIndirectionDate) {
            times.addAll(((ConcreteIndirectionDate)timeDependency).getTime());
        } else {
            throw new PCMModelInterpreterException("Error when getting date for " + timeDependency);
        }
    }

    public static List<Double> flatResolveTimes(List<Object> timeDependencies) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (Object it : timeDependencies) {
            IndirectionSimulationUtil.flatResolveTimes(it, result);
        }
        return result;
    }

    public static final class Pair<A, B> {
        public final A a;
        public final B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            return Objects.equals(this.a, other.a) && Objects.equals(this.b, other.b);
        }

        public static <A, B> Pair<A, B> of(A a, B b) {
            return new Pair<A, B>(a, b);
        }
    }
}

