/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.simulizar.rdseffswitch;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.measure.Measure;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Switch;
import org.palladiosimulator.indirections.actions.AddToDateAction;
import org.palladiosimulator.indirections.actions.AnalyseStackAction;
import org.palladiosimulator.indirections.actions.ConsumeDataAction;
import org.palladiosimulator.indirections.actions.CreateDateAction;
import org.palladiosimulator.indirections.actions.DataIteratorAction;
import org.palladiosimulator.indirections.actions.EmitDataAction;
import org.palladiosimulator.indirections.actions.PutTimeOnStackAction;
import org.palladiosimulator.indirections.actions.util.ActionsSwitch;
import org.palladiosimulator.indirections.composition.AssemblyDataConnector;
import org.palladiosimulator.indirections.interfaces.IndirectionDate;
import org.palladiosimulator.indirections.monitoring.simulizar.IndirectionMeasuringPointRegistry;
import org.palladiosimulator.indirections.monitoring.simulizar.TriggeredProxyProbe;
import org.palladiosimulator.indirections.repository.DataChannel;
import org.palladiosimulator.indirections.repository.DataSinkRole;
import org.palladiosimulator.indirections.repository.DataSourceRole;
import org.palladiosimulator.indirections.scheduler.IDataChannelResource;
import org.palladiosimulator.indirections.scheduler.data.GroupingIndirectionDate;
import org.palladiosimulator.indirections.scheduler.util.DataChannelResourceRegistry;
import org.palladiosimulator.indirections.scheduler.util.IndirectionSimulationUtil;
import org.palladiosimulator.indirections.util.IndirectionModelUtil;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.exceptions.SimulatedStackAccessException;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.RDSeffSwitchContributionFactory;
import org.palladiosimulator.simulizar.interpreter.result.InterpretationIssue;
import org.palladiosimulator.simulizar.interpreter.result.InterpreterResult;

public class IndirectionsRDSeffSwitch
extends ActionsSwitch<InterpreterResult> {
    public static final InterpreterResult NOT_OK = new InterpreterResult(){

        public boolean hasNoIssues() {
            return false;
        }

        public Iterable<InterpretationIssue> getIssues() {
            return Collections.singleton(new InterpretationIssue(){

                public boolean isHandled() {
                    return false;
                }
            });
        }
    };
    private RDSeffSwitchContributionFactory.RDSeffElementDispatcher parentSwitch;
    private static final Logger LOGGER = Logger.getLogger(IndirectionsRDSeffSwitch.class);
    private final Allocation allocation;
    private final AssemblyContext assemblyContext;
    private final InterpreterDefaultContext context;
    private final DataChannelResourceRegistry dataChannelResourceRegistry;
    private final IndirectionMeasuringPointRegistry indirectionMeasuringPointRegistry;
    private final SimulatedStackframe<Object> resultStackFrame;

    @AssistedInject
    public IndirectionsRDSeffSwitch(@Assisted InterpreterDefaultContext context, @Assisted RDSeffSwitchContributionFactory.RDSeffElementDispatcher parentSwitch, @InterpreterDefaultContext.MainContext InterpreterDefaultContext mainContext, DataChannelResourceRegistry dataChannelResourceRegistry) {
        this.parentSwitch = parentSwitch;
        this.context = context;
        this.allocation = context.getLocalPCMModelAtContextCreation().getAllocation();
        this.assemblyContext = (AssemblyContext)context.getAssemblyContextStack().lastElement();
        this.resultStackFrame = new SimulatedStackframe();
        this.dataChannelResourceRegistry = dataChannelResourceRegistry;
        this.indirectionMeasuringPointRegistry = IndirectionMeasuringPointRegistry.getInstanceFor((InterpreterDefaultContext)mainContext);
    }

    public InterpreterResult caseAddToDateAction(AddToDateAction action) {
        LOGGER.trace((Object)("Adding to date: " + action.getEntityName()));
        String referenceName = action.getVariableReference().getReferenceName();
        IndirectionDate date = IndirectionSimulationUtil.claimDataFromStack((SimulatedStack)this.context.getStack(), (String)referenceName);
        Map newEntries = IndirectionSimulationUtil.createDataEntries((SimulatedStack)this.context.getStack(), (Iterable)action.getVariableUsages());
        date.addData(newEntries);
        return InterpreterResult.OK;
    }

    public InterpreterResult caseAnalyseStackAction(AnalyseStackAction action) {
        LOGGER.trace((Object)("Analyzing data: " + action.getEntityName()));
        String referenceName = action.getVariableReference().getReferenceName();
        IndirectionDate data = IndirectionSimulationUtil.claimDataFromStack((SimulatedStack)this.context.getStack(), (String)referenceName);
        data.getTime().forEach(it -> this.measureDataAge(action, (double)it));
        return InterpreterResult.OK;
    }

    public InterpreterResult caseConsumeDataAction(ConsumeDataAction action) {
        LOGGER.trace((Object)("Consume data action: " + action.getEntityName()));
        AssemblyDataConnector assemblyDataConnector = IndirectionModelUtil.getExactlyOneAssemblyDataConnector((AssemblyContext)this.assemblyContext, (DataSinkRole)action.getDataSinkRole());
        RepositoryComponent sourceComponent = assemblyDataConnector.getSourceAssemblyContext().getEncapsulatedComponent__AssemblyContext();
        RepositoryComponent sinkComponent = assemblyDataConnector.getSinkAssemblyContext().getEncapsulatedComponent__AssemblyContext();
        if (!(sourceComponent instanceof DataChannel)) {
            throw new PCMModelInterpreterException("Currently, only direct connections between BasicComponents and DataChannels are supported. Found connector " + assemblyDataConnector.getId() + " that points from " + sourceComponent.getId() + " (" + sourceComponent.getClass().getName() + ") to " + sinkComponent.getId() + " (" + sinkComponent.getClass().getName() + ")");
        }
        DataChannel dataChannel = (DataChannel)sourceComponent;
        AssemblyContext sourceAssemblyContext = assemblyDataConnector.getSourceAssemblyContext();
        IDataChannelResource dataChannelResource = this.dataChannelResourceRegistry.getOrCreateDataChannelResource(dataChannel, sourceAssemblyContext);
        String threadName = Thread.currentThread().getName();
        LOGGER.trace((Object)("Trying to get from " + dataChannel.getEntityName() + ", resource: " + dataChannelResource.getName() + " (" + threadName + ")"));
        boolean result = dataChannelResource.get((ISchedulableProcess)this.context.getThread(), assemblyDataConnector.getDataSourceRole(), date -> {
            this.context.getStack().currentStackFrame().addValue(action.getVariableReference().getReferenceName(), date);
            IndirectionSimulationUtil.makeDateInformationAvailableOnStack((SimulatedStack)this.context.getStack(), (String)action.getVariableReference().getReferenceName());
        });
        LOGGER.trace((Object)("Continuing with " + this.context.getStack().currentStackFrame() + " (" + threadName + ")"));
        if (result) {
            return InterpreterResult.OK;
        }
        return NOT_OK;
    }

    public InterpreterResult caseEmitDataAction(EmitDataAction action) {
        double currentSimulationTime = this.context.getModel().getSimulationControl().getCurrentSimulationTime();
        LOGGER.trace((Object)("Emit event action: " + action.getEntityName() + ", " + currentSimulationTime));
        AssemblyDataConnector assemblyDataConnector = IndirectionModelUtil.getExactlyOneAssemblyDataConnector((AssemblyContext)this.assemblyContext, (DataSourceRole)action.getDataSourceRole());
        RepositoryComponent sourceComponent = assemblyDataConnector.getSourceAssemblyContext().getEncapsulatedComponent__AssemblyContext();
        RepositoryComponent sinkComponent = assemblyDataConnector.getSinkAssemblyContext().getEncapsulatedComponent__AssemblyContext();
        if (!(sinkComponent instanceof DataChannel)) {
            throw new PCMModelInterpreterException("Currently, only direct connections between BasicComponents and DataChannels are supported. Found connector " + assemblyDataConnector.getId() + " that points from " + sourceComponent.getId() + " (" + sourceComponent.getClass().getName() + ") to " + sinkComponent.getId() + " (" + sinkComponent.getClass().getName() + ")");
        }
        AssemblyContext sinkAssemblyContext = assemblyDataConnector.getSinkAssemblyContext();
        DataChannel dataChannel = IndirectionModelUtil.getDataChannel((AssemblyContext)sinkAssemblyContext);
        IDataChannelResource dataChannelResource = this.dataChannelResourceRegistry.getOrCreateDataChannelResource(dataChannel, sinkAssemblyContext);
        String referenceName = action.getVariableReference().getReferenceName();
        IndirectionDate date = IndirectionSimulationUtil.claimDataFromStack((SimulatedStack)this.context.getStack(), (String)referenceName);
        LOGGER.trace((Object)("Trying to emit data " + date + " to " + dataChannelResource.getName() + " - " + dataChannelResource.getId()));
        dataChannelResource.put((ISchedulableProcess)this.context.getThread(), assemblyDataConnector.getDataSinkRole(), date);
        return InterpreterResult.OK;
    }

    public InterpreterResult caseCreateDateAction(CreateDateAction action) {
        LOGGER.trace((Object)("Creating date: " + action.getEntityName()));
        String referenceName = action.getVariableReference().getReferenceName();
        ArrayList<Double> time = new ArrayList<Double>();
        EList dependsOn = action.getDependsOn();
        if (dependsOn.isEmpty()) {
            time.add(this.context.getModel().getSimulationControl().getCurrentSimulationTime());
        } else {
            List timeDependencies = dependsOn.stream().map(it -> StackContext.evaluateStatic((String)it.getSpecification(), (SimulatedStackframe)this.context.getStack().currentStackFrame())).collect(Collectors.toList());
            List times = IndirectionSimulationUtil.flatResolveTimes(timeDependencies);
            time.addAll(times);
        }
        IndirectionDate date = IndirectionSimulationUtil.createData((SimulatedStack)this.context.getStack(), (Iterable)action.getVariableUsages(), time);
        IndirectionSimulationUtil.createNewDataOnStack((SimulatedStack)this.context.getStack(), (String)referenceName, (IndirectionDate)date);
        return InterpreterResult.OK;
    }

    public InterpreterResult caseDataIteratorAction(DataIteratorAction action) {
        LOGGER.trace((Object)("Iterating over data: " + action.getEntityName()));
        String referenceName = action.getVariableReference().getReferenceName();
        IndirectionDate date = IndirectionSimulationUtil.claimDataFromStack((SimulatedStack)this.context.getStack(), (String)referenceName);
        if (!(date instanceof GroupingIndirectionDate)) {
            throw new PCMModelInterpreterException("Date cannot be iterated over, because it is not a grouping date: (is " + date.getClass().getName() + "): " + date.toString());
        }
        GroupingIndirectionDate groupingDate = (GroupingIndirectionDate)date;
        for (IndirectionDate iterationDate : groupingDate.getDataInGroup()) {
            LOGGER.debug((Object)("Iterating for " + iterationDate));
            SimulatedStackframe innerVariableStackFrame = this.context.getStack().createAndPushNewStackFrame(this.context.getStack().currentStackFrame());
            innerVariableStackFrame.addValue(String.valueOf(referenceName) + ".INNER", (Object)iterationDate);
            IndirectionSimulationUtil.makeDateInformationAvailableOnStack((SimulatedStack)this.context.getStack(), (String)(String.valueOf(referenceName) + ".INNER"));
            this.getParentSwitch().doSwitch((EObject)action.getBodyBehaviour_Loop());
            if (this.context.getStack().currentStackFrame() != innerVariableStackFrame) {
                throw new SimulatedStackAccessException("Inner value characterisations of inner collection variable expected");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Remove stack frame: " + innerVariableStackFrame));
            }
            this.context.getStack().removeStackFrame();
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("Finished iteration on " + iterationDate + " (" + action + ")"));
        }
        return InterpreterResult.OK;
    }

    public InterpreterResult casePutTimeOnStackAction(PutTimeOnStackAction object) {
        return (InterpreterResult)super.casePutTimeOnStackAction(object);
    }

    public RDSeffSwitchContributionFactory.RDSeffElementDispatcher getParentSwitch() {
        if (this.parentSwitch != null) {
            return this.parentSwitch;
        }
        return new RDSeffSwitchContributionFactory.RDSeffElementDispatcher(){

            public InterpreterResult doSwitch(EClass theEClass, EObject theEObject) {
                return this.doSwitch(theEClass, theEObject);
            }
        };
    }

    private void measureDataAge(AnalyseStackAction action, double value) {
        TriggeredProxyProbe probe = this.indirectionMeasuringPointRegistry.getProbe(action, this.assemblyContext);
        double currentSimulationTime = this.context.getModel().getSimulationControl().getCurrentSimulationTime();
        LOGGER.trace((Object)("Measuring age " + (currentSimulationTime - value) + " at " + currentSimulationTime));
        probe.doMeasure(Measure.valueOf((double)(currentSimulationTime - value), (Unit)SI.SECOND));
    }

    @AssistedFactory
    public static interface Factory
    extends RDSeffSwitchContributionFactory {
        public IndirectionsRDSeffSwitch create(InterpreterDefaultContext var1, RDSeffSwitchContributionFactory.RDSeffElementDispatcher var2);

        default public Switch<InterpreterResult> createRDSeffSwitch(InterpreterDefaultContext context, RDSeffSwitchContributionFactory.RDSeffElementDispatcher parentSwitch) {
            return this.create(context, parentSwitch);
        }
    }
}

