/**
 */
package org.palladiosimulator.indirections.repository.util;

import de.uka.ipd.sdq.identifier.util.IdentifierValidator;

import java.util.Map;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.EObjectValidator;

import org.palladiosimulator.indirections.repository.*;

import org.palladiosimulator.pcm.core.entity.util.EntityValidator;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see org.palladiosimulator.indirections.repository.RepositoryPackage
 * @generated
 */
public class RepositoryValidator extends EObjectValidator
{
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final RepositoryValidator INSTANCE = new RepositoryValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.indirections.repository";

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentifierValidator identifierValidator;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected org.palladiosimulator.pcm.repository.util.RepositoryValidator repositoryValidator;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EntityValidator entityValidator;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RepositoryValidator()
	{
		super();
		identifierValidator = IdentifierValidator.INSTANCE;
		repositoryValidator = org.palladiosimulator.pcm.repository.util.RepositoryValidator.INSTANCE;
		entityValidator = EntityValidator.INSTANCE;
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage()
	{
	  return RepositoryPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		switch (classifierID)
		{
			case RepositoryPackage.DATA_SINK_ROLE:
				return validateDataSinkRole((DataSinkRole)value, diagnostics, context);
			case RepositoryPackage.DATA_SOURCE_ROLE:
				return validateDataSourceRole((DataSourceRole)value, diagnostics, context);
			case RepositoryPackage.DATA_INTERFACE:
				return validateDataInterface((DataInterface)value, diagnostics, context);
			case RepositoryPackage.DATA_SIGNATURE:
				return validateDataSignature((DataSignature)value, diagnostics, context);
			case RepositoryPackage.DATA_CHANNEL:
				return validateDataChannel((DataChannel)value, diagnostics, context);
			case RepositoryPackage.JAVA_CLASS_DATA_CHANNEL:
				return validateJavaClassDataChannel((JavaClassDataChannel)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataSinkRole(DataSinkRole dataSinkRole, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(dataSinkRole, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(dataSinkRole, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(dataSinkRole, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(dataSinkRole, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(dataSinkRole, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(dataSinkRole, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(dataSinkRole, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(dataSinkRole, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(dataSinkRole, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(dataSinkRole, diagnostics, context);
		if (result || diagnostics != null) result &= validateDataSinkRole_sinkRoleOfComposedStructureHasExactlyOneDelegationConnector(dataSinkRole, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the sinkRoleOfComposedStructureHasExactlyOneDelegationConnector constraint of '<em>Data Sink Role</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String DATA_SINK_ROLE__SINK_ROLE_OF_COMPOSED_STRUCTURE_HAS_EXACTLY_ONE_DELEGATION_CONNECTOR__EEXPRESSION = "not self.providingEntity_ProvidedRole.oclIsKindOf(pcm::core::composition::ComposedStructure) or\n" +
		"self.providingEntity_ProvidedRole.oclAsType(pcm::core::composition::ComposedStructure).connectors__ComposedStructure->selectByKind(indirections::composition::DataSinkDelegationConnector)->select(c | c.outerDataSinkRole = self)->size() = 1";

	/**
	 * Validates the sinkRoleOfComposedStructureHasExactlyOneDelegationConnector constraint of '<em>Data Sink Role</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataSinkRole_sinkRoleOfComposedStructureHasExactlyOneDelegationConnector(DataSinkRole dataSinkRole, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(RepositoryPackage.Literals.DATA_SINK_ROLE,
				 dataSinkRole,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "sinkRoleOfComposedStructureHasExactlyOneDelegationConnector",
				 DATA_SINK_ROLE__SINK_ROLE_OF_COMPOSED_STRUCTURE_HAS_EXACTLY_ONE_DELEGATION_CONNECTOR__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataSourceRole(DataSourceRole dataSourceRole, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(dataSourceRole, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(dataSourceRole, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(dataSourceRole, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(dataSourceRole, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(dataSourceRole, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(dataSourceRole, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(dataSourceRole, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(dataSourceRole, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(dataSourceRole, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(dataSourceRole, diagnostics, context);
		if (result || diagnostics != null) result &= validateDataSourceRole_sourceRoleOfComposedStructureHasExactlyOneDelegationConnector(dataSourceRole, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the sourceRoleOfComposedStructureHasExactlyOneDelegationConnector constraint of '<em>Data Source Role</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String DATA_SOURCE_ROLE__SOURCE_ROLE_OF_COMPOSED_STRUCTURE_HAS_EXACTLY_ONE_DELEGATION_CONNECTOR__EEXPRESSION = "not self.requiringEntity_RequiredRole.oclIsKindOf(pcm::core::composition::ComposedStructure) or\n" +
		"self.requiringEntity_RequiredRole.oclAsType(pcm::core::composition::ComposedStructure).connectors__ComposedStructure->selectByKind(indirections::composition::DataSourceDelegationConnector)->select(c | c.outerDataSourceRole = self)->size() = 1";

	/**
	 * Validates the sourceRoleOfComposedStructureHasExactlyOneDelegationConnector constraint of '<em>Data Source Role</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataSourceRole_sourceRoleOfComposedStructureHasExactlyOneDelegationConnector(DataSourceRole dataSourceRole, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(RepositoryPackage.Literals.DATA_SOURCE_ROLE,
				 dataSourceRole,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "sourceRoleOfComposedStructureHasExactlyOneDelegationConnector",
				 DATA_SOURCE_ROLE__SOURCE_ROLE_OF_COMPOSED_STRUCTURE_HAS_EXACTLY_ONE_DELEGATION_CONNECTOR__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataInterface(DataInterface dataInterface, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(dataInterface, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(dataInterface, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(dataInterface, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(dataInterface, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(dataInterface, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(dataInterface, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(dataInterface, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(dataInterface, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(dataInterface, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(dataInterface, diagnostics, context);
		if (result || diagnostics != null) result &= repositoryValidator.validateInterface_noProtocolTypeIDUsedTwice(dataInterface, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataSignature(DataSignature dataSignature, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(dataSignature, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(dataSignature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(dataSignature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(dataSignature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(dataSignature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(dataSignature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(dataSignature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(dataSignature, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(dataSignature, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(dataSignature, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataChannel(DataChannel dataChannel, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(dataChannel, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(dataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(dataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(dataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(dataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(dataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(dataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(dataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(dataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(dataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= entityValidator.validateInterfaceProvidingEntity_needID(dataChannel, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateJavaClassDataChannel(JavaClassDataChannel javaClassDataChannel, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(javaClassDataChannel, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(javaClassDataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(javaClassDataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(javaClassDataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(javaClassDataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(javaClassDataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(javaClassDataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(javaClassDataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(javaClassDataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(javaClassDataChannel, diagnostics, context);
		if (result || diagnostics != null) result &= entityValidator.validateInterfaceProvidingEntity_needID(javaClassDataChannel, diagnostics, context);
		return result;
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator()
	{
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //RepositoryValidator
