/**
 */
package org.palladiosimulator.indirections.composition;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.palladiosimulator.indirections.composition.abstract_.AbstractPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * All connectors for sink/source roles that are either bound to a data channel or to an assembly context, e.g. for a Basic Component
 * <!-- end-model-doc -->
 * @see org.palladiosimulator.indirections.composition.CompositionFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/emf/2002/Ecore validationDelegates='http://www.eclipse.org/emf/2002/Ecore/OCL'"
 * @generated
 */
public interface CompositionPackage extends EPackage
{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "composition";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://palladiosimulator.org/Indirections/Composition/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "org.palladiosimulator.indirections.composition";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	CompositionPackage eINSTANCE = org.palladiosimulator.indirections.composition.impl.CompositionPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.palladiosimulator.indirections.composition.impl.AssemblyDataConnectorImpl <em>Assembly Data Connector</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.palladiosimulator.indirections.composition.impl.AssemblyDataConnectorImpl
	 * @see org.palladiosimulator.indirections.composition.impl.CompositionPackageImpl#getAssemblyDataConnector()
	 * @generated
	 */
	int ASSEMBLY_DATA_CONNECTOR = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSEMBLY_DATA_CONNECTOR__ID = AbstractPackage.ASSEMBLY_CONTEXT_SINK_CONNECTOR__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSEMBLY_DATA_CONNECTOR__ENTITY_NAME = AbstractPackage.ASSEMBLY_CONTEXT_SINK_CONNECTOR__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Parent Structure Connector</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSEMBLY_DATA_CONNECTOR__PARENT_STRUCTURE_CONNECTOR = AbstractPackage.ASSEMBLY_CONTEXT_SINK_CONNECTOR__PARENT_STRUCTURE_CONNECTOR;

	/**
	 * The feature id for the '<em><b>Data Source Role</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSEMBLY_DATA_CONNECTOR__DATA_SOURCE_ROLE = AbstractPackage.ASSEMBLY_CONTEXT_SINK_CONNECTOR__DATA_SOURCE_ROLE;

	/**
	 * The feature id for the '<em><b>Data Sink Role</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSEMBLY_DATA_CONNECTOR__DATA_SINK_ROLE = AbstractPackage.ASSEMBLY_CONTEXT_SINK_CONNECTOR__DATA_SINK_ROLE;

	/**
	 * The feature id for the '<em><b>Sink Assembly Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSEMBLY_DATA_CONNECTOR__SINK_ASSEMBLY_CONTEXT = AbstractPackage.ASSEMBLY_CONTEXT_SINK_CONNECTOR__SINK_ASSEMBLY_CONTEXT;

	/**
	 * The feature id for the '<em><b>Source Assembly Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSEMBLY_DATA_CONNECTOR__SOURCE_ASSEMBLY_CONTEXT = AbstractPackage.ASSEMBLY_CONTEXT_SINK_CONNECTOR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Assembly Data Connector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSEMBLY_DATA_CONNECTOR_FEATURE_COUNT = AbstractPackage.ASSEMBLY_CONTEXT_SINK_CONNECTOR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.palladiosimulator.indirections.composition.impl.DataSourceDelegationConnectorImpl <em>Data Source Delegation Connector</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.palladiosimulator.indirections.composition.impl.DataSourceDelegationConnectorImpl
	 * @see org.palladiosimulator.indirections.composition.impl.CompositionPackageImpl#getDataSourceDelegationConnector()
	 * @generated
	 */
	int DATA_SOURCE_DELEGATION_CONNECTOR = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SOURCE_DELEGATION_CONNECTOR__ID = AbstractPackage.DATA_DELEGATION_CONNECTOR__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SOURCE_DELEGATION_CONNECTOR__ENTITY_NAME = AbstractPackage.DATA_DELEGATION_CONNECTOR__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Parent Structure Connector</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SOURCE_DELEGATION_CONNECTOR__PARENT_STRUCTURE_CONNECTOR = AbstractPackage.DATA_DELEGATION_CONNECTOR__PARENT_STRUCTURE_CONNECTOR;

	/**
	 * The feature id for the '<em><b>Assembly Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SOURCE_DELEGATION_CONNECTOR__ASSEMBLY_CONTEXT = AbstractPackage.DATA_DELEGATION_CONNECTOR__ASSEMBLY_CONTEXT;

	/**
	 * The feature id for the '<em><b>Inner Data Source Role</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SOURCE_DELEGATION_CONNECTOR__INNER_DATA_SOURCE_ROLE = AbstractPackage.DATA_DELEGATION_CONNECTOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Outer Data Source Role</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SOURCE_DELEGATION_CONNECTOR__OUTER_DATA_SOURCE_ROLE = AbstractPackage.DATA_DELEGATION_CONNECTOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Source Delegation Connector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SOURCE_DELEGATION_CONNECTOR_FEATURE_COUNT = AbstractPackage.DATA_DELEGATION_CONNECTOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.palladiosimulator.indirections.composition.impl.DataSinkDelegationConnectorImpl <em>Data Sink Delegation Connector</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.palladiosimulator.indirections.composition.impl.DataSinkDelegationConnectorImpl
	 * @see org.palladiosimulator.indirections.composition.impl.CompositionPackageImpl#getDataSinkDelegationConnector()
	 * @generated
	 */
	int DATA_SINK_DELEGATION_CONNECTOR = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SINK_DELEGATION_CONNECTOR__ID = AbstractPackage.DATA_DELEGATION_CONNECTOR__ID;

	/**
	 * The feature id for the '<em><b>Entity Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SINK_DELEGATION_CONNECTOR__ENTITY_NAME = AbstractPackage.DATA_DELEGATION_CONNECTOR__ENTITY_NAME;

	/**
	 * The feature id for the '<em><b>Parent Structure Connector</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SINK_DELEGATION_CONNECTOR__PARENT_STRUCTURE_CONNECTOR = AbstractPackage.DATA_DELEGATION_CONNECTOR__PARENT_STRUCTURE_CONNECTOR;

	/**
	 * The feature id for the '<em><b>Assembly Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SINK_DELEGATION_CONNECTOR__ASSEMBLY_CONTEXT = AbstractPackage.DATA_DELEGATION_CONNECTOR__ASSEMBLY_CONTEXT;

	/**
	 * The feature id for the '<em><b>Inner Data Sink Role</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SINK_DELEGATION_CONNECTOR__INNER_DATA_SINK_ROLE = AbstractPackage.DATA_DELEGATION_CONNECTOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Outer Data Sink Role</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SINK_DELEGATION_CONNECTOR__OUTER_DATA_SINK_ROLE = AbstractPackage.DATA_DELEGATION_CONNECTOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Data Sink Delegation Connector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_SINK_DELEGATION_CONNECTOR_FEATURE_COUNT = AbstractPackage.DATA_DELEGATION_CONNECTOR_FEATURE_COUNT + 2;


	/**
	 * Returns the meta object for class '{@link org.palladiosimulator.indirections.composition.AssemblyDataConnector <em>Assembly Data Connector</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Assembly Data Connector</em>'.
	 * @see org.palladiosimulator.indirections.composition.AssemblyDataConnector
	 * @generated
	 */
	EClass getAssemblyDataConnector();

	/**
	 * Returns the meta object for class '{@link org.palladiosimulator.indirections.composition.DataSourceDelegationConnector <em>Data Source Delegation Connector</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Source Delegation Connector</em>'.
	 * @see org.palladiosimulator.indirections.composition.DataSourceDelegationConnector
	 * @generated
	 */
	EClass getDataSourceDelegationConnector();

	/**
	 * Returns the meta object for the reference '{@link org.palladiosimulator.indirections.composition.DataSourceDelegationConnector#getInnerDataSourceRole <em>Inner Data Source Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Inner Data Source Role</em>'.
	 * @see org.palladiosimulator.indirections.composition.DataSourceDelegationConnector#getInnerDataSourceRole()
	 * @see #getDataSourceDelegationConnector()
	 * @generated
	 */
	EReference getDataSourceDelegationConnector_InnerDataSourceRole();

	/**
	 * Returns the meta object for the reference '{@link org.palladiosimulator.indirections.composition.DataSourceDelegationConnector#getOuterDataSourceRole <em>Outer Data Source Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Outer Data Source Role</em>'.
	 * @see org.palladiosimulator.indirections.composition.DataSourceDelegationConnector#getOuterDataSourceRole()
	 * @see #getDataSourceDelegationConnector()
	 * @generated
	 */
	EReference getDataSourceDelegationConnector_OuterDataSourceRole();

	/**
	 * Returns the meta object for class '{@link org.palladiosimulator.indirections.composition.DataSinkDelegationConnector <em>Data Sink Delegation Connector</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data Sink Delegation Connector</em>'.
	 * @see org.palladiosimulator.indirections.composition.DataSinkDelegationConnector
	 * @generated
	 */
	EClass getDataSinkDelegationConnector();

	/**
	 * Returns the meta object for the reference '{@link org.palladiosimulator.indirections.composition.DataSinkDelegationConnector#getInnerDataSinkRole <em>Inner Data Sink Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Inner Data Sink Role</em>'.
	 * @see org.palladiosimulator.indirections.composition.DataSinkDelegationConnector#getInnerDataSinkRole()
	 * @see #getDataSinkDelegationConnector()
	 * @generated
	 */
	EReference getDataSinkDelegationConnector_InnerDataSinkRole();

	/**
	 * Returns the meta object for the reference '{@link org.palladiosimulator.indirections.composition.DataSinkDelegationConnector#getOuterDataSinkRole <em>Outer Data Sink Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Outer Data Sink Role</em>'.
	 * @see org.palladiosimulator.indirections.composition.DataSinkDelegationConnector#getOuterDataSinkRole()
	 * @see #getDataSinkDelegationConnector()
	 * @generated
	 */
	EReference getDataSinkDelegationConnector_OuterDataSinkRole();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	CompositionFactory getCompositionFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals
	{
		/**
		 * The meta object literal for the '{@link org.palladiosimulator.indirections.composition.impl.AssemblyDataConnectorImpl <em>Assembly Data Connector</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.palladiosimulator.indirections.composition.impl.AssemblyDataConnectorImpl
		 * @see org.palladiosimulator.indirections.composition.impl.CompositionPackageImpl#getAssemblyDataConnector()
		 * @generated
		 */
		EClass ASSEMBLY_DATA_CONNECTOR = eINSTANCE.getAssemblyDataConnector();

		/**
		 * The meta object literal for the '{@link org.palladiosimulator.indirections.composition.impl.DataSourceDelegationConnectorImpl <em>Data Source Delegation Connector</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.palladiosimulator.indirections.composition.impl.DataSourceDelegationConnectorImpl
		 * @see org.palladiosimulator.indirections.composition.impl.CompositionPackageImpl#getDataSourceDelegationConnector()
		 * @generated
		 */
		EClass DATA_SOURCE_DELEGATION_CONNECTOR = eINSTANCE.getDataSourceDelegationConnector();

		/**
		 * The meta object literal for the '<em><b>Inner Data Source Role</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_SOURCE_DELEGATION_CONNECTOR__INNER_DATA_SOURCE_ROLE = eINSTANCE.getDataSourceDelegationConnector_InnerDataSourceRole();

		/**
		 * The meta object literal for the '<em><b>Outer Data Source Role</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_SOURCE_DELEGATION_CONNECTOR__OUTER_DATA_SOURCE_ROLE = eINSTANCE.getDataSourceDelegationConnector_OuterDataSourceRole();

		/**
		 * The meta object literal for the '{@link org.palladiosimulator.indirections.composition.impl.DataSinkDelegationConnectorImpl <em>Data Sink Delegation Connector</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.palladiosimulator.indirections.composition.impl.DataSinkDelegationConnectorImpl
		 * @see org.palladiosimulator.indirections.composition.impl.CompositionPackageImpl#getDataSinkDelegationConnector()
		 * @generated
		 */
		EClass DATA_SINK_DELEGATION_CONNECTOR = eINSTANCE.getDataSinkDelegationConnector();

		/**
		 * The meta object literal for the '<em><b>Inner Data Sink Role</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_SINK_DELEGATION_CONNECTOR__INNER_DATA_SINK_ROLE = eINSTANCE.getDataSinkDelegationConnector_InnerDataSinkRole();

		/**
		 * The meta object literal for the '<em><b>Outer Data Sink Role</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA_SINK_DELEGATION_CONNECTOR__OUTER_DATA_SINK_ROLE = eINSTANCE.getDataSinkDelegationConnector_OuterDataSinkRole();

	}

} //CompositionPackage
