/**
 */
package org.palladiosimulator.indirections.composition;

import org.palladiosimulator.indirections.composition.abstract_.DataDelegationConnector;

import org.palladiosimulator.indirections.repository.DataSourceRole;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Data Source Delegation Connector</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.palladiosimulator.indirections.composition.DataSourceDelegationConnector#getInnerDataSourceRole <em>Inner Data Source Role</em>}</li>
 *   <li>{@link org.palladiosimulator.indirections.composition.DataSourceDelegationConnector#getOuterDataSourceRole <em>Outer Data Source Role</em>}</li>
 * </ul>
 *
 * @see org.palladiosimulator.indirections.composition.CompositionPackage#getDataSourceDelegationConnector()
 * @model annotation="http://www.eclipse.org/emf/2002/Ecore constraints='innerAndOuterDataInterfacesMatch innerRoleAndAssemblyContextMatch'"
 *        annotation="http://www.eclipse.org/emf/2002/Ecore/OCL innerAndOuterDataInterfacesMatch='self.innerDataSourceRole.dataInterface = self.outerDataSourceRole.dataInterface' innerRoleAndAssemblyContextMatch='self.assemblyContext.encapsulatedComponent__AssemblyContext.requiredRoles_InterfaceRequiringEntity-&gt;includes(self.innerDataSourceRole)'"
 * @generated
 */
public interface DataSourceDelegationConnector extends DataDelegationConnector
{
	/**
	 * Returns the value of the '<em><b>Inner Data Source Role</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Inner Data Source Role</em>' reference.
	 * @see #setInnerDataSourceRole(DataSourceRole)
	 * @see org.palladiosimulator.indirections.composition.CompositionPackage#getDataSourceDelegationConnector_InnerDataSourceRole()
	 * @model required="true"
	 * @generated
	 */
	DataSourceRole getInnerDataSourceRole();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.indirections.composition.DataSourceDelegationConnector#getInnerDataSourceRole <em>Inner Data Source Role</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inner Data Source Role</em>' reference.
	 * @see #getInnerDataSourceRole()
	 * @generated
	 */
	void setInnerDataSourceRole(DataSourceRole value);

	/**
	 * Returns the value of the '<em><b>Outer Data Source Role</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Outer Data Source Role</em>' reference.
	 * @see #setOuterDataSourceRole(DataSourceRole)
	 * @see org.palladiosimulator.indirections.composition.CompositionPackage#getDataSourceDelegationConnector_OuterDataSourceRole()
	 * @model required="true"
	 * @generated
	 */
	DataSourceRole getOuterDataSourceRole();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.indirections.composition.DataSourceDelegationConnector#getOuterDataSourceRole <em>Outer Data Source Role</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Outer Data Source Role</em>' reference.
	 * @see #getOuterDataSourceRole()
	 * @generated
	 */
	void setOuterDataSourceRole(DataSourceRole value);

} // DataSourceDelegationConnector
