/**
 */
package org.palladiosimulator.indirections.composition.util;

import de.uka.ipd.sdq.identifier.util.IdentifierValidator;

import java.util.Map;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.EObjectValidator;

import org.palladiosimulator.indirections.composition.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see org.palladiosimulator.indirections.composition.CompositionPackage
 * @generated
 */
public class CompositionValidator extends EObjectValidator
{
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final CompositionValidator INSTANCE = new CompositionValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.indirections.composition";

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentifierValidator identifierValidator;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CompositionValidator()
	{
		super();
		identifierValidator = IdentifierValidator.INSTANCE;
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage()
	{
	  return CompositionPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		switch (classifierID)
		{
			case CompositionPackage.ASSEMBLY_DATA_CONNECTOR:
				return validateAssemblyDataConnector((AssemblyDataConnector)value, diagnostics, context);
			case CompositionPackage.DATA_SOURCE_DELEGATION_CONNECTOR:
				return validateDataSourceDelegationConnector((DataSourceDelegationConnector)value, diagnostics, context);
			case CompositionPackage.DATA_SINK_DELEGATION_CONNECTOR:
				return validateDataSinkDelegationConnector((DataSinkDelegationConnector)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAssemblyDataConnector(AssemblyDataConnector assemblyDataConnector, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(assemblyDataConnector, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(assemblyDataConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(assemblyDataConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(assemblyDataConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(assemblyDataConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(assemblyDataConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(assemblyDataConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(assemblyDataConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(assemblyDataConnector, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(assemblyDataConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validateAssemblyDataConnector_sinkRoleAndAssemblyContextMatch(assemblyDataConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validateAssemblyDataConnector_sourceRoleAndAssemblyContextMatch(assemblyDataConnector, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the sinkRoleAndAssemblyContextMatch constraint of '<em>Assembly Data Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String ASSEMBLY_DATA_CONNECTOR__SINK_ROLE_AND_ASSEMBLY_CONTEXT_MATCH__EEXPRESSION = "self.sinkAssemblyContext.encapsulatedComponent__AssemblyContext.providedRoles_InterfaceProvidingEntity->includes(self.dataSinkRole)";

	/**
	 * Validates the sinkRoleAndAssemblyContextMatch constraint of '<em>Assembly Data Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAssemblyDataConnector_sinkRoleAndAssemblyContextMatch(AssemblyDataConnector assemblyDataConnector, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(CompositionPackage.Literals.ASSEMBLY_DATA_CONNECTOR,
				 assemblyDataConnector,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "sinkRoleAndAssemblyContextMatch",
				 ASSEMBLY_DATA_CONNECTOR__SINK_ROLE_AND_ASSEMBLY_CONTEXT_MATCH__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * The cached validation expression for the sourceRoleAndAssemblyContextMatch constraint of '<em>Assembly Data Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String ASSEMBLY_DATA_CONNECTOR__SOURCE_ROLE_AND_ASSEMBLY_CONTEXT_MATCH__EEXPRESSION = "self.sourceAssemblyContext.encapsulatedComponent__AssemblyContext.requiredRoles_InterfaceRequiringEntity->includes(self.dataSourceRole)";

	/**
	 * Validates the sourceRoleAndAssemblyContextMatch constraint of '<em>Assembly Data Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAssemblyDataConnector_sourceRoleAndAssemblyContextMatch(AssemblyDataConnector assemblyDataConnector, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(CompositionPackage.Literals.ASSEMBLY_DATA_CONNECTOR,
				 assemblyDataConnector,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "sourceRoleAndAssemblyContextMatch",
				 ASSEMBLY_DATA_CONNECTOR__SOURCE_ROLE_AND_ASSEMBLY_CONTEXT_MATCH__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataSourceDelegationConnector(DataSourceDelegationConnector dataSourceDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(dataSourceDelegationConnector, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(dataSourceDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(dataSourceDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(dataSourceDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(dataSourceDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(dataSourceDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(dataSourceDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(dataSourceDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(dataSourceDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(dataSourceDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validateDataSourceDelegationConnector_innerAndOuterDataInterfacesMatch(dataSourceDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validateDataSourceDelegationConnector_innerRoleAndAssemblyContextMatch(dataSourceDelegationConnector, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the innerAndOuterDataInterfacesMatch constraint of '<em>Data Source Delegation Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String DATA_SOURCE_DELEGATION_CONNECTOR__INNER_AND_OUTER_DATA_INTERFACES_MATCH__EEXPRESSION = "self.innerDataSourceRole.dataInterface = self.outerDataSourceRole.dataInterface";

	/**
	 * Validates the innerAndOuterDataInterfacesMatch constraint of '<em>Data Source Delegation Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataSourceDelegationConnector_innerAndOuterDataInterfacesMatch(DataSourceDelegationConnector dataSourceDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(CompositionPackage.Literals.DATA_SOURCE_DELEGATION_CONNECTOR,
				 dataSourceDelegationConnector,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "innerAndOuterDataInterfacesMatch",
				 DATA_SOURCE_DELEGATION_CONNECTOR__INNER_AND_OUTER_DATA_INTERFACES_MATCH__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * The cached validation expression for the innerRoleAndAssemblyContextMatch constraint of '<em>Data Source Delegation Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String DATA_SOURCE_DELEGATION_CONNECTOR__INNER_ROLE_AND_ASSEMBLY_CONTEXT_MATCH__EEXPRESSION = "self.assemblyContext.encapsulatedComponent__AssemblyContext.requiredRoles_InterfaceRequiringEntity->includes(self.innerDataSourceRole)";

	/**
	 * Validates the innerRoleAndAssemblyContextMatch constraint of '<em>Data Source Delegation Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataSourceDelegationConnector_innerRoleAndAssemblyContextMatch(DataSourceDelegationConnector dataSourceDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(CompositionPackage.Literals.DATA_SOURCE_DELEGATION_CONNECTOR,
				 dataSourceDelegationConnector,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "innerRoleAndAssemblyContextMatch",
				 DATA_SOURCE_DELEGATION_CONNECTOR__INNER_ROLE_AND_ASSEMBLY_CONTEXT_MATCH__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataSinkDelegationConnector(DataSinkDelegationConnector dataSinkDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(dataSinkDelegationConnector, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(dataSinkDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(dataSinkDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(dataSinkDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(dataSinkDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(dataSinkDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(dataSinkDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(dataSinkDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(dataSinkDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(dataSinkDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validateDataSinkDelegationConnector_innerAndOuterDataInterfacesMatch(dataSinkDelegationConnector, diagnostics, context);
		if (result || diagnostics != null) result &= validateDataSinkDelegationConnector_innerRoleAndAssemblyContextMatch(dataSinkDelegationConnector, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the innerAndOuterDataInterfacesMatch constraint of '<em>Data Sink Delegation Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String DATA_SINK_DELEGATION_CONNECTOR__INNER_AND_OUTER_DATA_INTERFACES_MATCH__EEXPRESSION = "self.innerDataSinkRole.dataInterface = self.outerDataSinkRole.dataInterface";

	/**
	 * Validates the innerAndOuterDataInterfacesMatch constraint of '<em>Data Sink Delegation Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataSinkDelegationConnector_innerAndOuterDataInterfacesMatch(DataSinkDelegationConnector dataSinkDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(CompositionPackage.Literals.DATA_SINK_DELEGATION_CONNECTOR,
				 dataSinkDelegationConnector,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "innerAndOuterDataInterfacesMatch",
				 DATA_SINK_DELEGATION_CONNECTOR__INNER_AND_OUTER_DATA_INTERFACES_MATCH__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * The cached validation expression for the innerRoleAndAssemblyContextMatch constraint of '<em>Data Sink Delegation Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String DATA_SINK_DELEGATION_CONNECTOR__INNER_ROLE_AND_ASSEMBLY_CONTEXT_MATCH__EEXPRESSION = "self.assemblyContext.encapsulatedComponent__AssemblyContext.providedRoles_InterfaceProvidingEntity->includes(self.innerDataSinkRole)";

	/**
	 * Validates the innerRoleAndAssemblyContextMatch constraint of '<em>Data Sink Delegation Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDataSinkDelegationConnector_innerRoleAndAssemblyContextMatch(DataSinkDelegationConnector dataSinkDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(CompositionPackage.Literals.DATA_SINK_DELEGATION_CONNECTOR,
				 dataSinkDelegationConnector,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "innerRoleAndAssemblyContextMatch",
				 DATA_SINK_DELEGATION_CONNECTOR__INNER_ROLE_AND_ASSEMBLY_CONTEXT_MATCH__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator()
	{
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //CompositionValidator
