/**
 */
package org.palladiosimulator.indirections.composition;

import org.palladiosimulator.indirections.composition.abstract_.DataDelegationConnector;

import org.palladiosimulator.indirections.repository.DataSinkRole;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Data Sink Delegation Connector</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.palladiosimulator.indirections.composition.DataSinkDelegationConnector#getInnerDataSinkRole <em>Inner Data Sink Role</em>}</li>
 *   <li>{@link org.palladiosimulator.indirections.composition.DataSinkDelegationConnector#getOuterDataSinkRole <em>Outer Data Sink Role</em>}</li>
 * </ul>
 *
 * @see org.palladiosimulator.indirections.composition.CompositionPackage#getDataSinkDelegationConnector()
 * @model annotation="http://www.eclipse.org/emf/2002/Ecore constraints='innerAndOuterDataInterfacesMatch innerRoleAndAssemblyContextMatch'"
 *        annotation="http://www.eclipse.org/emf/2002/Ecore/OCL innerAndOuterDataInterfacesMatch='self.innerDataSinkRole.dataInterface = self.outerDataSinkRole.dataInterface' innerRoleAndAssemblyContextMatch='self.assemblyContext.encapsulatedComponent__AssemblyContext.providedRoles_InterfaceProvidingEntity-&gt;includes(self.innerDataSinkRole)'"
 * @generated
 */
public interface DataSinkDelegationConnector extends DataDelegationConnector
{
	/**
	 * Returns the value of the '<em><b>Inner Data Sink Role</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Inner Data Sink Role</em>' reference.
	 * @see #setInnerDataSinkRole(DataSinkRole)
	 * @see org.palladiosimulator.indirections.composition.CompositionPackage#getDataSinkDelegationConnector_InnerDataSinkRole()
	 * @model required="true"
	 * @generated
	 */
	DataSinkRole getInnerDataSinkRole();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.indirections.composition.DataSinkDelegationConnector#getInnerDataSinkRole <em>Inner Data Sink Role</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inner Data Sink Role</em>' reference.
	 * @see #getInnerDataSinkRole()
	 * @generated
	 */
	void setInnerDataSinkRole(DataSinkRole value);

	/**
	 * Returns the value of the '<em><b>Outer Data Sink Role</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Outer Data Sink Role</em>' reference.
	 * @see #setOuterDataSinkRole(DataSinkRole)
	 * @see org.palladiosimulator.indirections.composition.CompositionPackage#getDataSinkDelegationConnector_OuterDataSinkRole()
	 * @model required="true"
	 * @generated
	 */
	DataSinkRole getOuterDataSinkRole();

	/**
	 * Sets the value of the '{@link org.palladiosimulator.indirections.composition.DataSinkDelegationConnector#getOuterDataSinkRole <em>Outer Data Sink Role</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Outer Data Sink Role</em>' reference.
	 * @see #getOuterDataSinkRole()
	 * @generated
	 */
	void setOuterDataSinkRole(DataSinkRole value);

} // DataSinkDelegationConnector
