/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.util;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.palladiosimulator.indirections.composition.AssemblyDataConnector;
import org.palladiosimulator.indirections.repository.DataChannel;
import org.palladiosimulator.indirections.repository.DataSinkRole;
import org.palladiosimulator.indirections.repository.DataSourceRole;
import org.palladiosimulator.indirections.util.IterableUtil;
import org.palladiosimulator.indirections.util.ObjectUtil;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;

public final class IndirectionModelUtil {
    private IndirectionModelUtil() {
    }

    public static Stream<AssemblyDataConnector> getAllAssemblyDataConnectors(AssemblyContext assemblyContext) {
        return assemblyContext.getParentStructure__AssemblyContext().getConnectors__ComposedStructure().stream().filter(AssemblyDataConnector.class::isInstance).map(AssemblyDataConnector.class::cast);
    }

    public static AssemblyDataConnector getExactlyOneAssemblyDataConnector(AssemblyContext assemblyContext, DataSinkRole dataSinkRole) {
        return (AssemblyDataConnector)IterableUtil.claimOne(IndirectionModelUtil.getAllAssemblyDataConnectors(assemblyContext).filter(it -> it.getDataSinkRole().equals(dataSinkRole)).collect(Collectors.toList()));
    }

    public static AssemblyDataConnector getExactlyOneAssemblyDataConnector(AssemblyContext assemblyContext, DataSourceRole dataSourceRole) {
        return (AssemblyDataConnector)IterableUtil.claimOne(IndirectionModelUtil.getAllAssemblyDataConnectors(assemblyContext).filter(it -> it.getDataSourceRole().equals(dataSourceRole)).collect(Collectors.toList()));
    }

    public static DataChannel getDataChannel(AssemblyContext assemblyContext) {
        DataChannel dataChannel = ObjectUtil.forceCast(assemblyContext.getEncapsulatedComponent__AssemblyContext(), DataChannel.class);
        return dataChannel;
    }
}

