/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;

public final class IterableUtil {
    public static final <A extends Iterable<?>> A claimAtLeastOne(A iterable) {
        Iterator<?> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("It was claimed that the collection '" + iterable + "' contains at least one element!");
        }
        return iterable;
    }

    public static final <A extends Iterable<T>, T> T claimEqual(A iterable) {
        T first = iterable.iterator().next();
        for (T t : iterable) {
            if (Objects.equals(t, first)) continue;
            throw new IllegalStateException("It was claimed that the collection '" + iterable + "' contains only equal elements! Found " + first + " and " + t);
        }
        return first;
    }

    public static final <A extends Iterable<T>, T, R> R claimEqualKey(A iterable, Function<T, R> keyFunction) {
        T first = iterable.iterator().next();
        for (T t : iterable) {
            if (Objects.equals(keyFunction.apply(t), keyFunction.apply(first))) continue;
            throw new IllegalStateException("It was claimed that the collection '" + iterable + "' contains only elements with equal key! Found " + first + " and " + t);
        }
        return keyFunction.apply(first);
    }

    public static final <A extends Iterable<T>, T> T claimOne(A iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            T one = iterator.next();
            if (!iterator.hasNext()) {
                return one;
            }
        }
        throw new IllegalStateException("It was claimed that the collection '" + iterable + "' contains exactly one element!");
    }

    public static <U, T extends U> Collection<T> claimType(Collection<U> collection, Class<? extends T> claimedElementType) {
        return collection;
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> EList<T> toEList(Iterable<T> iterable) {
        return ECollections.asEList(IterableUtil.stream(iterable).collect(Collectors.toList()));
    }

    public static <K, V> Map<K, V> toMap(Iterable<Map.Entry<K, V>> entries) {
        return IterableUtil.stream(entries).collect(Collectors.toMap(it -> it.getKey(), it -> it.getValue()));
    }

    private IterableUtil() {
    }
}

