/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.indirections.util;

import java.util.Optional;
import java.util.function.Supplier;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;

public final class ObjectUtil {
    public static <U, T extends U> Optional<T> tryCast(U in, Class<T> type) {
        if (!type.isAssignableFrom(in.getClass())) {
            return Optional.empty();
        }
        return Optional.ofNullable(type.cast(in));
    }

    public static <X extends Throwable, U, T extends U> T forceCast(U in, Class<T> type, Supplier<? extends X> exceptionSupplier) throws X {
        if (!type.isAssignableFrom(in.getClass())) {
            throw (Throwable)exceptionSupplier.get();
        }
        return type.cast(in);
    }

    public static <U, T extends U> T forceCast(U in, Class<T> type) {
        if (!type.isAssignableFrom(in.getClass())) {
            throw new PCMModelInterpreterException("Expected " + type.getName() + " but got " + in);
        }
        return type.cast(in);
    }

    private ObjectUtil() {
    }
}

