/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.datamanipulation;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointPackage;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryFactory;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjectiveRepository;
import org.palladiosimulator.servicelevelobjective.ServicelevelObjectiveFactory;
import org.palladiosimulator.servicelevelobjective.ServicelevelObjectivePackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RepositoryCreator {
    private static final String MEASURINGPOINT_REPOSITORY_FILE_ENDING = "/default.measuringpoint";
    private MeasuringpointPackage measuringpointPackage;
    private MeasuringpointFactory measuringpointFactory;
    private static final String MONITORREPOSITORY_FILE_ENDING = "/default.monitorrepository";
    private MonitorRepositoryFactory monitorFactory;
    private MonitorRepositoryPackage monitorPackage;
    private static final String SLO_REPOSITORY_FILE_ENDING = "/default.slo";
    protected ServicelevelObjectivePackage serviceLevelObjectivePackage;
    protected ServicelevelObjectiveFactory servicelevelObjectiveFactory;
    private static RepositoryCreator instance;
    private final Logger logger = LoggerFactory.getLogger(RepositoryCreator.class);

    private RepositoryCreator() {
        this.measuringpointPackage = MeasuringpointPackage.eINSTANCE;
        this.measuringpointFactory = this.measuringpointPackage.getMeasuringpointFactory();
        this.monitorPackage = MonitorRepositoryPackage.eINSTANCE;
        this.monitorFactory = this.monitorPackage.getMonitorRepositoryFactory();
        this.serviceLevelObjectivePackage = ServicelevelObjectivePackage.eINSTANCE;
        this.servicelevelObjectiveFactory = this.serviceLevelObjectivePackage.getServicelevelObjectiveFactory();
    }

    public static RepositoryCreator getInstance() {
        if (instance == null) {
            instance = new RepositoryCreator();
        }
        return instance;
    }

    public MeasuringPointRepository createMeasuringPointRepository(IProject project) {
        String measuringPointRepositoryfileName = project.getFullPath() + MEASURINGPOINT_REPOSITORY_FILE_ENDING;
        URI measuringPointRepositoryfileURI = URI.createPlatformResourceURI((String)measuringPointRepositoryfileName, (boolean)true);
        LinkedList<ResourceItemProviderAdapterFactory> factories = new LinkedList<ResourceItemProviderAdapterFactory>();
        factories.add(new ResourceItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack);
        Resource resource = editingDomain.getResourceSet().createResource(measuringPointRepositoryfileURI);
        EClass measuringPointRepository = this.measuringpointPackage.getMeasuringPointRepository();
        EObject measuringPointRepositoryRootObject = this.measuringpointFactory.create(measuringPointRepository);
        if (measuringPointRepositoryRootObject != null) {
            resource.getContents().add((Object)measuringPointRepositoryRootObject);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        try {
            resource.save(options);
        }
        catch (IOException e) {
            this.logger.warn("IOException when attempting to create Measuring Point Repository. Stacktrace: {}", (Object)e.getMessage());
        }
        return (MeasuringPointRepository)measuringPointRepositoryRootObject;
    }

    public MonitorRepository createMonitorRepository(IProject project) {
        String monitorRepositoryfileName = project.getFullPath() + MONITORREPOSITORY_FILE_ENDING;
        URI monitorRepositoryfileURI = URI.createPlatformResourceURI((String)monitorRepositoryfileName, (boolean)true);
        LinkedList<ResourceItemProviderAdapterFactory> factories = new LinkedList<ResourceItemProviderAdapterFactory>();
        factories.add(new ResourceItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack);
        Resource resource = editingDomain.getResourceSet().createResource(monitorRepositoryfileURI);
        EClass monitorRepository = this.monitorPackage.getMonitorRepository();
        EObject monitorRepositoryRootObject = this.monitorFactory.create(monitorRepository);
        if (monitorRepositoryRootObject != null) {
            resource.getContents().add((Object)monitorRepositoryRootObject);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        try {
            resource.save(options);
        }
        catch (IOException e) {
            this.logger.warn("IOException when attempting to create Monitor Repository. Stacktrace: {}", (Object)e.getMessage());
        }
        return (MonitorRepository)monitorRepositoryRootObject;
    }

    public ServiceLevelObjectiveRepository createSLORepository(IProject project) {
        String servicelevelRepositoryfileName = project.getFullPath() + SLO_REPOSITORY_FILE_ENDING;
        URI servicelevelRepositoryfileURI = URI.createPlatformResourceURI((String)servicelevelRepositoryfileName, (boolean)true);
        LinkedList<ResourceItemProviderAdapterFactory> factories = new LinkedList<ResourceItemProviderAdapterFactory>();
        factories.add(new ResourceItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack);
        Resource resource = editingDomain.getResourceSet().createResource(servicelevelRepositoryfileURI);
        EClass servicelevelRepository = this.serviceLevelObjectivePackage.getServiceLevelObjectiveRepository();
        EObject servicelevelRootObject = this.servicelevelObjectiveFactory.create(servicelevelRepository);
        if (servicelevelRootObject != null) {
            resource.getContents().add((Object)servicelevelRootObject);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        try {
            resource.save(options);
        }
        catch (IOException e) {
            this.logger.warn("IOException when attempting to create ServiceLevelObjectiv Repository. Stacktrace: {}", (Object)e.getMessage());
        }
        return (ServiceLevelObjectiveRepository)servicelevelRootObject;
    }
}

