/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizardmodel.pages;

import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.measurementsui.dataprovider.DataApplication;
import org.palladiosimulator.measurementsui.dataprovider.SloProvider;
import org.palladiosimulator.measurementsui.wizardmodel.WizardModelSlo;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;

public class SloMeasurementSpecSelectionWizardModel
implements WizardModelSlo {
    private static final String SET_MSPEC_INFO_TEXT = "A Service Level Objective always needs a measurement specification.";
    private static final String SET_MSPEC_TITEL = "Bind a measurement specification";
    private DataApplication dataApp = DataApplication.getInstance();
    private EList<Monitor> monitorList = this.dataApp.getMonitorRepository().getMonitors();
    private SloProvider sloProvider;

    public SloMeasurementSpecSelectionWizardModel(SloProvider dataProvider, boolean isEditing) {
        this.sloProvider = dataProvider;
    }

    @Override
    public boolean canFinish() {
        return this.sloProvider.getMeasurementSpecification() != null;
    }

    public ServiceLevelObjective getSlo() {
        return this.sloProvider.getServiceLevelObjective();
    }

    public EList<Monitor> getMonitors() {
        return this.monitorList;
    }

    public EList<MeasurementSpecification> getMeasurementSpecs(Monitor monitor) {
        return monitor.getMeasurementSpecifications();
    }

    public void setMeasurementSpecificationTmp(MeasurementSpecification measurementSpec) {
        this.sloProvider.setMeasurementSpecification(measurementSpec);
    }

    public MeasurementSpecification getMeasurement() {
        return this.sloProvider.getMeasurementSpecification();
    }

    @Override
    public String getInfoText() {
        return SET_MSPEC_INFO_TEXT;
    }

    @Override
    public String getTitleText() {
        return SET_MSPEC_TITEL;
    }
}

