/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.fileaccess;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidProjectAccessor {
    private final Logger logger = LoggerFactory.getLogger(ValidProjectAccessor.class);

    public Optional<String> getAirdFileOfProject(IProject project) {
        try {
            IResource[] allMembers;
            IResource[] iResourceArray = allMembers = project.members();
            int n = allMembers.length;
            int n2 = 0;
            while (n2 < n) {
                IResource oneMember = iResourceArray[n2];
                if (oneMember.getFileExtension() != null && oneMember.getFileExtension().equals("aird")) {
                    return Optional.of(oneMember.getFullPath().toString());
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            this.logger.warn(e.toString());
        }
        return Optional.empty();
    }

    public List<IProject> getAllProjectAirdfiles() {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] wsProjects = wsRoot.getProjects();
        ArrayList<IProject> allAirdProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = wsProjects;
        int n = wsProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                IResource[] allMembers;
                IResource[] iResourceArray = allMembers = project.members();
                int n3 = allMembers.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource oneMember = iResourceArray[n4];
                    if (oneMember.getFileExtension() != null && oneMember.getFileExtension().equals("aird")) {
                        allAirdProjects.add(project);
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                this.logger.warn(e.toString());
            }
            ++n2;
        }
        return allAirdProjects;
    }
}

