/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizardmodel.pages;

import org.palladiosimulator.measurementsui.dataprovider.MonitorCreationProvider;
import org.palladiosimulator.measurementsui.wizardmodel.WizardModel;
import org.palladiosimulator.monitorrepository.Monitor;

public class MonitorCreationWizardModel
implements WizardModel {
    private static final String CREATE_MONITOR_INFO_TEXT = "A Monitor is used for specifying which metrics should be measured. It corresponds to a Measuring Point.\nActivated Monitors will be simulated during a SimuLizar run, not activated ones will be ignored. ";
    private static final String EDIT_MONITOR_INFO_TEXT = "A Monitor is used for specifying which metrics should be measured. It corresponds to a Measuring Point.\nActivated Monitors will be simulated during a SimuLizar run, not activated ones will be ignored. \nEdit your Monitor name and set it activated/not activated.";
    private static final String CREATE_MONITOR_TITEL = "Create Monitor";
    private static final String EDIT_MONITOR_TITEL = "Edit Monitor";
    private Monitor monitor;
    private boolean isEditing;
    private MonitorCreationProvider provider;

    public MonitorCreationWizardModel(Monitor monitor, boolean isEditing) {
        this.monitor = monitor;
        this.isEditing = isEditing;
        this.provider = new MonitorCreationProvider();
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    @Override
    public boolean canFinish() {
        return !this.monitor.getEntityName().isEmpty();
    }

    @Override
    public String getInfoText() {
        if (this.monitor.getMonitorRepository() != null) {
            return EDIT_MONITOR_INFO_TEXT;
        }
        return CREATE_MONITOR_INFO_TEXT;
    }

    @Override
    public String getTitleText() {
        if (this.monitor.getMonitorRepository() != null) {
            return EDIT_MONITOR_TITEL;
        }
        return CREATE_MONITOR_TITEL;
    }

    public void setMonitorName(String name) {
        if (!this.isEditing) {
            this.monitor.setEntityName(name);
        } else {
            this.provider.setMonitorName(this.monitor, name);
        }
    }

    public void setMonitorActivated(boolean activatedOrNot) {
        if (!this.isEditing) {
            this.monitor.setActivated(activatedOrNot);
        } else {
            this.provider.setMonitorActivatedValue(this.monitor, !activatedOrNot);
        }
    }
}

