/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.ui.measurementsdashboard.listeners;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.swt.widgets.Display;
import org.palladiosimulator.measurementsui.dataprovider.DataApplication;
import org.palladiosimulator.simulizar.ui.measurementsdashboard.parts.MeasurementsDashboardView;

public class WorkspaceListener
implements IResourceChangeListener {
    private IProject addedProject;
    private IProject deletedProject;
    private IProject changedProject;
    private MeasurementsDashboardView dashboardView;
    private DataApplication dataApplication;

    public WorkspaceListener(MeasurementsDashboardView dashboardView) {
        this.dashboardView = dashboardView;
        this.dataApplication = DataApplication.getInstance();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.deletedProject = null;
        this.addedProject = null;
        this.changedProject = null;
        IResourceDelta delta = event.getDelta();
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta deltaElement = iResourceDeltaArray[n2];
            IResource res = deltaElement.getResource();
            switch (deltaElement.getKind()) {
                case 1: {
                    if (!(res instanceof IProject)) break;
                    this.addedProject = (IProject)res;
                    break;
                }
                case 2: {
                    if (!(res instanceof IProject)) break;
                    this.deletedProject = (IProject)res;
                    break;
                }
                case 4: {
                    if (!(res instanceof IProject)) break;
                    this.changedProject = (IProject)res;
                    break;
                }
            }
            ++n2;
        }
        this.updateDashboardView();
    }

    private void updateDashboardView() {
        if (this.deletedProject != null || this.addedProject != null || this.changedProject != null) {
            Display.getDefault().asyncExec(() -> {
                if (this.deletedProject != null && this.deletedProject.equals((Object)this.dataApplication.getProject())) {
                    if (this.addedProject == null) {
                        if (!this.dataApplication.getValidProjectAccessor().getAllProjectAirdfiles().isEmpty()) {
                            this.dashboardView.updateMeasurementsDashboardView((IProject)this.dataApplication.getValidProjectAccessor().getAllProjectAirdfiles().get(0));
                        }
                        this.dashboardView.updateProjectComboBox();
                    } else {
                        this.dashboardView.updateMeasurementsDashboardView(this.addedProject);
                        this.dashboardView.updateProjectComboBox();
                        this.dashboardView.updateSLORepositoryComboBox();
                    }
                } else if (this.addedProject != null || this.deletedProject != null) {
                    if (!this.dataApplication.getValidProjectAccessor().getAllProjectAirdfiles().isEmpty()) {
                        this.dashboardView.updateMeasurementsDashboardView(this.addedProject);
                    }
                    this.dashboardView.updateProjectComboBox();
                } else if (this.changedProject != null && this.changedProject.equals((Object)this.dataApplication.getProject())) {
                    this.dashboardView.updateMeasurementsDashboardView();
                }
            });
        }
    }
}

