package monitorrepositoryview.ui.provider;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.parsley.ui.provider.ViewerLabelProvider;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.ProcessingType;

@SuppressWarnings("all")
public class MonitorrepositoryviewLabelProvider extends ViewerLabelProvider {
  @Inject
  public MonitorrepositoryviewLabelProvider(final AdapterFactoryLabelProvider delegate) {
    super(delegate);
  }

  public String text(final Monitor mon) {
    String _xifexpression = null;
    MeasuringPoint _measuringPoint = mon.getMeasuringPoint();
    boolean _tripleNotEquals = (_measuringPoint != null);
    if (_tripleNotEquals) {
      String _entityName = mon.getEntityName();
      String _plus = (_entityName + " [");
      String _replaceAll = mon.getMeasuringPoint().toString().replaceAll("\\[[^\\[]*\\]$", "");
      String _plus_1 = (_plus + _replaceAll);
      _xifexpression = (_plus_1 + "]");
    } else {
      String _entityName_1 = mon.getEntityName();
      _xifexpression = (_entityName_1 + " [There is no MeasuringPoint set!]");
    }
    return _xifexpression;
  }

  public String text(final MeasurementSpecification ms) {
    String _name = ms.getMetricDescription().getName();
    return ("MeasurementSpecification: " + _name);
  }

  public String text(final ProcessingType proc) {
    return proc.toString().replaceAll("\\[[^\\[]*\\]$", "");
  }

  public Object image(final Monitor mon) {
    String _xifexpression = null;
    boolean _isActivated = mon.isActivated();
    if (_isActivated) {
      _xifexpression = "ActiveIcon.png";
    } else {
      _xifexpression = "InactiveIcon.png";
    }
    return _xifexpression;
  }

  public Object image(final MeasurementSpecification ms) {
    String _xifexpression = null;
    boolean _isTriggersSelfAdaptations = ms.isTriggersSelfAdaptations();
    if (_isTriggersSelfAdaptations) {
      _xifexpression = "self_adaption.png";
    } else {
      _xifexpression = "nonself_adaption.png";
    }
    return _xifexpression;
  }

  public Object image(final MeasuringPoint it) {
    return "MeasuringPoint.png";
  }

  public Object image(final ProcessingType it) {
    return "ProcessingType.png";
  }
}
