/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.abstractviewer;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.widgets.Composite;
import org.palladiosimulator.measurementsui.abstractviewer.ComponentViewer;

public abstract class SaveableComponentViewer
extends ComponentViewer {
    private static final String SAVE_COMMAND = "org.eclipse.ui.file.save";
    private static final String SAVEALL_COMMAND = "org.eclipse.ui.file.saveAll";
    protected MDirtyable dirty;
    protected ECommandService commandService;

    protected SaveableComponentViewer(Composite parent, MDirtyable dirty, ECommandService commandService, EObject modelRepository) {
        super(parent, modelRepository);
        this.dirty = dirty;
        this.commandService = commandService;
    }

    public abstract void addSelectionListener(ESelectionService var1);

    @Override
    protected Resource updateResource(EObject model) {
        this.resource = super.updateResource(model);
        this.initResourceChangedListener(this.editingDomain);
        this.editingDomain = null;
        return this.resource;
    }

    private void initResourceChangedListener(EditingDomain editingDomain) {
        editingDomain.getCommandStack().addCommandStackListener(e -> {
            if (this.dirty != null) {
                this.dirty.setDirty(true);
                this.commandService.getCommand(SAVE_COMMAND).isEnabled();
                this.commandService.getCommand(SAVEALL_COMMAND).isEnabled();
            }
        });
    }

    public void undo() {
        this.initEditingDomain();
        CommandStack commandStack = this.editingDomain.getCommandStack();
        if (commandStack.canUndo()) {
            commandStack.undo();
        }
    }

    public void undoAll() {
        this.initEditingDomain();
        CommandStack commandStack = this.editingDomain.getCommandStack();
        while (commandStack.canUndo()) {
            commandStack.undo();
        }
    }

    public void redo() {
        this.initEditingDomain();
        CommandStack commandStack = this.editingDomain.getCommandStack();
        if (commandStack.canRedo()) {
            commandStack.redo();
        }
    }

    public void save(MDirtyable dirty) throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("SAVE_ONLY_IF_CHANGED", "FILE_BUFFER");
        this.resource.save(options);
        if (dirty != null) {
            dirty.setDirty(false);
            this.commandService.getCommand(SAVE_COMMAND).isEnabled();
            this.commandService.getCommand(SAVEALL_COMMAND).isEnabled();
        }
    }

    public void save() throws IOException {
        this.save(this.dirty);
    }

    public abstract void update(EObject var1);
}

