/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizard.handlers.editingsupport;

import com.google.common.primitives.Doubles;
import java.util.List;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.palladiosimulator.measurementsui.wizard.handlers.editingsupport.ProcessingTypeSelectionEditingSupport;
import org.palladiosimulator.measurementsui.wizardmodel.pages.ProcessingTypeSelectionWizardModel;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.ProcessingType;

public final class ProcessingTypePropertyEditingSupport
extends ProcessingTypeSelectionEditingSupport {
    private int propertyColumnIndex;

    public ProcessingTypePropertyEditingSupport(ColumnViewer columnViewer, TableViewer tableViewer, ProcessingTypeSelectionWizardModel processingTypeSelectionWizardModel, int propertyColumn) {
        super(columnViewer, tableViewer, processingTypeSelectionWizardModel);
        if (propertyColumn < 0) {
            throw new IllegalArgumentException();
        }
        this.propertyColumnIndex = propertyColumn;
        this.cellEditor = new TextCellEditor((Composite)this.getViewer().getControl()){

            protected void doSetValue(Object value) {
                super.doSetValue((Object)value.toString());
            }
        };
    }

    protected boolean canEdit(Object element) {
        MeasurementSpecification measurementSpecification = (MeasurementSpecification)element;
        ProcessingType selectedProcessingType = measurementSpecification.getProcessingType();
        String selectedProcessingTypeString = this.processingTypeSelectionWizardModel.getStringOfProcessingType(selectedProcessingType);
        List processingTypeProperties = this.processingTypeSelectionWizardModel.fieldsForThisProcessingType(selectedProcessingTypeString);
        return processingTypeProperties.size() > this.propertyColumnIndex;
    }

    protected Object getValue(Object element) {
        MeasurementSpecification measurementSpecification = (MeasurementSpecification)element;
        ProcessingType selectedProcessingType = measurementSpecification.getProcessingType();
        String selectedProcessingTypeString = this.processingTypeSelectionWizardModel.getStringOfProcessingType(selectedProcessingType);
        List processingTypeProperties = this.processingTypeSelectionWizardModel.fieldsForThisProcessingType(selectedProcessingTypeString);
        if (processingTypeProperties.size() > this.propertyColumnIndex) {
            return this.processingTypeSelectionWizardModel.getAProccesingTypeAttribute(measurementSpecification, (String)processingTypeProperties.get(this.propertyColumnIndex));
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        String valueString = (String)value;
        Double valueDouble = Doubles.tryParse((String)valueString);
        MeasurementSpecification measurementSpecification = (MeasurementSpecification)element;
        ProcessingType selectedProcessingType = measurementSpecification.getProcessingType();
        String selectedProcessingTypeString = this.processingTypeSelectionWizardModel.getStringOfProcessingType(selectedProcessingType);
        List processingTypeProperties = this.processingTypeSelectionWizardModel.fieldsForThisProcessingType(selectedProcessingTypeString);
        if (processingTypeProperties.size() > this.propertyColumnIndex && valueDouble != null) {
            this.processingTypeSelectionWizardModel.editAProcessingTypeAttribute(measurementSpecification, (String)processingTypeProperties.get(this.propertyColumnIndex), valueDouble.doubleValue());
        }
        this.tableViewer.refresh();
    }
}

