/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizard.pages;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.measure.Measure;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.ui.internal.util.BundleUtility;
import org.osgi.framework.Bundle;
import org.palladiosimulator.measurementsui.wizardmodel.pages.SloThresholdWizardModel;
import org.palladiosimulator.servicelevelobjective.HardThreshold;
import org.palladiosimulator.servicelevelobjective.LinearFuzzyThreshold;
import org.palladiosimulator.servicelevelobjective.NegativeQuadraticFuzzyThreshold;
import org.palladiosimulator.servicelevelobjective.QuadraticFuzzyThreshold;
import org.palladiosimulator.servicelevelobjective.SoftThreshold;
import org.palladiosimulator.servicelevelobjective.Threshold;

public class ServiceLevelObjectiveThresholdPage
extends WizardPage {
    private SloThresholdWizardModel pageModel;
    private Text upperThresholdLimit;
    private Text upperSoftLimit;
    private Text lowerThresholdLimit;
    private Text lowerSoftLimit;
    private Combo comboDropDownUpper;
    private Combo comboDropDownLower;
    private Chart chart;
    private Double[] input = new Double[4];
    private static final String DROPDOWN_ENTRY_NOTHRESHOLD = "None";
    private static final String DROPDOWN_ENTRY_HARDTHRESHOLD = "Hard Threshold";
    private static final String DROPDOWN_ENTRY_FUZZYTHRESHOLD = "Linear Fuzzy Threshold";
    private static final String DROPDOWN_ENTRY_QUADRATICTHRESHOLD = "Quadratic Fuzzy Threshold";
    private static final String DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD = "Negative Quadratic Fuzzy Threshold";
    private static final String ERROR_UPPER_THRESHOLD_LOWER_THAN_LOWER_THRESHOLD = "The lower threshold limit can not be higher than the upper threshold limit!";
    private static final String ERROR_UPPER_THRESHOLD_EQUAL_LOWER_THRESHOLD = "The lower threshold limit and the upper threshold limit can not be equal!";
    private static final String ERROR_LOWER_SOFT_LOWER_THAN_LOWER_HARD_THRESHOLD = "Lower soft limit can not be lower than the lower hard limit!";
    private static final String ERROR_LOWER_SOFT_AND_HARD_EQUAL = "Lower soft limit and lower hard limit can not be equal!";
    private static final String ERROR_UPPER_SOFT_HIGHER_THAN_LOWER_HARD_THRESHOLD = "Upper soft limit can not be higher than the upper hard limit!";
    private static final String ERROR_UPPER_SOFT_AND_HARD_EQUAL = "Upper soft limit and upper hard limit can not be equal!";
    private static final String ERROR_LOWER_SOFT_HIGHER_UPPER_SOFT = "Lower soft limit can not be higher than the upper soft limit!";
    private static final String ERROR_UPPER_SOFT_HIGHER_UPPER_HARD = "Upper soft limit can not be higher than the upper hard limit!";
    private static final String ERROR_LOWER_SOFT_HIGHER_UPPER_HARD = "LOWER soft limit can not be higher than the upper hard limit!";
    private static final String HELP_URL = "https://sdqweb.ipd.kit.edu/wiki/SimuLizar_Usability_Extension#User_Guide";
    private Composite contentContainer;
    private Composite graphContainer;
    private Label validInputLabelUpper;
    private Label validInputLabelLower;
    private Label lblSoftLimitLower;
    private Label lblSoftLimitUpper;
    private Label lblThresholdLimitLower;
    private Label lblThresholdLimitUpper;
    private ControlDecoration upperHardLimitDecorator;
    private ControlDecoration lowerSoftDecorator;
    private ControlDecoration lowerHardLimitDecorator;
    private ControlDecoration upperSoftDecorator;
    private int pointLimit = 100000;

    public ServiceLevelObjectiveThresholdPage(SloThresholdWizardModel model) {
        super("Page 3");
        this.pageModel = model;
        this.setPageComplete(false);
        this.setTitle(model.getTitleText());
        this.setMessage(model.getInfoText(), 1);
        this.setImage();
        this.pageModel.setFinishable(false);
    }

    public void setVisible(boolean visible) {
        if (this.gatherInput()) {
            this.drawGraph(this.input, this.chart);
            this.pageModel.setFinishable(true);
            this.chart.setVisible(true);
        } else {
            this.pageModel.setFinishable(false);
            this.chart.setVisible(false);
        }
        this.getWizard().getContainer().updateButtons();
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        Threshold lowerThreshold;
        this.contentContainer = new Composite(parent, 2048);
        this.contentContainer.setLayout((Layout)new GridLayout(1, false));
        Group upperGroup = new Group(this.contentContainer, 0);
        GridData gd_upperGroup = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_upperGroup.widthHint = 564;
        upperGroup.setLayoutData((Object)gd_upperGroup);
        upperGroup.setText("Upper Threshold:");
        upperGroup.setLayout((Layout)new GridLayout(5, false));
        this.comboDropDownUpper = new Combo((Composite)upperGroup, 8);
        this.comboDropDownUpper.add(DROPDOWN_ENTRY_HARDTHRESHOLD);
        this.comboDropDownUpper.add(DROPDOWN_ENTRY_FUZZYTHRESHOLD);
        this.comboDropDownUpper.add(DROPDOWN_ENTRY_QUADRATICTHRESHOLD);
        this.comboDropDownUpper.add(DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD);
        this.comboDropDownUpper.add(DROPDOWN_ENTRY_NOTHRESHOLD);
        this.comboDropDownUpper.select(4);
        this.lblThresholdLimitUpper = new Label((Composite)upperGroup, 0);
        this.lblThresholdLimitUpper.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblThresholdLimitUpper.setText("Threshold Limit:  ");
        this.lblThresholdLimitUpper.setVisible(false);
        this.upperThresholdLimit = new Text((Composite)upperGroup, 2048);
        this.upperThresholdLimit.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (ServiceLevelObjectiveThresholdPage.this.gatherInput()) {
                    ServiceLevelObjectiveThresholdPage.this.drawGraph(ServiceLevelObjectiveThresholdPage.this.input, ServiceLevelObjectiveThresholdPage.this.chart);
                    ServiceLevelObjectiveThresholdPage.this.pageModel.setFinishable(true);
                    ServiceLevelObjectiveThresholdPage.this.chart.setVisible(true);
                } else {
                    ServiceLevelObjectiveThresholdPage.this.pageModel.setFinishable(false);
                    ServiceLevelObjectiveThresholdPage.this.chart.setVisible(false);
                }
                ServiceLevelObjectiveThresholdPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.upperThresholdLimit.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.upperThresholdLimit.setVisible(false);
        new Label((Composite)upperGroup, 0);
        new Label((Composite)upperGroup, 0);
        new Label((Composite)upperGroup, 0);
        this.lblSoftLimitUpper = new Label((Composite)upperGroup, 0);
        this.lblSoftLimitUpper.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblSoftLimitUpper.setText("Soft Limit:  ");
        this.lblSoftLimitUpper.setVisible(false);
        this.upperSoftLimit = new Text((Composite)upperGroup, 2048);
        this.upperSoftLimit.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (ServiceLevelObjectiveThresholdPage.this.gatherInput()) {
                    ServiceLevelObjectiveThresholdPage.this.drawGraph(ServiceLevelObjectiveThresholdPage.this.input, ServiceLevelObjectiveThresholdPage.this.chart);
                    ServiceLevelObjectiveThresholdPage.this.pageModel.setFinishable(true);
                    ServiceLevelObjectiveThresholdPage.this.chart.setVisible(true);
                } else {
                    ServiceLevelObjectiveThresholdPage.this.pageModel.setFinishable(false);
                    ServiceLevelObjectiveThresholdPage.this.chart.setVisible(false);
                }
                ServiceLevelObjectiveThresholdPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.upperSoftLimit.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.upperSoftLimit.setVisible(false);
        new Label((Composite)upperGroup, 0);
        new Label((Composite)upperGroup, 0);
        this.validInputLabelUpper = new Label(this.contentContainer, 64);
        this.validInputLabelUpper.setForeground(new Color((Device)upperGroup.getDisplay(), 255, 0, 0));
        this.validInputLabelUpper.setText("                                                                                                                                                                                                                                                                                                                       ");
        this.comboDropDownUpper.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServiceLevelObjectiveThresholdPage.this.comboDropDownUpper.getText().equals(ServiceLevelObjectiveThresholdPage.DROPDOWN_ENTRY_NOTHRESHOLD)) {
                    ServiceLevelObjectiveThresholdPage.this.upperThresholdLimit.setEnabled(false);
                    ServiceLevelObjectiveThresholdPage.this.upperThresholdLimit.setVisible(false);
                    ServiceLevelObjectiveThresholdPage.this.upperSoftLimit.setEnabled(false);
                    ServiceLevelObjectiveThresholdPage.this.upperSoftLimit.setVisible(false);
                    ServiceLevelObjectiveThresholdPage.this.lblThresholdLimitUpper.setVisible(false);
                    ServiceLevelObjectiveThresholdPage.this.lblSoftLimitUpper.setVisible(false);
                    ServiceLevelObjectiveThresholdPage.this.upperSoftLimit.setText("");
                    ServiceLevelObjectiveThresholdPage.this.upperThresholdLimit.setText("");
                } else if (ServiceLevelObjectiveThresholdPage.this.comboDropDownUpper.getText().equals(ServiceLevelObjectiveThresholdPage.DROPDOWN_ENTRY_HARDTHRESHOLD)) {
                    ServiceLevelObjectiveThresholdPage.this.upperThresholdLimit.setEnabled(true);
                    ServiceLevelObjectiveThresholdPage.this.upperThresholdLimit.setVisible(true);
                    ServiceLevelObjectiveThresholdPage.this.upperSoftLimit.setEnabled(false);
                    ServiceLevelObjectiveThresholdPage.this.upperSoftLimit.setVisible(false);
                    ServiceLevelObjectiveThresholdPage.this.lblThresholdLimitUpper.setVisible(true);
                    ServiceLevelObjectiveThresholdPage.this.lblSoftLimitUpper.setVisible(false);
                } else if (ServiceLevelObjectiveThresholdPage.this.comboDropDownUpper.getText().equals(ServiceLevelObjectiveThresholdPage.DROPDOWN_ENTRY_FUZZYTHRESHOLD) || ServiceLevelObjectiveThresholdPage.this.comboDropDownUpper.getText().equals(ServiceLevelObjectiveThresholdPage.DROPDOWN_ENTRY_QUADRATICTHRESHOLD) || ServiceLevelObjectiveThresholdPage.this.comboDropDownUpper.getText().equals(ServiceLevelObjectiveThresholdPage.DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD)) {
                    ServiceLevelObjectiveThresholdPage.this.upperThresholdLimit.setEnabled(true);
                    ServiceLevelObjectiveThresholdPage.this.upperThresholdLimit.setVisible(true);
                    ServiceLevelObjectiveThresholdPage.this.upperSoftLimit.setEnabled(true);
                    ServiceLevelObjectiveThresholdPage.this.upperSoftLimit.setVisible(true);
                    ServiceLevelObjectiveThresholdPage.this.lblThresholdLimitUpper.setVisible(true);
                    ServiceLevelObjectiveThresholdPage.this.lblSoftLimitUpper.setVisible(true);
                }
                if (ServiceLevelObjectiveThresholdPage.this.gatherInput()) {
                    ServiceLevelObjectiveThresholdPage.this.drawGraph(ServiceLevelObjectiveThresholdPage.this.input, ServiceLevelObjectiveThresholdPage.this.chart);
                    ServiceLevelObjectiveThresholdPage.this.pageModel.setFinishable(true);
                    ServiceLevelObjectiveThresholdPage.this.chart.setVisible(true);
                } else {
                    ServiceLevelObjectiveThresholdPage.this.pageModel.setFinishable(false);
                    ServiceLevelObjectiveThresholdPage.this.chart.setVisible(false);
                }
                if (ServiceLevelObjectiveThresholdPage.this.comboDropDownLower.getText().equals(ServiceLevelObjectiveThresholdPage.DROPDOWN_ENTRY_NOTHRESHOLD) && ServiceLevelObjectiveThresholdPage.this.comboDropDownUpper.getText().equals(ServiceLevelObjectiveThresholdPage.DROPDOWN_ENTRY_NOTHRESHOLD)) {
                    ServiceLevelObjectiveThresholdPage.this.chart.setVisible(false);
                }
                ServiceLevelObjectiveThresholdPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Group lowerGroup = new Group(this.contentContainer, 0);
        GridData gd_lowerGroup = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lowerGroup.widthHint = 564;
        lowerGroup.setLayoutData((Object)gd_lowerGroup);
        lowerGroup.setText("Lower Threshold:");
        lowerGroup.setLayout((Layout)new GridLayout(5, false));
        this.comboDropDownLower = new Combo((Composite)lowerGroup, 8);
        this.comboDropDownLower.add(DROPDOWN_ENTRY_HARDTHRESHOLD);
        this.comboDropDownLower.add(DROPDOWN_ENTRY_FUZZYTHRESHOLD);
        this.comboDropDownLower.add(DROPDOWN_ENTRY_QUADRATICTHRESHOLD);
        this.comboDropDownLower.add(DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD);
        this.comboDropDownLower.add(DROPDOWN_ENTRY_NOTHRESHOLD);
        this.comboDropDownLower.select(4);
        this.lblThresholdLimitLower = new Label((Composite)lowerGroup, 0);
        this.lblThresholdLimitLower.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblThresholdLimitLower.setText("Threshold Limit:  ");
        this.lblThresholdLimitLower.setVisible(false);
        this.lowerThresholdLimit = new Text((Composite)lowerGroup, 2048);
        this.lowerThresholdLimit.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (ServiceLevelObjectiveThresholdPage.this.gatherInput()) {
                    ServiceLevelObjectiveThresholdPage.this.drawGraph(ServiceLevelObjectiveThresholdPage.this.input, ServiceLevelObjectiveThresholdPage.this.chart);
                    ServiceLevelObjectiveThresholdPage.this.pageModel.setFinishable(true);
                    ServiceLevelObjectiveThresholdPage.this.chart.setVisible(true);
                } else {
                    ServiceLevelObjectiveThresholdPage.this.pageModel.setFinishable(false);
                    ServiceLevelObjectiveThresholdPage.this.chart.setVisible(false);
                }
                ServiceLevelObjectiveThresholdPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.lowerThresholdLimit.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lowerThresholdLimit.setVisible(false);
        new Label((Composite)lowerGroup, 0);
        new Label((Composite)lowerGroup, 0);
        new Label((Composite)lowerGroup, 0);
        this.lblSoftLimitLower = new Label((Composite)lowerGroup, 0);
        this.lblSoftLimitLower.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblSoftLimitLower.setText("Soft Limit:  ");
        this.lblSoftLimitLower.setVisible(false);
        this.lowerSoftLimit = new Text((Composite)lowerGroup, 2048);
        this.lowerSoftLimit.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (ServiceLevelObjectiveThresholdPage.this.gatherInput()) {
                    ServiceLevelObjectiveThresholdPage.this.drawGraph(ServiceLevelObjectiveThresholdPage.this.input, ServiceLevelObjectiveThresholdPage.this.chart);
                    ServiceLevelObjectiveThresholdPage.this.pageModel.setFinishable(true);
                    ServiceLevelObjectiveThresholdPage.this.chart.setVisible(true);
                } else {
                    ServiceLevelObjectiveThresholdPage.this.pageModel.setFinishable(false);
                    ServiceLevelObjectiveThresholdPage.this.chart.setVisible(false);
                }
                ServiceLevelObjectiveThresholdPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.lowerSoftLimit.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lowerSoftLimit.setVisible(false);
        this.comboDropDownLower.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServiceLevelObjectiveThresholdPage.this.comboDropDownLower.getText().equals(ServiceLevelObjectiveThresholdPage.DROPDOWN_ENTRY_NOTHRESHOLD)) {
                    ServiceLevelObjectiveThresholdPage.this.lowerThresholdLimit.setEnabled(false);
                    ServiceLevelObjectiveThresholdPage.this.lowerThresholdLimit.setVisible(false);
                    ServiceLevelObjectiveThresholdPage.this.lowerSoftLimit.setEnabled(false);
                    ServiceLevelObjectiveThresholdPage.this.lowerSoftLimit.setVisible(false);
                    ServiceLevelObjectiveThresholdPage.this.lblThresholdLimitLower.setVisible(false);
                    ServiceLevelObjectiveThresholdPage.this.lblSoftLimitLower.setVisible(false);
                    ServiceLevelObjectiveThresholdPage.this.lowerSoftLimit.setText("");
                    ServiceLevelObjectiveThresholdPage.this.lowerThresholdLimit.setText("");
                } else if (ServiceLevelObjectiveThresholdPage.this.comboDropDownLower.getText().equals(ServiceLevelObjectiveThresholdPage.DROPDOWN_ENTRY_HARDTHRESHOLD)) {
                    ServiceLevelObjectiveThresholdPage.this.lowerThresholdLimit.setEnabled(true);
                    ServiceLevelObjectiveThresholdPage.this.lowerThresholdLimit.setVisible(true);
                    ServiceLevelObjectiveThresholdPage.this.lowerSoftLimit.setEnabled(false);
                    ServiceLevelObjectiveThresholdPage.this.lowerSoftLimit.setVisible(false);
                    ServiceLevelObjectiveThresholdPage.this.lblThresholdLimitLower.setVisible(true);
                    ServiceLevelObjectiveThresholdPage.this.lblSoftLimitLower.setVisible(false);
                } else if (ServiceLevelObjectiveThresholdPage.this.comboDropDownLower.getText().equals(ServiceLevelObjectiveThresholdPage.DROPDOWN_ENTRY_FUZZYTHRESHOLD) || ServiceLevelObjectiveThresholdPage.this.comboDropDownLower.getText().equals(ServiceLevelObjectiveThresholdPage.DROPDOWN_ENTRY_QUADRATICTHRESHOLD) || ServiceLevelObjectiveThresholdPage.this.comboDropDownLower.getText().equals(ServiceLevelObjectiveThresholdPage.DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD)) {
                    ServiceLevelObjectiveThresholdPage.this.lowerThresholdLimit.setEnabled(true);
                    ServiceLevelObjectiveThresholdPage.this.lowerThresholdLimit.setVisible(true);
                    ServiceLevelObjectiveThresholdPage.this.lowerSoftLimit.setEnabled(true);
                    ServiceLevelObjectiveThresholdPage.this.lowerSoftLimit.setVisible(true);
                    ServiceLevelObjectiveThresholdPage.this.lblThresholdLimitLower.setVisible(true);
                    ServiceLevelObjectiveThresholdPage.this.lblSoftLimitLower.setVisible(true);
                }
                if (ServiceLevelObjectiveThresholdPage.this.gatherInput()) {
                    ServiceLevelObjectiveThresholdPage.this.drawGraph(ServiceLevelObjectiveThresholdPage.this.input, ServiceLevelObjectiveThresholdPage.this.chart);
                    ServiceLevelObjectiveThresholdPage.this.pageModel.setFinishable(true);
                    ServiceLevelObjectiveThresholdPage.this.chart.setVisible(true);
                } else {
                    ServiceLevelObjectiveThresholdPage.this.pageModel.setFinishable(false);
                    ServiceLevelObjectiveThresholdPage.this.chart.setVisible(false);
                }
                if (ServiceLevelObjectiveThresholdPage.this.comboDropDownLower.getText().equals(ServiceLevelObjectiveThresholdPage.DROPDOWN_ENTRY_NOTHRESHOLD) && ServiceLevelObjectiveThresholdPage.this.comboDropDownUpper.getText().equals(ServiceLevelObjectiveThresholdPage.DROPDOWN_ENTRY_NOTHRESHOLD)) {
                    ServiceLevelObjectiveThresholdPage.this.chart.setVisible(false);
                }
                ServiceLevelObjectiveThresholdPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Threshold upperThreshold = this.pageModel.getSlo().getUpperThreshold();
        if (upperThreshold != null) {
            if (upperThreshold instanceof HardThreshold) {
                Measure upperHardThresholdMeasure = ((HardThreshold)upperThreshold).getThresholdLimit();
                this.upperThresholdLimit.setText(String.valueOf(upperHardThresholdMeasure.getValue().toString()) + " " + upperHardThresholdMeasure.getUnit().toString());
                this.upperThresholdLimit.setEnabled(true);
                this.upperThresholdLimit.setVisible(true);
                this.lblThresholdLimitUpper.setVisible(true);
                this.comboDropDownUpper.select(0);
            } else if (upperThreshold instanceof SoftThreshold) {
                Measure upperThresholdMeasure = upperThreshold.getThresholdLimit();
                this.upperThresholdLimit.setText(String.valueOf(upperThresholdMeasure.getValue().toString()) + " " + upperThresholdMeasure.getUnit().toString());
                this.upperThresholdLimit.setEnabled(true);
                this.upperThresholdLimit.setVisible(true);
                this.lblThresholdLimitUpper.setVisible(true);
                Measure upperSoftThresholdMeasure = ((SoftThreshold)upperThreshold).getSoftLimit();
                this.upperSoftLimit.setText(String.valueOf(upperSoftThresholdMeasure.getValue().toString()) + " " + upperSoftThresholdMeasure.getUnit().toString());
                this.lblSoftLimitUpper.setVisible(true);
                this.upperSoftLimit.setVisible(true);
                this.upperSoftLimit.setEnabled(true);
                if (upperThreshold instanceof LinearFuzzyThreshold) {
                    this.comboDropDownUpper.select(1);
                } else if (upperThreshold instanceof QuadraticFuzzyThreshold) {
                    this.comboDropDownUpper.select(2);
                } else if (upperThreshold instanceof NegativeQuadraticFuzzyThreshold) {
                    this.comboDropDownUpper.select(3);
                }
            }
        }
        if ((lowerThreshold = this.pageModel.getSlo().getLowerThreshold()) != null) {
            if (lowerThreshold instanceof HardThreshold) {
                Measure lowerHardThresholdMeasure = ((HardThreshold)lowerThreshold).getThresholdLimit();
                this.lowerThresholdLimit.setText(String.valueOf(lowerHardThresholdMeasure.getValue().toString()) + " " + lowerHardThresholdMeasure.getUnit().toString());
                this.lowerThresholdLimit.setEnabled(true);
                this.lowerThresholdLimit.setVisible(true);
                this.lblThresholdLimitLower.setVisible(true);
                this.comboDropDownLower.select(0);
            } else if (lowerThreshold instanceof SoftThreshold) {
                Measure lowerThresholdMeasure = lowerThreshold.getThresholdLimit();
                this.lowerThresholdLimit.setText(String.valueOf(lowerThresholdMeasure.getValue().toString()) + " " + lowerThresholdMeasure.getUnit().toString());
                this.lowerThresholdLimit.setEnabled(true);
                this.lowerThresholdLimit.setVisible(true);
                this.lblThresholdLimitLower.setVisible(true);
                Measure lowerSoftThresholdMeasure = ((SoftThreshold)lowerThreshold).getSoftLimit();
                this.lowerSoftLimit.setText(String.valueOf(lowerSoftThresholdMeasure.getValue().toString()) + " " + lowerSoftThresholdMeasure.getUnit().toString());
                this.lblSoftLimitLower.setVisible(true);
                this.lowerSoftLimit.setVisible(true);
                this.lowerSoftLimit.setEnabled(true);
                if (lowerThreshold instanceof LinearFuzzyThreshold) {
                    this.comboDropDownLower.select(1);
                } else if (lowerThreshold instanceof QuadraticFuzzyThreshold) {
                    this.comboDropDownLower.select(2);
                } else if (lowerThreshold instanceof NegativeQuadraticFuzzyThreshold) {
                    this.comboDropDownLower.select(3);
                }
            }
        }
        new Label((Composite)lowerGroup, 0);
        new Label((Composite)lowerGroup, 0);
        this.validInputLabelLower = new Label(this.contentContainer, 16384);
        this.validInputLabelLower.setForeground(new Color((Device)lowerGroup.getDisplay(), 255, 0, 0));
        this.validInputLabelLower.setText("                                                                                                                                                                                                                                                                                                                       ");
        this.graphContainer = new Composite(this.contentContainer, 0);
        this.graphContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.graphContainer.setLayout((Layout)new FillLayout(256));
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.upperSoftDecorator = new ControlDecoration((Control)this.upperSoftLimit, 0x1000000);
        this.upperSoftDecorator.setImage(image);
        this.upperSoftDecorator.setMarginWidth(1);
        this.upperHardLimitDecorator = new ControlDecoration((Control)this.upperThresholdLimit, 0x1000000);
        this.upperHardLimitDecorator.setImage(image);
        this.upperHardLimitDecorator.setMarginWidth(1);
        this.lowerSoftDecorator = new ControlDecoration((Control)this.lowerSoftLimit, 0x1000000);
        this.lowerSoftDecorator.setImage(image);
        this.lowerSoftDecorator.setMarginWidth(1);
        this.lowerHardLimitDecorator = new ControlDecoration((Control)this.lowerThresholdLimit, 0x1000000);
        this.lowerHardLimitDecorator.setImage(image);
        this.lowerHardLimitDecorator.setMarginWidth(1);
        this.initGraph();
        if (this.pageModel.getSlo().getMeasurementSpecification() != null) {
            if (this.gatherInput()) {
                this.drawGraph(this.input, this.chart);
                this.pageModel.setFinishable(true);
                this.chart.setVisible(true);
            } else {
                this.pageModel.setFinishable(false);
                this.chart.setVisible(false);
            }
        }
        this.setPageComplete(false);
        this.setControl((Control)this.contentContainer);
        this.getWizard().getContainer().updateButtons();
    }

    private void setUpperHardTreshold() {
        String[] data = this.upperThresholdLimit.getText().split("\\s+");
        if (data.length == 2 && !data[0].isEmpty() && !data[1].isEmpty()) {
            this.pageModel.setUpperThreshold(Float.valueOf(Float.parseFloat(data[0])), data[1]);
        } else if (data.length == 1 && !data[0].isEmpty()) {
            this.pageModel.setUpperThreshold(Float.valueOf(Float.parseFloat(data[0])), "");
        }
    }

    private void setUpperLinearFuzzyTreshold(SloThresholdWizardModel.fuzzyThresholdType type) {
        String[] limitData = this.upperThresholdLimit.getText().split("\\s+");
        String[] softData = this.upperSoftLimit.getText().split("\\s+");
        if (!(limitData.length != 2 || limitData[0].isEmpty() || limitData[1].isEmpty() || softData.length != 2 || softData[0].isEmpty() || softData[1].isEmpty())) {
            this.pageModel.setUpperThreshold(Float.valueOf(Float.parseFloat(limitData[0])), limitData[1], Float.valueOf(Float.parseFloat(softData[0])), softData[1], type);
        } else if (!(limitData.length != 1 || limitData[0].isEmpty() || softData.length != 2 || softData[0].isEmpty() || softData[1].isEmpty())) {
            this.pageModel.setUpperThreshold(Float.valueOf(Float.parseFloat(limitData[0])), "", Float.valueOf(Float.parseFloat(softData[0])), softData[1], type);
        } else if (!(limitData.length != 2 || limitData[0].isEmpty() || limitData[1].isEmpty() || softData.length != 1 || softData[0].isEmpty())) {
            this.pageModel.setUpperThreshold(Float.valueOf(Float.parseFloat(limitData[0])), limitData[1], Float.valueOf(Float.parseFloat(softData[0])), "", type);
        } else if (limitData.length == 1 && !limitData[0].isEmpty() && softData.length == 1 && !softData[0].isEmpty()) {
            this.pageModel.setUpperThreshold(Float.valueOf(Float.parseFloat(limitData[0])), "", Float.valueOf(Float.parseFloat(softData[0])), "", type);
        }
    }

    private void setLowerHardTreshold() {
        String[] data = this.lowerThresholdLimit.getText().split("\\s+");
        if (data.length == 2 && !data[0].isEmpty() && !data[1].isEmpty()) {
            this.pageModel.setLowerThreshold(Float.valueOf(Float.parseFloat(data[0])), data[1]);
        } else if (data.length == 1 && !data[0].isEmpty()) {
            this.pageModel.setLowerThreshold(Float.valueOf(Float.parseFloat(data[0])), "");
        }
    }

    private void setLowerLinearFuzzyTreshold(SloThresholdWizardModel.fuzzyThresholdType type) {
        String[] limitData = this.lowerThresholdLimit.getText().split("\\s+");
        String[] softData = this.lowerSoftLimit.getText().split("\\s+");
        if (!(limitData.length != 2 || limitData[0].isEmpty() || limitData[1].isEmpty() || softData.length != 2 || softData[0].isEmpty() || softData[1].isEmpty())) {
            this.pageModel.setLowerThreshold(Float.valueOf(Float.parseFloat(limitData[0])), limitData[1], Float.valueOf(Float.parseFloat(softData[0])), softData[1], type);
        } else if (!(limitData.length != 1 || limitData[0].isEmpty() || softData.length != 2 || softData[0].isEmpty() || softData[1].isEmpty())) {
            this.pageModel.setLowerThreshold(Float.valueOf(Float.parseFloat(limitData[0])), "", Float.valueOf(Float.parseFloat(softData[0])), softData[1], type);
        } else if (!(limitData.length != 2 || limitData[0].isEmpty() || limitData[1].isEmpty() || softData.length != 1 || softData[0].isEmpty())) {
            this.pageModel.setLowerThreshold(Float.valueOf(Float.parseFloat(limitData[0])), limitData[1], Float.valueOf(Float.parseFloat(softData[0])), "", type);
        } else if (limitData.length == 1 && !limitData[0].isEmpty() && softData.length == 1 && !softData[0].isEmpty()) {
            this.pageModel.setLowerThreshold(Float.valueOf(Float.parseFloat(limitData[0])), "", Float.valueOf(Float.parseFloat(softData[0])), "", type);
        }
    }

    public void finishTresholds() {
        try {
            if (this.comboDropDownUpper.getSelectionIndex() == 0) {
                this.setUpperHardTreshold();
            } else if (this.comboDropDownUpper.getSelectionIndex() == 1) {
                this.setUpperLinearFuzzyTreshold(SloThresholdWizardModel.fuzzyThresholdType.LINEAR);
            } else if (this.comboDropDownUpper.getSelectionIndex() == 2) {
                this.setUpperLinearFuzzyTreshold(SloThresholdWizardModel.fuzzyThresholdType.QUADRATIC);
            } else if (this.comboDropDownUpper.getSelectionIndex() == 3) {
                this.setUpperLinearFuzzyTreshold(SloThresholdWizardModel.fuzzyThresholdType.NEGATIVE_QUADRATIC);
            } else if (this.comboDropDownUpper.getSelectionIndex() == 4) {
                this.pageModel.deleteUpperThreshold();
            }
        }
        catch (Exception exception) {}
        try {
            if (this.comboDropDownLower.getSelectionIndex() == 0) {
                this.setLowerHardTreshold();
            } else if (this.comboDropDownLower.getSelectionIndex() == 1) {
                this.setLowerLinearFuzzyTreshold(SloThresholdWizardModel.fuzzyThresholdType.LINEAR);
            } else if (this.comboDropDownLower.getSelectionIndex() == 2) {
                this.setLowerLinearFuzzyTreshold(SloThresholdWizardModel.fuzzyThresholdType.QUADRATIC);
            } else if (this.comboDropDownLower.getSelectionIndex() == 3) {
                this.setLowerLinearFuzzyTreshold(SloThresholdWizardModel.fuzzyThresholdType.NEGATIVE_QUADRATIC);
            } else if (this.comboDropDownLower.getSelectionIndex() == 4) {
                this.pageModel.deleteLowerThreshold();
            }
        }
        catch (Exception exception) {}
    }

    private void drawGraph(Double[] input, Chart chart) {
        String unitString = this.pageModel.getDefaultUnit().toString();
        chart.setSize(672, 200);
        chart.getTitle().setText("Threshold Visualization");
        chart.getAxisSet().getXAxis(0).getTitle().setText(unitString);
        chart.getAxisSet().getYAxis(0).getTitle().setText("SLO Fulfillment");
        double rangeStart = 0.0;
        double rangeEnd = 0.0;
        if (input[1] == null) {
            input[1] = input[0];
        }
        if (input[2] == null) {
            input[2] = input[3];
        }
        if (input[0] != null && input[3] == null) {
            input[3] = input[2] = Double.valueOf(input[1] * 2.0);
            rangeEnd = input[1] * 1.1;
        } else if (input[3] != null) {
            rangeEnd = input[3] * 1.1;
        }
        if (input[3] != null && input[0] == null) {
            input[0] = input[1] = Double.valueOf(0.0);
        }
        if (input[0] != null && input[3] != null && input[1] != null && input[2] != null) {
            int[] digitLength = new int[]{String.valueOf(input[0]).split("\\.")[1].length(), String.valueOf(input[1]).split("\\.")[1].length(), String.valueOf(input[2]).split("\\.")[1].length(), String.valueOf(input[3]).split("\\.")[1].length()};
            Arrays.sort(digitLength);
            double step = Math.pow(0.1, digitLength[3] + 2);
            ArrayList<Double> ySeries = new ArrayList<Double>();
            ArrayList<Double> xSeries = new ArrayList<Double>();
            while ((rangeEnd - rangeStart) / step > (double)this.pointLimit) {
                step *= 10.0;
            }
            double i = rangeStart;
            while (i <= rangeEnd) {
                double toAdd = this.chartSeriesHelper(input, i);
                ySeries.add(toAdd);
                xSeries.add(i);
                i += step;
            }
            double[] yArray = ySeries.stream().mapToDouble(d -> d).toArray();
            double[] xArray = xSeries.stream().mapToDouble(d -> d).toArray();
            ISeriesSet seriesSet = chart.getSeriesSet();
            ILineSeries series = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, "Threshold");
            series.setYSeries(yArray);
            series.setXSeries(xArray);
            series.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            chart.getAxisSet().adjustRange();
            chart.setVisible(true);
        }
        chart.redraw();
    }

    public double chartSeriesHelper(Double[] input, double i) {
        double result = 0.0;
        if (input[1] <= i && i <= input[2]) {
            result = 1.0;
        }
        if (input[0] <= i && i < input[1]) {
            if (this.comboDropDownLower.getSelectionIndex() == 1) {
                result = (i - input[0]) / (input[1] - input[0]);
            } else if (this.comboDropDownLower.getSelectionIndex() == 2) {
                result = 1.0 / Math.pow(input[1] - input[0], 2.0) * Math.pow(i - input[0], 2.0);
            } else if (this.comboDropDownLower.getSelectionIndex() == 3) {
                result = 1.0 - 1.0 / Math.pow(input[1] - input[0], 2.0) * Math.pow(i - input[1], 2.0);
            } else {
                this.comboDropDownLower.getSelectionIndex();
            }
        }
        if (input[2] < i && i <= input[3]) {
            if (this.comboDropDownUpper.getSelectionIndex() == 1) {
                result = -(i - input[3]) / (input[3] - input[2]);
            } else if (this.comboDropDownUpper.getSelectionIndex() == 2) {
                result = 1.0 / Math.pow(input[3] - input[2], 2.0) * Math.pow(i - input[3], 2.0);
            } else if (this.comboDropDownUpper.getSelectionIndex() == 3) {
                result = 1.0 - 1.0 / Math.pow(input[3] - input[2], 2.0) * Math.pow(i - input[2], 2.0);
            } else {
                this.comboDropDownUpper.getSelectionIndex();
            }
        }
        return result;
    }

    private void initGraph() {
        this.chart = new Chart(this.graphContainer, 0);
        this.chart.setSize(672, 200);
        this.chart.setVisible(false);
    }

    private Measure<?, ?> getInputFromText(String text) {
        Measure measure;
        Unit unit;
        try {
            unit = Unit.valueOf((CharSequence)text.split("\\s+")[1]);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
            unit = Unit.valueOf((CharSequence)"bit");
        }
        try {
            measure = Measure.valueOf((float)Float.parseFloat(text.split("\\s+")[0]), (Unit)unit);
        }
        catch (NumberFormatException numberFormatException) {
            measure = Measure.valueOf((float)Float.parseFloat("0"), (Unit)unit);
        }
        return measure;
    }

    private boolean validateInput() {
        Unit defaultUnit = this.pageModel.getDefaultUnit();
        String mspType = this.pageModel.getSpecificationType().replace("[TRANSIENT]", "");
        this.lowerThresholdLimit.setForeground(new Color(null, 0, 0, 0));
        this.upperThresholdLimit.setForeground(new Color(null, 0, 0, 0));
        this.lowerSoftLimit.setForeground(new Color(null, 0, 0, 0));
        this.upperSoftLimit.setForeground(new Color(null, 0, 0, 0));
        this.lowerHardLimitDecorator.hide();
        this.lowerSoftDecorator.hide();
        this.upperHardLimitDecorator.hide();
        this.upperSoftDecorator.hide();
        this.setErrorMessage(null);
        boolean hasError = false;
        int errorCount = 0;
        int emptyCount = 0;
        if (this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_NOTHRESHOLD) && this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_NOTHRESHOLD)) {
            return true;
        }
        if (this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_HARDTHRESHOLD) && !defaultUnit.isCompatible(this.getInputFromText(this.lowerThresholdLimit.getText()).getUnit())) {
            hasError = true;
            if (!this.lowerThresholdLimit.getText().isEmpty()) {
                ++errorCount;
                this.lowerHardLimitDecorator.setDescriptionText("Unit is invalid for selected specification type");
                this.lowerHardLimitDecorator.show();
                if (defaultUnit.toString().equals("")) {
                    this.setErrorMessage("Lower hard threshold unit is wrong! You did choose a " + this.pageModel.getSpecificationType() + " specification type. \n The default unit is NONE. A vaild input for example would be '10' without any units");
                } else if (defaultUnit.toString().equals("s")) {
                    this.setErrorMessage("Lower hard threshold unit is wrong! You did choose a " + mspType + " specification type. \n The default unit is 's'. A vaild input for example would be '10 s' or '10 ms'");
                } else {
                    this.setErrorMessage("Lower hard threshold unit is wrong! You did choose a " + mspType + " specification type.");
                }
            } else {
                this.lowerHardLimitDecorator.setDescriptionText("Threshold can not be empty");
                this.lowerHardLimitDecorator.show();
                ++emptyCount;
                this.setErrorMessage("Lower hard threshold is empty.");
            }
        }
        if ((this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD) || this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_FUZZYTHRESHOLD) || this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_QUADRATICTHRESHOLD)) && !defaultUnit.isCompatible(this.getInputFromText(this.lowerThresholdLimit.getText()).getUnit())) {
            hasError = true;
            if (!this.lowerThresholdLimit.getText().isEmpty()) {
                ++errorCount;
                this.lowerHardLimitDecorator.setDescriptionText("Unit is invalid for selected specification type");
                this.lowerHardLimitDecorator.show();
                if (defaultUnit.toString().equals("")) {
                    this.setErrorMessage("Lower hard threshold unit is wrong! You did choose a " + this.pageModel.getSpecificationType() + " specification type. \n The default unit is NONE. A vaild input for example would be '10' without any units");
                } else if (defaultUnit.toString().equals("s")) {
                    this.setErrorMessage("Lower hard threshold unit is wrong! You did choose a " + mspType + " specification type. \n The default unit is 's'. A vaild input for example would be '10 s' or '10 ms'");
                } else {
                    this.setErrorMessage("Lower hard threshold unit is wrong! You did choose a " + mspType + " specification type.");
                }
            } else {
                this.lowerHardLimitDecorator.setDescriptionText("Threshold can not be empty");
                this.lowerHardLimitDecorator.show();
                ++emptyCount;
                this.setErrorMessage("Lower hard threshold is empty.");
            }
        }
        if ((this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD) || this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_FUZZYTHRESHOLD) || this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_QUADRATICTHRESHOLD)) && !defaultUnit.isCompatible(this.getInputFromText(this.lowerSoftLimit.getText()).getUnit())) {
            hasError = true;
            if (!this.lowerSoftLimit.getText().isEmpty()) {
                ++errorCount;
                this.lowerSoftDecorator.setDescriptionText("Unit is invalid for selected specification type");
                this.lowerSoftDecorator.show();
                if (defaultUnit.toString().equals("")) {
                    this.setErrorMessage("Lower soft threshold unit is wrong! You did choose a " + this.pageModel.getSpecificationType() + " specification type. \n The default unit is NONE. A vaild input for example would be '10' without any units");
                } else if (defaultUnit.toString().equals("s")) {
                    this.setErrorMessage("Lower soft threshold unit is wrong! You did choose a " + mspType + " specification type. \n The default unit is 's'. A vaild input for example would be '10 s' or '10 ms'");
                } else {
                    this.setErrorMessage("Lower soft threshold unit is wrong! You did choose a " + mspType + " specification type.");
                }
            } else {
                this.lowerSoftDecorator.setDescriptionText("Threshold can not be empty");
                this.lowerSoftDecorator.show();
                this.setErrorMessage("Lower soft threshold is empty.");
            }
        }
        if (this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_HARDTHRESHOLD) && !defaultUnit.isCompatible(this.getInputFromText(this.upperThresholdLimit.getText()).getUnit())) {
            hasError = true;
            if (!this.upperThresholdLimit.getText().isEmpty()) {
                ++errorCount;
                this.upperHardLimitDecorator.setDescriptionText("Unit is invalid for selected specification type");
                this.upperHardLimitDecorator.show();
                if (defaultUnit.toString().equals("")) {
                    this.setErrorMessage("Upper hard threshold unit is wrong! You did choose a " + this.pageModel.getSpecificationType() + " specification type. \n The default unit is NONE. A vaild input for example would be '10' without any units");
                } else if (defaultUnit.toString().equals("s")) {
                    this.setErrorMessage("Upper hard threshold unit is wrong! You did choose a " + mspType + " specification type. \n The default unit is 's'. A vaild input for example would be '10 s' or '10 ms'");
                } else {
                    this.setErrorMessage("Upper hard threshold unit is wrong! You did choose a " + mspType + " specification type.");
                }
            } else {
                this.upperHardLimitDecorator.setDescriptionText("Threshold can not be empty");
                this.upperHardLimitDecorator.show();
                ++emptyCount;
                this.setErrorMessage("Upper hard threshold is empty.");
            }
        }
        if ((this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD) || this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_FUZZYTHRESHOLD) || this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_QUADRATICTHRESHOLD)) && !defaultUnit.isCompatible(this.getInputFromText(this.upperThresholdLimit.getText()).getUnit())) {
            hasError = true;
            if (!this.upperThresholdLimit.getText().isEmpty()) {
                ++errorCount;
                this.upperHardLimitDecorator.setDescriptionText("Unit is invalid for selected specification type");
                this.upperHardLimitDecorator.show();
                if (defaultUnit.toString().equals("")) {
                    this.setErrorMessage("Upper hard threshold unit is wrong! You did choose a " + this.pageModel.getSpecificationType() + " specification type. \n The default unit is NONE. A vaild input for example would be '10' without any units");
                } else if (defaultUnit.toString().equals("s")) {
                    this.setErrorMessage("Upper hard threshold unit is wrong! You did choose a " + mspType + " specification type. \n The default unit is 's'. A vaild input for example would be '10 s' or '10 ms'");
                } else {
                    this.setErrorMessage("Upper hard threshold unit is wrong! You did choose a " + mspType + " specification type.");
                }
            } else {
                this.upperHardLimitDecorator.setDescriptionText("Threshold can not be empty");
                this.upperHardLimitDecorator.show();
                ++emptyCount;
                this.setErrorMessage("Upper hard threshold is empty.");
            }
        }
        if ((this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD) || this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_FUZZYTHRESHOLD) || this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_QUADRATICTHRESHOLD)) && !defaultUnit.isCompatible(this.getInputFromText(this.upperSoftLimit.getText()).getUnit())) {
            hasError = true;
            if (!this.upperSoftLimit.getText().isEmpty()) {
                ++errorCount;
                this.upperSoftDecorator.setDescriptionText("Unit is invalid for selected specification type");
                this.upperSoftDecorator.show();
                if (defaultUnit.toString().equals("")) {
                    this.setErrorMessage("Upper soft threshold unit is wrong! You did choose a " + this.pageModel.getSpecificationType() + " specification type. \n The default unit is NONE. A vaild input for example would be '10' without any units");
                } else if (defaultUnit.toString().equals("s")) {
                    this.setErrorMessage("Upper soft threshold unit is wrong! You did choose a " + mspType + " specification type. \n The default unit is 's'. A vaild input for example would be '10 s' or '10 ms'");
                } else {
                    this.setErrorMessage("Upper soft threshold unit is wrong! You did choose a " + mspType + " specification type.");
                }
            } else {
                this.upperSoftDecorator.setDescriptionText("Threshold can not be empty");
                this.upperSoftDecorator.show();
                ++emptyCount;
                this.setErrorMessage("Upper soft threshold is empty.");
            }
        }
        if (hasError) {
            if (errorCount > 1) {
                if (defaultUnit.toString().equals("")) {
                    this.setErrorMessage("Threshold units are wrong! You did choose a " + this.pageModel.getSpecificationType() + " specification type. \n The default unit is NONE. A vaild input for example would be '10' without any units");
                } else if (defaultUnit.toString().equals("s")) {
                    this.setErrorMessage("Threshold units are wrong! You did choose a " + mspType + " specification type. \n The default unit is 's'. A vaild input for example would be '10 s' or '10 ms'");
                } else {
                    this.setErrorMessage("Threshold units are wrong! You did choose a " + mspType + " specification type.");
                }
            }
            if (emptyCount > 1) {
                this.setErrorMessage("Thresholds are empty.");
            }
            return false;
        }
        if (defaultUnit.toString().equals("")) {
            boolean error_special = false;
            if (this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_HARDTHRESHOLD)) {
                if (this.upperThresholdLimit.getText().isEmpty()) {
                    this.upperHardLimitDecorator.show();
                    this.upperHardLimitDecorator.setDescriptionText("Threshold can not be empty");
                    error_special = true;
                } else if (!this.upperThresholdLimit.getText().matches("[0-9]+")) {
                    error_special = true;
                    this.upperHardLimitDecorator.show();
                    this.upperHardLimitDecorator.setDescriptionText("Threshold contains wrong characters");
                    this.setErrorMessage("Threshold units are wrong! You did choose a " + this.pageModel.getSpecificationType() + " specification type. \n The default unit is NONE. A vaild input for example would be '10' without any units");
                }
            } else if (this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD) || this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_FUZZYTHRESHOLD) || this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_QUADRATICTHRESHOLD)) {
                if (this.upperThresholdLimit.getText().isEmpty()) {
                    this.upperHardLimitDecorator.show();
                    this.upperHardLimitDecorator.setDescriptionText("Threshold can not be empty");
                    error_special = true;
                } else if (!this.upperThresholdLimit.getText().matches("[0-9]+")) {
                    error_special = true;
                    this.upperHardLimitDecorator.show();
                    this.upperHardLimitDecorator.setDescriptionText("Threshold contains wrong characters");
                    this.setErrorMessage("Threshold units are wrong! You did choose a " + this.pageModel.getSpecificationType() + " specification type. \n The default unit is NONE. A vaild input for example would be '10' without any units");
                }
                if (this.upperSoftLimit.getText().isEmpty()) {
                    this.upperSoftDecorator.show();
                    this.upperSoftDecorator.setDescriptionText("Threshold can not be empty");
                    error_special = true;
                } else if (!this.upperSoftLimit.getText().matches("[0-9]+")) {
                    error_special = true;
                    this.upperSoftDecorator.show();
                    this.upperSoftDecorator.setDescriptionText("Threshold contains wrong characters");
                    this.setErrorMessage("Threshold units are wrong! You did choose a " + this.pageModel.getSpecificationType() + " specification type. \n The default unit is NONE. A vaild input for example would be '10' without any units");
                }
            }
            if (this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_HARDTHRESHOLD)) {
                if (this.lowerThresholdLimit.getText().isEmpty()) {
                    this.lowerHardLimitDecorator.show();
                    this.lowerHardLimitDecorator.setDescriptionText("Threshold can not be empty");
                    error_special = true;
                } else if (!this.lowerThresholdLimit.getText().matches("[0-9]+")) {
                    error_special = true;
                    this.lowerHardLimitDecorator.show();
                    this.lowerHardLimitDecorator.setDescriptionText("Threshold contains wrong characters");
                    this.setErrorMessage("Threshold units are wrong! You did choose a " + this.pageModel.getSpecificationType() + " specification type. \n The default unit is NONE. A vaild input for example would be '10' without any units");
                }
            } else if (this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD) || this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_FUZZYTHRESHOLD) || this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_QUADRATICTHRESHOLD)) {
                if (this.lowerThresholdLimit.getText().isEmpty()) {
                    this.lowerHardLimitDecorator.show();
                    this.lowerHardLimitDecorator.setDescriptionText("Threshold can not be empty");
                    error_special = true;
                } else if (!this.lowerThresholdLimit.getText().matches("[0-9]+")) {
                    error_special = true;
                    this.lowerHardLimitDecorator.show();
                    this.lowerHardLimitDecorator.setDescriptionText("Threshold contains wrong characters");
                    this.setErrorMessage("Threshold units are wrong! You did choose a " + this.pageModel.getSpecificationType() + " specification type. \n The default unit is NONE. A vaild input for example would be '10' without any units");
                }
                if (this.lowerSoftLimit.getText().isEmpty()) {
                    this.lowerSoftDecorator.show();
                    this.lowerSoftDecorator.setDescriptionText("Threshold can not be empty");
                    error_special = true;
                } else if (!this.lowerSoftLimit.getText().matches("[0-9]+")) {
                    error_special = true;
                    this.lowerSoftDecorator.show();
                    this.lowerSoftDecorator.setDescriptionText("Threshold contains wrong characters");
                    this.setErrorMessage("Threshold units are wrong! You did choose a " + this.pageModel.getSpecificationType() + " specification type. \n The default unit is NONE. A vaild input for example would be '10' without any units.");
                }
            }
            if (error_special) {
                return false;
            }
        }
        boolean numberMissing = false;
        if (!defaultUnit.toString().equals("")) {
            if (this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_HARDTHRESHOLD)) {
                if (!this.upperThresholdLimit.getText().matches("\\d+([\\.]*\\d+)?\\s\\w+")) {
                    this.setErrorMessage("Threshold empty.");
                    numberMissing = true;
                    this.upperHardLimitDecorator.show();
                }
            } else if (this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD) || this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_FUZZYTHRESHOLD) || this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_QUADRATICTHRESHOLD)) {
                if (!this.upperThresholdLimit.getText().matches("\\d+([\\.]*\\d+)?\\s\\w+")) {
                    this.setErrorMessage("Threshold empty.");
                    numberMissing = true;
                    this.upperHardLimitDecorator.show();
                }
                if (!this.upperSoftLimit.getText().matches("\\d+([\\.]*\\d+)?\\s\\w+")) {
                    this.setErrorMessage("Threshold empty.");
                    numberMissing = true;
                    this.upperSoftDecorator.show();
                }
            }
            if (this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_HARDTHRESHOLD)) {
                if (!this.lowerThresholdLimit.getText().matches("\\d+([\\.]*\\d+)?\\s\\w+")) {
                    this.setErrorMessage("Threshold empty.");
                    numberMissing = true;
                    this.lowerHardLimitDecorator.show();
                }
            } else if (this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD) || this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_FUZZYTHRESHOLD) || this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_QUADRATICTHRESHOLD)) {
                if (!this.lowerThresholdLimit.getText().matches("\\d+([\\.]*\\d+)?\\s\\w+")) {
                    this.setErrorMessage("Threshold empty.");
                    numberMissing = true;
                    this.lowerHardLimitDecorator.show();
                }
                if (!this.lowerSoftLimit.getText().matches("\\d+([\\.]*\\d+)?\\s\\w+")) {
                    this.setErrorMessage("Threshold empty.");
                    numberMissing = true;
                    this.lowerSoftDecorator.show();
                }
            }
            if (numberMissing) {
                return false;
            }
        }
        return true;
    }

    private boolean gatherInput() {
        this.input[3] = null;
        this.input[2] = null;
        this.input[1] = null;
        this.input[0] = null;
        if (this.validateInput()) {
            double upperThreshold;
            double lowerSoftThreshold;
            double upperSoftThreshold;
            double lowerSoftThreshold2;
            double upperSoftThreshold2;
            double lowerThresholdHard;
            Unit defaultUnit = this.pageModel.getDefaultUnit();
            try {
                UnitConverter softConverter;
                UnitConverter hardConverter;
                if (this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_NOTHRESHOLD)) {
                    this.input[0] = null;
                    this.input[1] = null;
                } else if (this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_HARDTHRESHOLD)) {
                    hardConverter = this.getInputFromText(this.lowerThresholdLimit.getText()).getUnit().getConverterTo(defaultUnit);
                    this.input[0] = hardConverter.convert(Double.parseDouble(this.getInputFromText(this.lowerThresholdLimit.getText()).getValue().toString()));
                    this.input[1] = null;
                } else if (this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_FUZZYTHRESHOLD) || this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_QUADRATICTHRESHOLD) || this.comboDropDownLower.getText().equals(DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD)) {
                    hardConverter = this.getInputFromText(this.lowerThresholdLimit.getText()).getUnit().getConverterTo(defaultUnit);
                    softConverter = this.getInputFromText(this.lowerSoftLimit.getText()).getUnit().getConverterTo(defaultUnit);
                    this.input[0] = hardConverter.convert(Double.parseDouble(this.getInputFromText(this.lowerThresholdLimit.getText()).getValue().toString()));
                    this.input[1] = softConverter.convert(Double.parseDouble(this.getInputFromText(this.lowerSoftLimit.getText()).getValue().toString()));
                }
                if (this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_NOTHRESHOLD)) {
                    this.input[3] = null;
                    this.input[2] = null;
                } else if (this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_HARDTHRESHOLD)) {
                    hardConverter = this.getInputFromText(this.upperThresholdLimit.getText()).getUnit().getConverterTo(defaultUnit);
                    this.input[3] = hardConverter.convert(Double.parseDouble(this.getInputFromText(this.upperThresholdLimit.getText()).getValue().toString()));
                    this.input[2] = null;
                } else if (this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_FUZZYTHRESHOLD) || this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_QUADRATICTHRESHOLD) || this.comboDropDownUpper.getText().equals(DROPDOWN_ENTRY_NEGATIVQUADRATICTHRESHOLD)) {
                    hardConverter = this.getInputFromText(this.upperThresholdLimit.getText()).getUnit().getConverterTo(defaultUnit);
                    softConverter = this.getInputFromText(this.upperSoftLimit.getText()).getUnit().getConverterTo(defaultUnit);
                    this.input[3] = hardConverter.convert(Double.parseDouble(this.getInputFromText(this.upperThresholdLimit.getText()).getValue().toString()));
                    this.input[2] = softConverter.convert(Double.parseDouble(this.getInputFromText(this.upperSoftLimit.getText()).getValue().toString()));
                }
            }
            catch (ConversionException conversionException) {
                System.out.println("conversion error");
                return false;
            }
            this.lowerHardLimitDecorator.hide();
            this.lowerSoftDecorator.hide();
            this.upperHardLimitDecorator.hide();
            this.upperSoftDecorator.hide();
            this.lowerThresholdLimit.setForeground(new Color(null, 0, 0, 0));
            this.upperThresholdLimit.setForeground(new Color(null, 0, 0, 0));
            this.lowerSoftLimit.setForeground(new Color(null, 0, 0, 0));
            this.upperSoftLimit.setForeground(new Color(null, 0, 0, 0));
            this.setErrorMessage(null);
            if (this.input[0] != null && this.input[3] != null) {
                double upperThresholdHard = this.input[3];
                lowerThresholdHard = this.input[0];
                if (lowerThresholdHard > upperThresholdHard) {
                    this.lowerThresholdLimit.setForeground(new Color(null, 255, 0, 0));
                    this.upperThresholdLimit.setForeground(new Color(null, 255, 0, 0));
                    this.lowerHardLimitDecorator.setDescriptionText(ERROR_UPPER_THRESHOLD_LOWER_THAN_LOWER_THRESHOLD);
                    this.lowerHardLimitDecorator.show();
                    this.upperHardLimitDecorator.setDescriptionText(ERROR_UPPER_THRESHOLD_LOWER_THAN_LOWER_THRESHOLD);
                    this.upperHardLimitDecorator.show();
                    this.setErrorMessage(ERROR_UPPER_THRESHOLD_LOWER_THAN_LOWER_THRESHOLD);
                    return false;
                }
                if (lowerThresholdHard == upperThresholdHard) {
                    this.lowerThresholdLimit.setForeground(new Color(null, 255, 0, 0));
                    this.upperThresholdLimit.setForeground(new Color(null, 255, 0, 0));
                    this.lowerHardLimitDecorator.setDescriptionText(ERROR_UPPER_THRESHOLD_EQUAL_LOWER_THRESHOLD);
                    this.lowerHardLimitDecorator.show();
                    this.upperHardLimitDecorator.setDescriptionText(ERROR_UPPER_THRESHOLD_EQUAL_LOWER_THRESHOLD);
                    this.upperHardLimitDecorator.show();
                    this.setErrorMessage(ERROR_UPPER_THRESHOLD_EQUAL_LOWER_THRESHOLD);
                    return false;
                }
            }
            if (this.input[1] != null && this.input[0] != null) {
                double lowerSoftThreshold3 = this.input[1];
                if (lowerSoftThreshold3 < (lowerThresholdHard = this.input[0].doubleValue())) {
                    this.lowerSoftLimit.setForeground(new Color(null, 255, 0, 0));
                    this.lowerThresholdLimit.setForeground(new Color(null, 255, 0, 0));
                    this.lowerSoftDecorator.setDescriptionText(ERROR_LOWER_SOFT_LOWER_THAN_LOWER_HARD_THRESHOLD);
                    this.lowerSoftDecorator.show();
                    this.lowerHardLimitDecorator.setDescriptionText(ERROR_LOWER_SOFT_LOWER_THAN_LOWER_HARD_THRESHOLD);
                    this.lowerHardLimitDecorator.show();
                    this.setErrorMessage(ERROR_LOWER_SOFT_LOWER_THAN_LOWER_HARD_THRESHOLD);
                    return false;
                }
                if (lowerSoftThreshold3 == lowerThresholdHard) {
                    this.lowerSoftLimit.setForeground(new Color(null, 255, 0, 0));
                    this.lowerThresholdLimit.setForeground(new Color(null, 255, 0, 0));
                    this.lowerSoftDecorator.setDescriptionText(ERROR_LOWER_SOFT_AND_HARD_EQUAL);
                    this.lowerSoftDecorator.show();
                    this.lowerHardLimitDecorator.setDescriptionText(ERROR_LOWER_SOFT_AND_HARD_EQUAL);
                    this.lowerHardLimitDecorator.show();
                    this.setErrorMessage(ERROR_LOWER_SOFT_AND_HARD_EQUAL);
                    return false;
                }
            }
            if (this.input[3] != null && this.input[2] != null) {
                double upperThresholdHard;
                double upperSoftThreshold3 = this.input[2];
                if (upperSoftThreshold3 > (upperThresholdHard = this.input[3].doubleValue())) {
                    this.upperSoftLimit.setForeground(new Color(null, 255, 0, 0));
                    this.upperThresholdLimit.setForeground(new Color(null, 255, 0, 0));
                    this.upperSoftDecorator.setDescriptionText("Upper soft limit can not be higher than the upper hard limit!");
                    this.upperSoftDecorator.show();
                    this.upperHardLimitDecorator.setDescriptionText("Upper soft limit can not be higher than the upper hard limit!");
                    this.upperHardLimitDecorator.show();
                    this.setErrorMessage("Upper soft limit can not be higher than the upper hard limit!");
                    return false;
                }
                if (upperSoftThreshold3 == upperThresholdHard) {
                    this.upperSoftLimit.setForeground(new Color(null, 255, 0, 0));
                    this.upperThresholdLimit.setForeground(new Color(null, 255, 0, 0));
                    this.upperSoftDecorator.setDescriptionText(ERROR_UPPER_SOFT_AND_HARD_EQUAL);
                    this.upperSoftDecorator.show();
                    this.upperHardLimitDecorator.setDescriptionText(ERROR_UPPER_SOFT_AND_HARD_EQUAL);
                    this.upperHardLimitDecorator.show();
                    this.setErrorMessage(ERROR_UPPER_SOFT_AND_HARD_EQUAL);
                    return false;
                }
            }
            if (this.input[0] != null && this.input[2] != null && (upperSoftThreshold2 = this.input[2].doubleValue()) < (lowerThresholdHard = this.input[0].doubleValue())) {
                this.upperSoftLimit.setForeground(new Color(null, 255, 0, 0));
                this.lowerThresholdLimit.setForeground(new Color(null, 255, 0, 0));
                this.upperSoftDecorator.setDescriptionText("Upper soft limit can not be higher than the upper hard limit!");
                this.upperSoftDecorator.show();
                this.lowerHardLimitDecorator.setDescriptionText("Upper soft limit can not be higher than the upper hard limit!");
                this.lowerHardLimitDecorator.show();
                this.setErrorMessage("Upper soft limit can not be higher than the upper hard limit!");
                return false;
            }
            if (this.input[1] != null && this.input[2] != null && (lowerSoftThreshold2 = this.input[1].doubleValue()) > (upperSoftThreshold = this.input[2].doubleValue())) {
                this.lowerSoftLimit.setForeground(new Color(null, 255, 0, 0));
                this.upperSoftLimit.setForeground(new Color(null, 255, 0, 0));
                this.lowerSoftDecorator.setDescriptionText(ERROR_LOWER_SOFT_HIGHER_UPPER_SOFT);
                this.upperSoftDecorator.setDescriptionText(ERROR_LOWER_SOFT_HIGHER_UPPER_SOFT);
                this.lowerSoftDecorator.show();
                this.upperSoftDecorator.show();
                this.setErrorMessage(ERROR_LOWER_SOFT_HIGHER_UPPER_SOFT);
                return false;
            }
            if (this.input[1] != null && this.input[3] != null && (lowerSoftThreshold = this.input[1].doubleValue()) > (upperThreshold = this.input[3].doubleValue())) {
                this.lowerSoftLimit.setForeground(new Color(null, 255, 0, 0));
                this.upperThresholdLimit.setForeground(new Color(null, 255, 0, 0));
                this.lowerSoftDecorator.setDescriptionText(ERROR_LOWER_SOFT_HIGHER_UPPER_HARD);
                this.upperHardLimitDecorator.setDescriptionText(ERROR_LOWER_SOFT_HIGHER_UPPER_HARD);
                this.lowerSoftDecorator.show();
                this.upperHardLimitDecorator.show();
                this.setErrorMessage(ERROR_LOWER_SOFT_HIGHER_UPPER_HARD);
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private float getDPIScale() {
        int currentDPI = Display.getDefault().getDPI().x;
        float defaultDPI = 96.0f;
        return (float)currentDPI / defaultDPI;
    }

    private void setImage() {
        Bundle bundle = Platform.getBundle((String)"org.palladiosimulator.measurementsui.wizard");
        URL fullPathString = BundleUtility.find((Bundle)bundle, (String)"icons/wizardImage.png");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)fullPathString);
        ImageData imageData = imageDescriptor.getImageData();
        int scaledWidth = Math.round((float)imageData.width / (1.5f / this.getDPIScale()));
        int scaledHeight = Math.round((float)imageData.height / (1.5f / this.getDPIScale()));
        if (scaledWidth < 100) {
            scaledWidth = 100;
        }
        if (scaledHeight < 100) {
            scaledHeight = 100;
        }
        ImageData scaledImageData = imageData.scaledTo(scaledWidth, scaledHeight);
        ImageDescriptor resizedImageDescriptor = ImageDescriptor.createFromImageData((ImageData)scaledImageData);
        this.setImageDescriptor(resizedImageDescriptor);
    }

    public void performHelp() {
        Program.launch((String)HELP_URL);
    }
}

