/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizard.pages;

import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementsui.wizard.handlers.contentprovider.AlternativeMeasuringPointContentProvider;
import org.palladiosimulator.measurementsui.wizard.handlers.contentprovider.ExistingMeasuringpointContentProvider;
import org.palladiosimulator.measurementsui.wizard.handlers.contentprovider.MeasuringPointsContentProvider;
import org.palladiosimulator.measurementsui.wizard.handlers.labelprovider.AlternativeMeasuringPointLabelProvider;
import org.palladiosimulator.measurementsui.wizard.handlers.labelprovider.ExistingMeasuringpointLabelProvider;
import org.palladiosimulator.measurementsui.wizard.handlers.labelprovider.MeasuringPointsLabelProvider;
import org.palladiosimulator.measurementsui.wizard.pages.AdditionalModelsToMeasuringpointWizardPage;
import org.palladiosimulator.measurementsui.wizard.util.ChooseMeasuringPointMessageSwitch;
import org.palladiosimulator.measurementsui.wizardmodel.pages.MeasuringPointSelectionWizardModel;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.subsystem.SubSystem;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

public class ChooseMeasuringpointWizardPage
extends WizardPage {
    private TreeViewer emptyMeasuringpointViewer;
    private TreeViewer createTreeViewer;
    private MeasuringPointSelectionWizardModel selectionWizardModel;
    private boolean selected = false;
    private boolean switchedToHierarchical = false;
    private TabFolder tabFolder;
    private Button[] radios = new Button[2];

    public ChooseMeasuringpointWizardPage(MeasuringPointSelectionWizardModel selectionWizardModel) {
        super("Second Page");
        this.selectionWizardModel = selectionWizardModel;
        this.setTitle(selectionWizardModel.getTitleText());
        this.setDescription(selectionWizardModel.getInfoText());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.setControl((Control)container);
        this.tabFolder = new TabFolder(container, 4);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int tabId = ChooseMeasuringpointWizardPage.this.tabFolder.getSelectionIndex();
                if (tabId == 0) {
                    ChooseMeasuringpointWizardPage.this.setMessage(ChooseMeasuringpointWizardPage.this.selectionWizardModel.getInfoText());
                } else {
                    ChooseMeasuringpointWizardPage.this.setMessage("This is a list of all existing measuring points. You can select one to add it to the monitor.");
                }
            }
        });
        this.createNewMeasuringPointTab();
        this.createExistingMeasuringPointTab();
        this.setSelectedItem(this.selectionWizardModel.isEditing());
    }

    private void createNewMeasuringPointTab() {
        Composite all = new Composite((Composite)this.tabFolder, 0);
        Composite buttonComposite = new Composite(all, 0);
        buttonComposite.setLayout((Layout)new GridLayout(3, false));
        TabItem createMeasuringTabbedItem = new TabItem(this.tabFolder, 0);
        createMeasuringTabbedItem.setText("Create new measuring point");
        GridData parentData = new GridData(4, 4, true, true);
        all.setLayout((Layout)new GridLayout(1, false));
        all.setLayoutData((Object)parentData);
        Composite createMPcomposite = new Composite(all, 4);
        createMPcomposite.setLayout((Layout)new GridLayout(1, true));
        createMPcomposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.radios[0] = new Button(buttonComposite, 16);
        this.radios[0].setSelection(true);
        this.radios[0].setText("Hierarchical");
        this.radios[0].setBounds(10, 5, 75, 30);
        this.radios[1] = new Button(buttonComposite, 16);
        this.radios[1].setText("Flat");
        this.radios[1].setBounds(10, 30, 75, 30);
        this.radios[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseMeasuringpointWizardPage.this.changeViewToHierarchical();
            }
        });
        this.radios[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseMeasuringpointWizardPage.this.changeViewToFlat();
            }
        });
        AlternativeMeasuringPointContentProvider createContentProvider = new AlternativeMeasuringPointContentProvider(this.selectionWizardModel);
        PatternFilter filter = new PatternFilter();
        FilteredTree tree = new FilteredTree(createMPcomposite, 772, filter, true);
        this.createTreeViewer = tree.getViewer();
        this.createTreeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTreeViewer.setContentProvider((IContentProvider)createContentProvider);
        this.createTreeViewer.setInput((Object)this.selectionWizardModel.getAllSecondPageObjects());
        this.createTreeViewer.setLabelProvider((IBaseLabelProvider)new AlternativeMeasuringPointLabelProvider());
        this.createTreeViewer.getTree().getItem(0).setExpanded(true);
        this.createTreeViewer.refresh();
        this.createTreeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = (TreeItem)e.item;
                if (item != null && ChooseMeasuringpointWizardPage.this.isMeasuringPointCreatable(item.getData())) {
                    ChooseMeasuringpointWizardPage.this.selectionWizardModel.setFinishable(true);
                    ChooseMeasuringpointWizardPage.this.getContainer().updateButtons();
                    ChooseMeasuringpointWizardPage.this.setPageComplete(true);
                    ChooseMeasuringpointWizardPage.this.showMessage(item);
                } else if (ChooseMeasuringpointWizardPage.this.switchedToHierarchical && ChooseMeasuringpointWizardPage.this.radios[0].getSelection()) {
                    ChooseMeasuringpointWizardPage.this.selectionWizardModel.setFinishable(false);
                    ChooseMeasuringpointWizardPage.this.setPageComplete(false);
                    ChooseMeasuringpointWizardPage.this.getContainer().updateButtons();
                    ChooseMeasuringpointWizardPage.this.setMessage(String.valueOf(ChooseMeasuringpointWizardPage.this.selectionWizardModel.getInfoText()) + " This is the hierarchical view of your models.");
                } else {
                    ChooseMeasuringpointWizardPage.this.selectionWizardModel.setFinishable(false);
                    ChooseMeasuringpointWizardPage.this.setPageComplete(false);
                    ChooseMeasuringpointWizardPage.this.getContainer().updateButtons();
                    ChooseMeasuringpointWizardPage.this.setErrorMessage("Choose a model for which a measuring point will be created.");
                }
                ChooseMeasuringpointWizardPage.this.switchedToHierarchical = false;
            }
        });
        this.createTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ChooseMeasuringpointWizardPage.this.isMeasuringPointCreatable(ChooseMeasuringpointWizardPage.this.createTreeViewer.getStructuredSelection().getFirstElement())) {
                    ChooseMeasuringpointWizardPage.this.performAddingOperations();
                    ChooseMeasuringpointWizardPage.this.getContainer().showPage(ChooseMeasuringpointWizardPage.this.getNextPage());
                }
            }
        });
        Label label = new Label(createMPcomposite, 0);
        label.setText("Models for which a measuring point can be created are highlighted with a bold font.");
        label.setVisible(true);
        label.setEnabled(true);
        createMeasuringTabbedItem.setControl((Control)all);
    }

    private void createExistingMeasuringPointTab() {
        TabItem existingMeasuringTabbedItem = new TabItem(this.tabFolder, 4);
        existingMeasuringTabbedItem.setText("Select existing measuring point");
        Composite all = new Composite((Composite)this.tabFolder, 0);
        GridData parentData = new GridData(4, 4, true, true);
        all.setLayout((Layout)new GridLayout(1, false));
        all.setLayoutData((Object)parentData);
        Composite buttonComposite = new Composite(all, 0);
        Label fillerLabel = new Label(buttonComposite, 0x1000000);
        fillerLabel.setText("             ");
        fillerLabel.setBounds(10, 5, 75, 30);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        Composite existingMPcomposite = new Composite(all, 4);
        existingMPcomposite.setLayout((Layout)new GridLayout(1, true));
        existingMPcomposite.setLayoutData((Object)new GridData(4, 4, true, true));
        PatternFilter filter = new PatternFilter();
        FilteredTree tree = new FilteredTree(existingMPcomposite, 772, filter, true);
        this.emptyMeasuringpointViewer = tree.getViewer();
        this.emptyMeasuringpointViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.emptyMeasuringpointViewer.setContentProvider((IContentProvider)new ExistingMeasuringpointContentProvider(this.selectionWizardModel));
        this.emptyMeasuringpointViewer.setInput((Object)this.selectionWizardModel.getExistingMeasuringPoints());
        this.emptyMeasuringpointViewer.setLabelProvider((IBaseLabelProvider)new ExistingMeasuringpointLabelProvider());
        this.emptyMeasuringpointViewer.refresh();
        this.emptyMeasuringpointViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = (TreeItem)e.item;
                if (item.getData() instanceof MeasuringPoint) {
                    ChooseMeasuringpointWizardPage.this.selectionWizardModel.setFinishable(true);
                    ChooseMeasuringpointWizardPage.this.getContainer().updateButtons();
                    ChooseMeasuringpointWizardPage.this.setPageComplete(true);
                    ChooseMeasuringpointWizardPage.this.showMessage(item);
                }
            }
        });
        this.emptyMeasuringpointViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ChooseMeasuringpointWizardPage.this.isMeasuringPointCreatable(ChooseMeasuringpointWizardPage.this.emptyMeasuringpointViewer.getStructuredSelection().getFirstElement())) {
                    ChooseMeasuringpointWizardPage.this.performAddingOperations();
                    ChooseMeasuringpointWizardPage.this.getContainer().showPage(ChooseMeasuringpointWizardPage.this.getNextPage());
                }
            }
        });
        existingMeasuringTabbedItem.setControl((Control)all);
    }

    public IWizardPage getNextPage() {
        boolean isNextPressed = "nextPressed".equalsIgnoreCase(Thread.currentThread().getStackTrace()[2].getMethodName());
        if (isNextPressed) {
            this.performAddingOperations();
        }
        if (this.selected) {
            AdditionalModelsToMeasuringpointWizardPage page = (AdditionalModelsToMeasuringpointWizardPage)super.getWizard().getPage("additionalModelsToMeasuringpointWizardPage");
            page.loadData();
            return page;
        }
        return super.getNextPage();
    }

    public void showMessage(TreeItem item) {
        ChooseMeasuringPointMessageSwitch messageSwitch = new ChooseMeasuringPointMessageSwitch();
        messageSwitch.setSelectionWizardModel(this.selectionWizardModel);
        this.setErrorMessage(null);
        this.setMessage((String)messageSwitch.doSwitch((EObject)item.getData()));
    }

    public void performAddingOperations() {
        this.getContainer().updateButtons();
        if (this.tabFolder.getSelectionIndex() == 1) {
            if (this.emptyMeasuringpointViewer.getStructuredSelection().getFirstElement() instanceof MeasuringPoint) {
                this.setErrorMessage(null);
                this.setPageComplete(true);
                this.selectionWizardModel.setMeasuringPointDependingOnEditMode((MeasuringPoint)this.emptyMeasuringpointViewer.getStructuredSelection().getFirstElement());
            }
        } else if (this.createTreeViewer.getStructuredSelection().getFirstElement() instanceof AssemblyContext || this.createTreeViewer.getStructuredSelection().getFirstElement() instanceof SubSystem || this.createTreeViewer.getStructuredSelection().getFirstElement() instanceof System) {
            this.selectionWizardModel.setCurrentSelection(this.createTreeViewer.getStructuredSelection().getFirstElement());
            this.selected = true;
        } else {
            this.selectionWizardModel.setCurrentSelection(this.createTreeViewer.getStructuredSelection().getFirstElement());
            this.selectionWizardModel.createMeasuringPoint(this.createTreeViewer.getStructuredSelection().getFirstElement());
            this.selected = false;
        }
    }

    private void changeViewToHierarchical() {
        this.setErrorMessage(null);
        AlternativeMeasuringPointLabelProvider createLabelProvider = new AlternativeMeasuringPointLabelProvider();
        this.createTreeViewer.setLabelProvider((IBaseLabelProvider)createLabelProvider);
        AlternativeMeasuringPointContentProvider createContentProvider = new AlternativeMeasuringPointContentProvider(this.selectionWizardModel);
        this.createTreeViewer.setContentProvider((IContentProvider)createContentProvider);
        this.setMessage(String.valueOf(this.selectionWizardModel.getInfoText()) + " This is the hierarchical view of your models.");
        this.setPageComplete(false);
        this.getContainer().updateButtons();
        this.createTreeViewer.getTree().update();
        this.switchedToHierarchical = true;
    }

    private void changeViewToFlat() {
        this.setErrorMessage(null);
        MeasuringPointsContentProvider createContentProvider = new MeasuringPointsContentProvider(this.selectionWizardModel);
        this.createTreeViewer.setContentProvider((IContentProvider)createContentProvider);
        MeasuringPointsLabelProvider createLabelProvider = new MeasuringPointsLabelProvider();
        this.createTreeViewer.setLabelProvider((IBaseLabelProvider)createLabelProvider);
        this.setMessage(String.valueOf(this.selectionWizardModel.getInfoText()) + " This is the flat view of your models.");
        this.setPageComplete(false);
        this.getContainer().updateButtons();
        this.createTreeViewer.getTree().update();
        this.switchedToHierarchical = false;
    }

    private void setSelectedItem(boolean isEditing) {
        if (isEditing && this.selectionWizardModel.getMonitor().getMeasuringPoint() != null) {
            this.tabFolder.setSelection(1);
            StructuredSelection selection = new StructuredSelection((Object)this.selectionWizardModel.getMonitor().getMeasuringPoint());
            this.emptyMeasuringpointViewer.setSelection((ISelection)selection);
            this.selectionWizardModel.setFinishable(true);
            this.setPageComplete(true);
            this.getContainer().updateButtons();
        } else if (this.selectionWizardModel.getAllSecondPageObjects().length != 0) {
            LinkedList temp = (LinkedList)this.selectionWizardModel.getAllSecondPageObjects()[0];
            for (Object chooseSelectedObject : temp) {
                if (!this.isMeasuringPointCreatable(chooseSelectedObject)) continue;
                StructuredSelection selection = new StructuredSelection(chooseSelectedObject);
                this.createTreeViewer.setSelection((ISelection)selection);
                this.selectionWizardModel.setFinishable(true);
                this.setPageComplete(true);
                this.getContainer().updateButtons();
                break;
            }
        }
    }

    private boolean isMeasuringPointCreatable(Object item) {
        return item instanceof MeasuringPoint || item instanceof ResourceEnvironment || item instanceof ResourceContainer || item instanceof ProcessingResourceSpecification || item instanceof AssemblyContext || item instanceof EntryLevelSystemCall || item instanceof ExternalCallAction || item instanceof LinkingResource || item instanceof SubSystem || item instanceof System || item instanceof UsageScenario;
    }

    public void performHelp() {
        Program.launch((String)"https://sdqweb.ipd.kit.edu/wiki/SimuLizar_Usability_Extension#Measuring_Point_Selection_Page");
    }
}

