/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizard.pages;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.measurementsui.wizardmodel.pages.MonitorCreationWizardModel;

public class MonitorCreationWizardPage
extends WizardPage {
    private MonitorCreationWizardModel model;

    public MonitorCreationWizardPage(MonitorCreationWizardModel model) {
        super("First Page");
        this.model = model;
        this.setTitle(model.getTitleText());
        this.setDescription(model.getInfoText());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setGridLayout(container);
        this.addLabel(container, "Name: ");
        this.addTextBox(container);
        this.addLabel(container, "Activated: ");
        this.addCheckbox(container);
        this.setControl((Control)container);
        this.setPageComplete(true);
    }

    private void setGridLayout(Composite container) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
    }

    private void addLabel(Composite container, String labelText) {
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(labelText);
    }

    private void addTextBox(Composite container) {
        Text nameText = new Text(container, 2048);
        nameText.setText(this.model.getMonitor().getEntityName());
        nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        nameText.addModifyListener(e -> {
            this.model.setMonitorName(nameText.getText());
            if (nameText.getText().length() > 0) {
                this.setPageComplete(true);
            } else {
                this.setPageComplete(false);
            }
        });
    }

    private void addCheckbox(Composite container) {
        final Button activatedCheckbox = new Button(container, 32);
        activatedCheckbox.setSelection(this.model.getMonitor().isActivated());
        activatedCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MonitorCreationWizardPage.this.model.setMonitorActivated(activatedCheckbox.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void performHelp() {
        Program.launch((String)"https://sdqweb.ipd.kit.edu/wiki/SimuLizar_Usability_Extension#Monitor_Creation_Page");
    }
}

