/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizard.pages;

import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.util.BundleUtility;
import org.osgi.framework.Bundle;
import org.palladiosimulator.measurementsui.wizardmodel.pages.SloCreationWizardModel;

public class ServiceLevelObjectiveCreationPage
extends WizardPage {
    private SloCreationWizardModel pageModel;
    private Text text_name;
    private Text text_description;
    private ControlDecoration nameTextDecorator;
    private static final String ERROR_SLO_NAME_EMPTY = "The name of the Service Level Objective can not be empty.";
    private static final String HELP_URL = "https://sdqweb.ipd.kit.edu/wiki/SimuLizar_Usability_Extension#User_Guide";

    public ServiceLevelObjectiveCreationPage(SloCreationWizardModel model) {
        super("First Page");
        this.pageModel = model;
        this.setTitle(model.getTitleText());
        this.setMessage(model.getInfoText(), 1);
    }

    public void createControl(Composite parent) {
        this.setImage();
        Composite contentContainer = new Composite(parent, 2048);
        this.setControl((Control)contentContainer);
        contentContainer.setLayout((Layout)new GridLayout(2, false));
        Label lblNewLabel = new Label(contentContainer, 0);
        lblNewLabel.setBounds(0, 0, 55, 15);
        lblNewLabel.setText("Name:");
        this.text_name = new Text(contentContainer, 2048);
        this.text_name.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ServiceLevelObjectiveCreationPage.this.pageModel.setName(ServiceLevelObjectiveCreationPage.this.text_name.getText());
                if (ServiceLevelObjectiveCreationPage.this.pageModel.getName().isEmpty()) {
                    ServiceLevelObjectiveCreationPage.this.setPageComplete(false);
                    ServiceLevelObjectiveCreationPage.this.setErrorMessage(ServiceLevelObjectiveCreationPage.ERROR_SLO_NAME_EMPTY);
                    ServiceLevelObjectiveCreationPage.this.nameTextDecorator.show();
                } else {
                    ServiceLevelObjectiveCreationPage.this.setPageComplete(true);
                    ServiceLevelObjectiveCreationPage.this.setErrorMessage(null);
                    ServiceLevelObjectiveCreationPage.this.nameTextDecorator.hide();
                }
            }
        });
        GridData gd_text_name = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_text_name.widthHint = 495;
        this.text_name.setLayoutData((Object)gd_text_name);
        this.text_name.setBounds(0, 0, 76, 21);
        if (this.pageModel.getSlo().getName() != null) {
            String name = this.pageModel.getSlo().getName();
            this.text_name.setText(name);
            this.pageModel.setName(name);
            this.setPageComplete(true);
        } else {
            this.text_name.setText("");
        }
        Label lblDescription = new Label(contentContainer, 0);
        lblDescription.setBounds(0, 0, 55, 15);
        lblDescription.setText("Description:");
        this.text_description = new Text(contentContainer, 2048);
        this.text_description.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ServiceLevelObjectiveCreationPage.this.pageModel.setDescription(ServiceLevelObjectiveCreationPage.this.text_description.getText());
            }
        });
        GridData gd_text_description = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_text_description.widthHint = 495;
        this.text_description.setLayoutData((Object)gd_text_description);
        this.text_description.setBounds(0, 0, 76, 21);
        try {
            String description = this.pageModel.getSlo().getDescription();
            this.text_description.setText(description);
            this.pageModel.setDescription(description);
        }
        catch (Exception exception) {
            this.text_description.setText("");
        }
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.nameTextDecorator = new ControlDecoration((Control)this.text_name, 0x1000000);
        this.nameTextDecorator.setImage(image);
        this.nameTextDecorator.setMarginWidth(1);
        this.nameTextDecorator.hide();
        if (this.text_name.getText().isEmpty()) {
            this.setPageComplete(false);
        }
    }

    private float getDPIScale() {
        int currentDPI = Display.getDefault().getDPI().x;
        float defaultDPI = 96.0f;
        return (float)currentDPI / defaultDPI;
    }

    private void setImage() {
        Bundle bundle = Platform.getBundle((String)"org.palladiosimulator.measurementsui.wizard");
        URL fullPathString = BundleUtility.find((Bundle)bundle, (String)"icons/wizardImage.png");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)fullPathString);
        ImageData imageData = imageDescriptor.getImageData();
        int scaledWidth = Math.round((float)imageData.width / (1.5f / this.getDPIScale()));
        int scaledHeight = Math.round((float)imageData.height / (1.5f / this.getDPIScale()));
        if (scaledWidth < 100) {
            scaledWidth = 100;
        }
        if (scaledHeight < 100) {
            scaledHeight = 100;
        }
        ImageData scaledImageData = imageData.scaledTo(scaledWidth, scaledHeight);
        ImageDescriptor resizedImageDescriptor = ImageDescriptor.createFromImageData((ImageData)scaledImageData);
        this.setImageDescriptor(resizedImageDescriptor);
    }

    public void performHelp() {
        Program.launch((String)HELP_URL);
    }
}

