/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizard.pages;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementsui.dataprovider.StandardSetCreationProvider;
import org.palladiosimulator.monitorrepository.Monitor;

public class StandardSetMeasuringPointSelectionWizardPage
extends WizardPage {
    private CheckboxTableViewer viewer;
    private boolean loadMonitorAndMeasuringpoint = true;
    private Composite composite;
    private StandardSetCreationProvider set;

    public boolean isLoadMonitorAndMeasuringpoint() {
        return this.loadMonitorAndMeasuringpoint;
    }

    public void setLoadMonitorAndMeasuringpoint(boolean add) {
        this.loadMonitorAndMeasuringpoint = add;
    }

    public CheckboxTableViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(CheckboxTableViewer viewer) {
        this.viewer = viewer;
    }

    public StandardSetMeasuringPointSelectionWizardPage(String pageName) {
        super("standardSetMeasuringPointSelectionWizardPage");
        this.setMessage(pageName);
        this.set = new StandardSetCreationProvider();
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createStructure();
        this.setControl((Control)this.composite);
        this.setPageComplete(true);
    }

    private void createStructure() {
        Composite tableviewerComposite = new Composite(this.composite, 4);
        tableviewerComposite.setLayout((Layout)new GridLayout(1, false));
        tableviewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = CheckboxTableViewer.newCheckList((Composite)tableviewerComposite, (int)2048);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite buttonComposite = new Composite(this.composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        Button selectAll = new Button(buttonComposite, 8);
        selectAll.setText("Select all");
        selectAll.setLayoutData((Object)new GridData(4, 4, true, false));
        selectAll.addListener(13, e -> this.viewer.setAllChecked(true));
        Button unselectAll = new Button(buttonComposite, 8);
        unselectAll.setText("Unselect all");
        unselectAll.setLayoutData((Object)new GridData(4, 4, true, false));
        unselectAll.addListener(13, e -> this.viewer.setAllChecked(false));
    }

    public void loadMonitorAndMeasuringpointInput() {
        this.createColumns((TableViewer)this.viewer);
        this.setMessage("Select all monitors which should be created.");
        this.loadMonitorAndMeasuringpoint = true;
        this.viewer.setInput((Object)this.set.createMonitorForEveryResource().toArray());
        this.viewer.refresh();
    }

    public void loadOnlyMeasuringpointInput() {
        this.createMeasuringpointColumns((TableViewer)this.viewer);
        this.setMessage("Select all measuringpoints which should be created.");
        this.loadMonitorAndMeasuringpoint = false;
        LinkedList<MeasuringPoint> measuringpoints = new LinkedList<MeasuringPoint>();
        List monitors = this.set.createMonitorForEveryResource();
        for (Monitor monitor : monitors) {
            measuringpoints.add(monitor.getMeasuringPoint());
        }
        this.viewer.setInput((Object)measuringpoints.toArray());
        this.viewer.refresh();
    }

    private void createColumns(TableViewer viewer) {
        TableColumn[] tableColumnArray = viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            tc.dispose();
            ++n2;
        }
        TableViewerColumn col = this.createTableViewerColumn("Create", 50);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }
        });
        col = this.createTableViewerColumn("Monitor", 200);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Monitor p = (Monitor)element;
                return p.getEntityName();
            }
        });
        col = this.createTableViewerColumn("Measuring Point", 400);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Monitor p = (Monitor)element;
                return p.getMeasuringPoint().getStringRepresentation();
            }
        });
    }

    private void createMeasuringpointColumns(TableViewer viewer) {
        TableColumn[] tableColumnArray = viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            tc.dispose();
            ++n2;
        }
        TableViewerColumn col = this.createTableViewerColumn("Create", 50);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }
        });
        col = this.createTableViewerColumn("Measuring Point", 400);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MeasuringPoint p = (MeasuringPoint)element;
                return p.getStringRepresentation();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public void performHelp() {
        Program.launch((String)"https://sdqweb.ipd.kit.edu/wiki/SimuLizar_Usability_Extension#Standard_Set_Functionality");
    }
}

