/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizard.pages;

import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.internal.util.BundleUtility;
import org.osgi.framework.Bundle;
import org.palladiosimulator.measurementsui.wizardmodel.pages.SloMeasurementSpecSelectionWizardModel;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Monitor;

public class ServiceLevelObjectiveMeasurementSelectionPage
extends WizardPage {
    private SloMeasurementSpecSelectionWizardModel pageModel;
    private String[] titles = new String[]{"Monitor", "Name", "Metric Description", "Processing Type", "ID"};
    private static final String HELP_URL = "https://sdqweb.ipd.kit.edu/wiki/SimuLizar_Usability_Extension#User_Guide";
    private Composite composite;
    private Table table;

    public ServiceLevelObjectiveMeasurementSelectionPage(SloMeasurementSpecSelectionWizardModel model) {
        super("Second Page");
        this.pageModel = model;
        this.setTitle(model.getTitleText());
        this.setMessage(model.getInfoText(), 1);
        this.setImage();
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)this.composite);
        this.composite.setLayout((Layout)new FillLayout(256));
        this.table = new Table(this.composite, 67584);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = ServiceLevelObjectiveMeasurementSelectionPage.this.table.getSelection();
                MeasurementSpecification measurementSpec = (MeasurementSpecification)items[0].getData();
                ServiceLevelObjectiveMeasurementSelectionPage.this.pageModel.setMeasurementSpecificationTmp(measurementSpec);
                ServiceLevelObjectiveMeasurementSelectionPage.this.setPageComplete(true);
            }
        });
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.createColumns();
        this.fillTable();
        MeasurementSpecification msp = this.pageModel.getSlo().getMeasurementSpecification();
        if (msp != null) {
            int index = 0;
            String selectedID = msp.getId();
            int i = 0;
            while (i < this.table.getItemCount()) {
                if (selectedID.equals(this.table.getItem(i).getText(4))) {
                    index = i;
                }
                ++i;
            }
            this.table.setSelection(index);
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private void createColumns() {
        int loopIndex = 0;
        while (loopIndex < this.titles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(this.titles[loopIndex]);
            ++loopIndex;
        }
    }

    private void fillTable() {
        for (Monitor monitor : this.pageModel.getMonitors()) {
            for (MeasurementSpecification measurementSpec : this.pageModel.getMeasurementSpecs(monitor)) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(0, monitor.getEntityName());
                item.setText(1, measurementSpec.getName());
                item.setText(2, measurementSpec.getMetricDescription().toString());
                item.setText(3, measurementSpec.getProcessingType().toString());
                item.setText(4, measurementSpec.getId().toString());
                item.setData((Object)measurementSpec);
            }
        }
        int loopIndex = 0;
        while (loopIndex < this.titles.length) {
            this.table.getColumn(loopIndex).pack();
            ++loopIndex;
        }
    }

    private float getDPIScale() {
        int currentDPI = Display.getDefault().getDPI().x;
        float defaultDPI = 96.0f;
        return (float)currentDPI / defaultDPI;
    }

    private void setImage() {
        Bundle bundle = Platform.getBundle((String)"org.palladiosimulator.measurementsui.wizard");
        URL fullPathString = BundleUtility.find((Bundle)bundle, (String)"icons/wizardImage.png");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)fullPathString);
        ImageData imageData = imageDescriptor.getImageData();
        int scaledWidth = Math.round((float)imageData.width / (1.5f / this.getDPIScale()));
        int scaledHeight = Math.round((float)imageData.height / (1.5f / this.getDPIScale()));
        if (scaledWidth < 100) {
            scaledWidth = 100;
        }
        if (scaledHeight < 100) {
            scaledHeight = 100;
        }
        ImageData scaledImageData = imageData.scaledTo(scaledWidth, scaledHeight);
        ImageDescriptor resizedImageDescriptor = ImageDescriptor.createFromImageData((ImageData)scaledImageData);
        this.setImageDescriptor(resizedImageDescriptor);
    }

    public void performHelp() {
        Program.launch((String)HELP_URL);
    }
}

