package org.palladiosimulator.measurementsui.processingtype;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.emf.parsley.runtime.ui.PluginUtil;
import org.palladiosimulator.measurementsui.processingtype.ProcessingtypeEmfParsleyGuiceModule;

@SuppressWarnings("all")
public class ProcessingtypeInjectorProvider {
  private static Injector injector;
  
  public static synchronized Injector getInjector() {
    if (injector == null) {
      injector = Guice.createInjector(
        new ProcessingtypeEmfParsleyGuiceModule(PluginUtil.getPlugin(
          PluginUtil.getBundle(ProcessingtypeInjectorProvider.class))));
    }
    return injector;
  }
}
