/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.ui.measurementsdashboard.filter;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.ProcessingType;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjectiveRepository;
import org.palladiosimulator.servicelevelobjective.Threshold;

public class MeasurementsFilter
extends ViewerFilter {
    private String searchText;
    private boolean filterActiveMonitors;
    private boolean filterInactiveMonitors;

    public void setSearchText(String searchText) {
        this.searchText = (".*" + searchText + ".*").trim().replace(" ", "").toLowerCase();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        TreeViewer treeViewer = (TreeViewer)viewer;
        if (this.searchText == null || this.searchText.length() == 0 || element instanceof MonitorRepository || element instanceof MeasuringPointRepository) {
            return true;
        }
        try {
            if (element instanceof Monitor) {
                return this.filterMonitor(element, treeViewer);
            }
            if (element instanceof MeasurementSpecification) {
                return this.filterMeasurementSpecification(element, treeViewer);
            }
            if (element instanceof ProcessingType) {
                return this.filterProcessingType(element);
            }
            if (element instanceof MeasuringPoint) {
                return this.filterMeasuringPoint(element);
            }
            if (element instanceof ServiceLevelObjectiveRepository) {
                return this.filterServiceLevelObjectiveRepository(element, treeViewer);
            }
            if (element instanceof ServiceLevelObjective) {
                return this.filterServiceLevelObjective(element);
            }
            if (element instanceof Threshold) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private boolean filterMonitor(Object element, TreeViewer treeViewer) {
        Monitor monitor = (Monitor)element;
        if (this.filterActiveMonitors && monitor.isActivated()) {
            return false;
        }
        if (this.filterInactiveMonitors && !monitor.isActivated()) {
            return false;
        }
        String monitorMatch = String.valueOf(monitor.getEntityName()) + "$" + monitor.getId() + "$" + monitor.toString() + "$monitor";
        MeasuringPoint measuringPointFromMonitor = monitor.getMeasuringPoint();
        if (measuringPointFromMonitor != null) {
            monitorMatch = String.valueOf(monitorMatch) + "$" + monitor.getMeasuringPoint().getStringRepresentation() + "$" + monitor.getMeasuringPoint().toString();
        }
        if (monitorMatch.replace(" ", "").trim().toLowerCase().matches(this.searchText)) {
            return true;
        }
        for (MeasurementSpecification measurement : monitor.getMeasurementSpecifications()) {
            if (!this.select((Viewer)treeViewer, monitor, measurement)) continue;
            treeViewer.setExpandedState(element, true);
            return true;
        }
        return false;
    }

    private boolean filterMeasurementSpecification(Object element, TreeViewer treeViewer) {
        MeasurementSpecification measurement = (MeasurementSpecification)element;
        String measurementSpecificationMatch = String.valueOf(measurement.getName()) + "$" + measurement.getId() + "$" + measurement.getMetricDescription().getName() + "$" + measurement.getMetricDescription().getId() + "$" + measurement.getMetricDescription().getTextualDescription() + "$MeasurementSpecification$MetricDescription";
        if (this.select((Viewer)treeViewer, measurement, measurement.getProcessingType())) {
            treeViewer.setExpandedState(element, true);
            return true;
        }
        return this.measurementMatchesSearchText(measurementSpecificationMatch, this.searchText);
    }

    private boolean filterProcessingType(Object element) {
        ProcessingType processing = (ProcessingType)element;
        String processingTypeMatch = String.valueOf(processing.getId()) + "$" + processing.toString() + "$ProcessingType";
        return this.measurementMatchesSearchText(processingTypeMatch, this.searchText);
    }

    private boolean filterMeasuringPoint(Object element) {
        MeasuringPoint measuringPoint = (MeasuringPoint)element;
        String measuringPointMatch = String.valueOf(measuringPoint.getStringRepresentation()) + "$" + measuringPoint.toString() + "$MeasuringPoint";
        return this.measurementMatchesSearchText(measuringPointMatch, this.searchText);
    }

    private boolean filterServiceLevelObjectiveRepository(Object element, TreeViewer treeViewer) {
        ServiceLevelObjectiveRepository sloRepo = (ServiceLevelObjectiveRepository)element;
        EList slos = sloRepo.eContents();
        treeViewer.setExpandedState(element, false);
        for (EObject slo : slos) {
            if (!this.select((Viewer)treeViewer, sloRepo, slo)) continue;
            treeViewer.setExpandedState(element, true);
            return true;
        }
        return true;
    }

    private boolean filterServiceLevelObjective(Object element) {
        ServiceLevelObjective slo = (ServiceLevelObjective)element;
        String serviceLevelObjectiveMatch = String.valueOf(slo.getName()) + "$" + slo.getId() + "$" + slo.getDescription() + "$" + slo.getMeasurementSpecification() + "$" + "$ServiceLevelObjective";
        return this.measurementMatchesSearchText(serviceLevelObjectiveMatch, this.searchText);
    }

    private boolean measurementMatchesSearchText(String measurementMatch, String searchText) {
        return measurementMatch.replace(" ", "").trim().toLowerCase().matches(searchText);
    }

    public void setFilterActiveMonitors(boolean filterActiveMonitors) {
        this.filterActiveMonitors = filterActiveMonitors;
    }

    public void setFilterInactiveMonitors(boolean filterInactiveMonitors) {
        this.filterInactiveMonitors = filterInactiveMonitors;
    }
}

